/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import java.io.File;

public class PlatformUtil {
    public static final String CONTROL_KEY_NAME;
    public static final int CONTROL_KEY_MASK;
    static final int PLAT_UNINIT = -2;
    static final int PLAT_UNDEFINED = -1;
    static final int PLAT_WINDOWS = 0;
    static final int PLAT_MAC = 1;
    static final int PLAT_SOLARIS = 2;
    static final int PLAT_LINUX = 3;
    static final int PLAT_OS2 = 4;
    static final int PLAT_HPUX = 5;
    static final int PLAT_AIX = 6;
    static final int PLAT_NETWARE = 7;
    protected static int g_iPlatform;

    public static int getPlatform() {
        try {
            String strOSName;
            if (g_iPlatform == -2 && (strOSName = System.getProperty("os.name")) != null) {
                g_iPlatform = (strOSName = strOSName.toLowerCase()).startsWith("windows") ? 0 : (strOSName.startsWith("mac") ? 1 : (strOSName.startsWith("solaris") ? 2 : (strOSName.startsWith("linux") ? 3 : (strOSName.startsWith("os/2") ? 4 : (strOSName.startsWith("aix") ? 6 : (strOSName.startsWith("hp") ? 5 : (strOSName.startsWith("netware") ? 7 : -1)))))));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return g_iPlatform;
    }

    public static boolean isWindows() {
        return PlatformUtil.getPlatform() == 0;
    }

    public static boolean isMac() {
        return PlatformUtil.getPlatform() == 1;
    }

    public static boolean isSolaris() {
        return PlatformUtil.getPlatform() == 2;
    }

    public static boolean isLinux() {
        return PlatformUtil.getPlatform() == 3;
    }

    public static boolean hasXdgOpen() {
        return new File("/usr/bin/xdg-mime").canExecute();
    }

    static {
        if (PlatformUtil.isMac()) {
            CONTROL_KEY_MASK = 256;
            CONTROL_KEY_NAME = "meta";
        } else {
            CONTROL_KEY_MASK = 128;
            CONTROL_KEY_NAME = "control";
        }
        g_iPlatform = -2;
    }
}

