/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.Scheme;
import editor.actions.UpdateNotifier;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SmartMenuItem
extends JMenuItem
implements ChangeListener {
    public SmartMenuItem(Action action) {
        this(action, true);
    }

    public SmartMenuItem(Action action, boolean autoEnable) {
        super(action);
        if (autoEnable) {
            UpdateNotifier.instance().addActionComponent(this);
        }
        this.init();
    }

    public SmartMenuItem(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    private void init() {
        this.setBorderPainted(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setBackground(Scheme.active().getMenu());
        this.setOpaque(true);
        this.addChangeListener(this);
    }

    public void handleArmed() {
        if (this.isEnabled()) {
            this.setBorderPainted(true);
            if (this.getModel().isArmed()) {
                this.setBackground(Scheme.active().getXpHighlightSelectedColor());
            } else {
                this.setBackground(Scheme.active().getXpHighlightColor());
            }
        }
    }

    public void handleUnarmed() {
        this.setBorderPainted(false);
        this.setBackground(Scheme.active().getMenu());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.isArmed() && !this.isSelected()) {
            this.handleArmed();
        } else {
            this.handleUnarmed();
        }
    }
}

