/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.CommonMenus;
import editor.EditorHost;
import editor.FileTreeUtil;
import editor.GosuEditor;
import editor.IContextMenuHandler;
import editor.IScriptEditor;
import editor.LabFrame;
import editor.run.IRunConfig;
import editor.util.Experiment;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.function.Supplier;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.text.BadLocationException;

public class DefaultContextMenuHandler
implements IContextMenuHandler<IScriptEditor> {
    @Override
    public JPopupMenu getContextMenu(IScriptEditor editor) {
        JPopupMenu menu = new JPopupMenu();
        Supplier<EditorHost> contextEditor = () -> (EditorHost)((Object)editor);
        Supplier<GosuEditor> contextGosuEditor = () -> editor instanceof GosuEditor ? (GosuEditor)editor : null;
        menu.add(CommonMenus.makeCut(contextEditor));
        menu.add(CommonMenus.makeCopy(contextEditor));
        menu.add(CommonMenus.makePaste(contextEditor));
        menu.add(CommonMenus.makePasteJavaAsGosu(contextGosuEditor));
        menu.add(new JSeparator());
        menu.add(CommonMenus.makeFindUsages(FileTreeUtil::getRoot));
        menu.add(new JSeparator());
        menu.add(CommonMenus.makeCodeComplete(contextGosuEditor));
        menu.add(new JSeparator());
        menu.add(CommonMenus.makeParameterInfo(contextGosuEditor));
        menu.add(CommonMenus.makeExpressionType(contextGosuEditor));
        menu.add(new JSeparator());
        menu.add(CommonMenus.makeGotoDeclaration(contextGosuEditor));
        menu.add(new JSeparator());
        menu.add(CommonMenus.makeShowFileInTree(contextEditor));
        menu.add(new JSeparator());
        menu.add(CommonMenus.makeQuickDocumentation(contextGosuEditor));
        if (editor.getScriptPart() != null && editor.getScriptPart().getContainingType() != null) {
            menu.add(new JSeparator());
            menu.add(CommonMenus.makeViewCompile());
            menu.add(new JSeparator());
            menu.add(CommonMenus.makeViewBytecode());
            menu.add(new JSeparator());
            menu.add(CommonMenus.makeRun(() -> this.getOrCreateRunConfig(editor)));
            menu.add(CommonMenus.makeDebug(() -> this.getOrCreateRunConfig(editor)));
        }
        return menu;
    }

    private IRunConfig getOrCreateRunConfig(IScriptEditor editor) {
        return this.getExperiment().getOrCreateRunConfig(editor.getScriptPart().getContainingType());
    }

    private Experiment getExperiment() {
        return LabFrame.instance().getGosuPanel().getExperiment();
    }

    @Override
    public void displayContextMenu(IScriptEditor editor, int iXPos, int iYPos, Component eventSource) {
        try {
            Rectangle rcCaretBounds = editor.getEditor().modelToView(editor.getEditor().getCaretPosition());
            this.getContextMenu(editor).show(editor.getEditor(), rcCaretBounds.x, rcCaretBounds.y + rcCaretBounds.height);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }
}

