/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.CommonMenus;
import editor.FileTree;
import editor.IContextMenuHandler;
import editor.LabFrame;
import editor.NewFilePopup;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import editor.util.PlatformUtil;
import editor.util.SmartMenu;
import editor.util.SmartMenuItem;
import gw.lang.reflect.IType;
import gw.util.PathUtil;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;

public class ExperimentTreeContextMenu
implements IContextMenuHandler<JTree> {
    private static final String CUT_PREFIX = "-CUT-";
    private final Experiment _experiment;

    public ExperimentTreeContextMenu(Experiment experiment) {
        this._experiment = experiment;
    }

    @Override
    public JPopupMenu getContextMenu(JTree tree) {
        IType type;
        JPopupMenu menu = new JPopupMenu();
        SmartMenu newMenu = new SmartMenu("New");
        NewFilePopup.addMenuItems(newMenu);
        menu.add(newMenu);
        menu.add(new JSeparator());
        menu.add(new SmartMenuItem(new OpenAction(tree)));
        menu.add(new JSeparator());
        menu.add(new SmartMenuItem(new OpenOnDesktopAction(tree)));
        menu.add(new JSeparator());
        menu.add(new SmartMenuItem(new ClipCutAction(tree), false));
        menu.add(new SmartMenuItem(new ClipCopyAction(tree), false));
        menu.add(new SmartMenuItem(new ClipPasteAction(tree), false));
        menu.add(new JSeparator());
        menu.add(new SmartMenuItem(new DeleteAction(tree), false));
        menu.add(new JSeparator());
        FileTree item = (FileTree)tree.getLastSelectedPathComponent();
        menu.add(new SmartMenuItem(new CommonMenus.FindInPathActionHandler(() -> item)));
        menu.add(new SmartMenuItem(new CommonMenus.ReplaceInPathActionHandler(() -> item)));
        menu.add(new JSeparator());
        menu.add(new SmartMenuItem(new CommonMenus.FindUsagesInPathActionHandler(() -> item)));
        menu.add(new JSeparator());
        menu.add(new SmartMenuItem(new CommonMenus.CompileActionHandler(() -> item)));
        if (item != null && EditorUtilities.isRunnable(type = item.getType())) {
            menu.add(new JSeparator());
            menu.add(CommonMenus.makeRun(() -> this._experiment.getOrCreateRunConfig(type)));
            menu.add(CommonMenus.makeDebug(() -> this._experiment.getOrCreateRunConfig(type)));
        }
        return menu;
    }

    @Override
    public void displayContextMenu(JTree tree, int x, int y, Component eventSource) {
        tree.requestFocus();
        this.getContextMenu(tree).show(tree, x, y);
    }

    public void copy(Path from, Path to) {
        if (PathUtil.isDirectory((Path)from, (LinkOption[])new LinkOption[0])) {
            PathUtil.mkdir((Path)to, (FileAttribute[])new FileAttribute[0]);
            Path[] children = PathUtil.listFiles((Path)from);
            for (int i = 0; i < children.length; ++i) {
                String name = PathUtil.getName((Path)children[i]);
                this.copy(PathUtil.create((Path)from, (String)name), PathUtil.create((Path)to, (String)name));
            }
        } else {
            try {
                int len;
                InputStream in = PathUtil.createInputStream((Path)from, (OpenOption[])new OpenOption[0]);
                OutputStream out = PathUtil.createOutputStream((Path)to, (OpenOption[])new OpenOption[0]);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    class DeleteAction
    extends ClipCopyAction {
        public DeleteAction(JTree tree) {
            super(tree);
            this.putValue("Name", "Delete");
            this.putValue("MnemonicKey", new Integer(68));
        }

        @Override
        public boolean isEnabled() {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            return item != null && item.canDelete();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            if (item != null) {
                item.delete();
            }
        }
    }

    class ClipCutAction
    extends ClipCopyAction {
        public ClipCutAction(JTree tree) {
            super(tree);
            this.putValue("Name", "Cut");
            this.putValue("MnemonicKey", new Integer(84));
        }

        @Override
        public boolean isEnabled() {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            return item != null && !item.isSourcePathRoot() && item.getParent() != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            if (item != null) {
                Clipboard clipboard = ExperimentTreeContextMenu.this._experiment.getGosuPanel().getClipboard();
                clipboard.setContents(new StringSelection(ExperimentTreeContextMenu.CUT_PREFIX + PathUtil.getAbsolutePathName((Path)item.getFileOrDir())), this);
            }
        }
    }

    class ClipPasteAction
    extends AbstractAction
    implements ClipboardOwner {
        private JTree _tree;

        public ClipPasteAction(JTree tree) {
            super("Paste");
            this.putValue("MnemonicKey", new Integer(80));
            this._tree = tree;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public boolean isEnabled() {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            if (item == null || item.getParent() == null) {
                return false;
            }
            Clipboard clipboard = ExperimentTreeContextMenu.this._experiment.getGosuPanel().getClipboard();
            Transferable t = clipboard.getContents(this);
            try {
                if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String path = (String)t.getTransferData(DataFlavor.stringFlavor);
                    if (path.startsWith(ExperimentTreeContextMenu.CUT_PREFIX)) {
                        path = path.substring(ExperimentTreeContextMenu.CUT_PREFIX.length());
                    }
                    return PathUtil.exists((Path)PathUtil.create((String)path, (String[])new String[0]), (LinkOption[])new LinkOption[0]);
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = ExperimentTreeContextMenu.this._experiment.getGosuPanel().getClipboard();
            Transferable t = clipboard.getContents(this);
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    FileTree selection = (FileTree)this._tree.getLastSelectedPathComponent();
                    String path = (String)t.getTransferData(DataFlavor.stringFlavor);
                    boolean bCut = path.startsWith(ExperimentTreeContextMenu.CUT_PREFIX);
                    if (bCut) {
                        path = path.substring(ExperimentTreeContextMenu.CUT_PREFIX.length());
                    }
                    Path source = PathUtil.create((String)path, (String[])new String[0]);
                    Path target = PathUtil.isFile((Path)selection.getFileOrDir(), (LinkOption[])new LinkOption[0]) ? selection.getFileOrDir().getParent() : selection.getFileOrDir();
                    Path newSource = PathUtil.create((Path)PathUtil.getAbsolutePath((Path)target), (String)PathUtil.getName((Path)source));
                    if (bCut) {
                        if (!PathUtil.exists((Path)newSource, (LinkOption[])new LinkOption[0])) {
                            PathUtil.renameTo((Path)source, (Path)newSource, (CopyOption[])new CopyOption[0]);
                        }
                    } else {
                        ExperimentTreeContextMenu.this.copy(source, newSource);
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    class ClipCopyAction
    extends AbstractAction
    implements ClipboardOwner {
        JTree _tree;

        public ClipCopyAction(JTree tree) {
            super("Copy");
            this.putValue("MnemonicKey", new Integer(67));
            this._tree = tree;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public boolean isEnabled() {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            return item != null && !item.isSourcePathRoot() && item.getParent() != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            if (item != null) {
                Clipboard clipboard = ExperimentTreeContextMenu.this._experiment.getGosuPanel().getClipboard();
                clipboard.setContents(new StringSelection(PathUtil.getAbsolutePathName((Path)item.getFileOrDir())), this);
            }
        }
    }

    static class OpenOnDesktopAction
    extends AbstractAction
    implements ClipboardOwner {
        JTree _tree;

        private static String getFileManagerString() {
            if (PlatformUtil.isMac()) {
                return "Open in Finder";
            }
            if (PlatformUtil.isWindows()) {
                return "Open in Explorer";
            }
            return "Open in Path Manager";
        }

        public OpenOnDesktopAction(JTree tree) {
            super(OpenOnDesktopAction.getFileManagerString());
            this.putValue("MnemonicKey", new Integer(80));
            this._tree = tree;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public boolean isEnabled() {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            return item != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            if (item != null) {
                LabFrame.openFileOrDir(item.getFileOrDir());
            }
        }
    }

    class OpenAction
    extends AbstractAction
    implements ClipboardOwner {
        JTree _tree;

        public OpenAction(JTree tree) {
            super("Open");
            this.putValue("MnemonicKey", new Integer(79));
            this._tree = tree;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public boolean isEnabled() {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            return item != null && item.isFile();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            if (item != null) {
                ExperimentTreeContextMenu.this._experiment.getGosuPanel().openFile(item.getFileOrDir(), true);
            }
        }
    }

    class NewAction
    extends AbstractAction
    implements ClipboardOwner {
        JTree _tree;

        public NewAction(JTree tree) {
            super("New...");
            this.putValue("MnemonicKey", new Integer(78));
            this._tree = tree;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public boolean isEnabled() {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            return item != null && item.getParent() != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileTree item = (FileTree)this._tree.getLastSelectedPathComponent();
            if (item != null) {
                NewFilePopup popup = new NewFilePopup();
                popup.show(LabFrame.instance().getGosuPanel(), 200, 200);
            }
        }
    }
}

