/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.ExperimentView;
import editor.ExternalFileTree;
import editor.FileTree;
import editor.GosuPanel;
import editor.LabFrame;
import gw.fs.IFile;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.util.PathUtil;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.tree.TreeModel;

public class FileTreeUtil {
    public static FileTree find(String fqn) {
        IFile[] sourceFiles;
        IType type;
        FileTree fileTree = FileTreeUtil.getRoot().find(fqn);
        if (fileTree == null && (type = TypeSystem.getByFullNameIfValid((String)fqn)) != null && (sourceFiles = type.getSourceFiles()) != null && sourceFiles.length > 0) {
            IFile sourceFile = sourceFiles[0];
            fileTree = FileTreeUtil.find(PathUtil.create((URI)sourceFile.toURI()), fqn);
        }
        return fileTree;
    }

    public static FileTree find(Path file) {
        return FileTreeUtil.find(file, null);
    }

    public static FileTree find(Path file, String typeName) {
        FileTree fileTree = FileTreeUtil.getRoot().find(file);
        if (fileTree == null) {
            fileTree = FileTreeUtil.makeExternalFileTree(file, typeName);
        }
        return fileTree;
    }

    public static ExperimentView getExperimentView() {
        return FileTreeUtil.getGosuPanel() == null ? null : FileTreeUtil.getGosuPanel().getExperimentView();
    }

    public static GosuPanel getGosuPanel() {
        return LabFrame.instance().getGosuPanel();
    }

    public static FileTree getRoot() {
        ExperimentView experimentView = FileTreeUtil.getExperimentView();
        if (experimentView == null) {
            return null;
        }
        TreeModel model = experimentView.getTree().getModel();
        return (FileTree)model.getRoot();
    }

    public static Set<String> getAllExperimentTypes() {
        TreeSet<String> names = new TreeSet<String>();
        FileTreeUtil.getRoot().getAllTypeNames(names);
        return names;
    }

    public static FileTree makeExternalFileTree(Path file, String fqn) {
        return new ExternalFileTree(file, fqn);
    }

    public static boolean isSupportedTextFile(FileTree ft) {
        String[] binaryExt = new String[]{".jar", ".zip", ".tar", ".gz", ".hprof", ".png", ".gif", ".jpg", ".bmp", ".exe", ".dll", ".so"};
        String fileName = PathUtil.getName((Path)ft.getFileOrDir()).toLowerCase();
        return !Arrays.stream(binaryExt).anyMatch(fileName::endsWith);
    }
}

