/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractListCellRenderer;
import editor.GosuEditor;
import editor.LabFrame;
import editor.SelectClassToImportPopup;
import editor.SmartFixPopup;
import editor.TypeCellRenderer;
import editor.util.EditorUtilities;
import editor.util.TextComponentUtil;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IStatement;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.Keyword;
import gw.lang.parser.exceptions.ImplicitCoercionWarning;
import gw.lang.parser.exceptions.ObsoleteConstructorWarning;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.exceptions.ParseWarning;
import gw.lang.parser.expressions.IBeanMethodCallExpression;
import gw.lang.parser.expressions.IFieldAccessExpression;
import gw.lang.parser.expressions.IIdentifierExpression;
import gw.lang.parser.expressions.IImplicitTypeAsExpression;
import gw.lang.parser.expressions.IMethodCallExpression;
import gw.lang.parser.expressions.IParenthesizedExpression;
import gw.lang.parser.expressions.ISynthesizedMemberAccessExpression;
import gw.lang.parser.expressions.ITypeLiteralExpression;
import gw.lang.parser.resources.Res;
import gw.lang.parser.statements.IArrayAssignmentStatement;
import gw.lang.parser.statements.IAssignmentStatement;
import gw.lang.parser.statements.IBeanMethodCallStatement;
import gw.lang.parser.statements.IClassStatement;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.parser.statements.IMapAssignmentStatement;
import gw.lang.parser.statements.IMemberAssignmentStatement;
import gw.lang.parser.statements.IMethodCallStatement;
import gw.lang.parser.statements.INotAStatement;
import gw.lang.parser.statements.IStatementList;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeInfoUtil;
import gw.lang.reflect.TypeSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

public class SmartFixManager
implements MouseMotionListener,
KeyListener {
    private static final Rectangle TEST_RECTANGLE = new Rectangle(0, 0, 0, 0);
    private static final String DISPLAYKEY_START = "displaykey.";
    public static final String SHORTCUT = "Alt+Enter";
    private Timer _timer;
    private GosuEditor _gosuEditor;
    private JTextComponent _editor;
    private SmartFixMode _mode = SmartFixMode.NONE;
    private Set<String> _possibleTypesToImport;
    private IParsedElement _peToFixWithAsStatement;
    private IParsedElement _javaStyleCast;
    private int _obsoleteCtorStart;
    private int _obsoleteCtorEnd;
    private String _possibleDisplayKey;
    private IParseTree _stringLiteralLocationToReplace;
    private IParsedElement _sourceOfIssue;
    private String _typeToCoerceTo;
    private SmartFixPopup _managerPopup;
    private int _offset;
    private int _length;
    private static final Color SMARTFIX_HIGHLIGHT_COLOR = new Color(180, 180, 70);
    static boolean _allowUnusedParameterFix = false;
    SelectClassToImportPopup _selectionPopup;

    public SmartFixManager(GosuEditor gosuEditor) {
        this._gosuEditor = gosuEditor;
        this._editor = gosuEditor.getEditor();
        this._editor.addMouseMotionListener(this);
        this._editor.addKeyListener(this);
    }

    public void performFix() {
        EditorUtilities.settleBackgroundOps();
        switch (this._mode) {
            case IMPORT: {
                this.fixImport();
                this.setMode(SmartFixMode.NONE);
                break;
            }
            case FIX_IMPLICIT_CAST: {
                this.fixImplicitCast();
                this.setMode(SmartFixMode.NONE);
                break;
            }
            case FIX_JAVA_STYLE_CAST: {
                this.fixJavaStyleCast();
                this.setMode(SmartFixMode.NONE);
                break;
            }
            case FIX_CTOR_SYNTAX: {
                this.fixConstructorSyntax();
                this.setMode(SmartFixMode.NONE);
                break;
            }
            case FIX_UNUSED_ELEMENT: {
                this.fixUnusedElement();
                this.setMode(SmartFixMode.NONE);
                break;
            }
            case ADD_MISSING_OVERRIDE: {
                this.addMissingOverride();
                this.setMode(SmartFixMode.NONE);
                break;
            }
            case FIX_CASE: {
                this.fixCase();
                this.setMode(SmartFixMode.NONE);
                break;
            }
            case FIX_RETURN_TYPE: {
                this.fixReturnType();
                this.setMode(SmartFixMode.NONE);
                break;
            }
            case GENERATE_CONSTRUCTORS: {
                this.generateConstructors();
                this.setMode(SmartFixMode.NONE);
                break;
            }
            case GENERATE_SUPER_CALL: {
                this.generateSuperCall();
                this.setMode(SmartFixMode.NONE);
                break;
            }
            case NONE: {
                if (this.offerPassiveFix()) break;
                this.updateState();
            }
        }
    }

    public JTextComponent getEditor() {
        return this._editor;
    }

    public void setEditor(JTextComponent editor) {
        this._editor = editor;
    }

    public IParsedElement getSourceOfIssue() {
        return this._sourceOfIssue;
    }

    public void setSourceOfIssue(IParsedElement sourceOfIssue) {
        this._sourceOfIssue = sourceOfIssue;
    }

    public int getOffset() {
        return this._offset;
    }

    public void setOffset(int offset) {
        this._offset = offset;
    }

    public int getLength() {
        return this._length;
    }

    public void setLength(int length) {
        this._length = length;
    }

    public GosuEditor getGosuEditor() {
        return this._gosuEditor;
    }

    public void setGosuEditor(GosuEditor gosuEditor) {
        this._gosuEditor = gosuEditor;
    }

    private void fixUnusedElement() {
        try {
            int start = this.getStartOffsetOfUnused();
            int end = this.getEndOffsetOfUnused();
            this._editor.getDocument().remove(start, end - start + 1);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private int getStartOffsetOfUnused() {
        int i;
        for (i = this._sourceOfIssue.getLocation().getOffset() - 1; i > 0 && this._editor.getText().charAt(i) == ' '; --i) {
        }
        if (i > 0 && this._editor.getText().charAt(i) == '\n') {
            --i;
        }
        return i + 1;
    }

    private int getEndOffsetOfUnused() {
        int i;
        for (i = this._sourceOfIssue.getLocation().getExtent() + 1; i < this._editor.getText().length() && (this._editor.getText().charAt(i) == ' ' || this._editor.getText().charAt(i) == ';'); ++i) {
        }
        return i - 1;
    }

    private void addMissingOverride() {
        int offset = this._sourceOfIssue.getLocation().getOffset();
        offset = this.getOverrideTarget(offset);
        try {
            this._editor.getDocument().insertString(offset, "override ", null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private void fixCase() {
        ReplaceChunk replaceChunk = SmartFixManager.getReplaceChunk(this._sourceOfIssue, this._gosuEditor.getText());
        if (replaceChunk != null) {
            try {
                int offsetShift = this._gosuEditor.getParser().getOffsetShift();
                this._editor.getDocument().remove(replaceChunk.offset + offsetShift, replaceChunk.length);
                this._editor.getDocument().insertString(replaceChunk.offset + offsetShift, replaceChunk.replaceText, null);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void fixReturnType() {
        IType type = this.getReturnTypeFromPartialStatement(this._sourceOfIssue);
        IParsedElement functionStatement = this._sourceOfIssue.findAncestorParsedElementByType(new Class[]{IFunctionStatement.class});
        if (functionStatement != null) {
            List trees = functionStatement.getLocation().getChildren();
            for (IParseTree tree : trees) {
                if (!(tree.getParsedElement() instanceof IStatementList)) continue;
                int offset = tree.getOffset();
                try {
                    String prefix = this._editor.getDocument().getText(offset - 1, 1).equals(" ") ? ": " : " : ";
                    this._editor.getDocument().insertString(offset, prefix + type.getRelativeName() + " ", null);
                }
                catch (BadLocationException badLocationException) {}
                break;
            }
        }
    }

    private void generateConstructors() {
        IType supertype = ((IClassStatement)this._sourceOfIssue).getGosuClass().getSupertype();
        String text = this._editor.getText();
        int insertionPoint = text.indexOf("\n", text.indexOf("{", this._sourceOfIssue.getLocation().getOffset())) + 1;
        List constructors = supertype.getTypeInfo().getConstructors();
        try {
            for (IConstructorInfo constructor : constructors) {
                IParameterInfo[] parameterInfos = constructor.getParameters();
                StringBuilder constructorText = new StringBuilder("  construct(");
                for (IParameterInfo parameterInfo : parameterInfos) {
                    constructorText.append(parameterInfo.getName()).append(" : ").append(parameterInfo.getFeatureType().getRelativeName()).append(", ");
                }
                if (parameterInfos.length > 0) {
                    constructorText.setLength(constructorText.length() - 2);
                }
                constructorText.append(") {\n    super(");
                for (IParameterInfo parameterInfo : parameterInfos) {
                    constructorText.append(parameterInfo.getName()).append(", ");
                }
                if (parameterInfos.length > 0) {
                    constructorText.setLength(constructorText.length() - 2);
                }
                constructorText.append(")\n  }\n");
                this._editor.getDocument().insertString(insertionPoint, constructorText.toString(), null);
                insertionPoint += constructorText.length();
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateSuperCall() {
        Rectangle caretRect;
        IType supertype = ((IFunctionStatement)this._sourceOfIssue).getDynamicFunctionSymbol().getDeclaringTypeInfo().getOwnersType().getSupertype();
        List constructors = supertype.getTypeInfo().getConstructors();
        if (constructors.size() == 1) {
            IConstructorInfo constructor = (IConstructorInfo)constructors.get(0);
            this.generateSuperCall(constructor);
            return;
        }
        this._selectionPopup = SelectClassToImportPopup.instance();
        this.hidePopup();
        HashMap<String, IConstructorInfo> ctorMap = new HashMap<String, IConstructorInfo>();
        LinkedHashSet<String> ctorStrs = new LinkedHashSet<String>();
        for (IConstructorInfo constructor : constructors) {
            ctorStrs.add(TypeInfoUtil.getParameterDisplay((IConstructorInfo)constructor));
            ctorMap.put(TypeInfoUtil.getParameterDisplay((IConstructorInfo)constructor), constructor);
        }
        try {
            caretRect = this.getEditor().modelToView(this.getEditor().getCaretPosition());
            if (caretRect != null) {
                SwingUtilities.convertRectangle(this.getEditor(), caretRect, null);
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        this._selectionPopup.show(this.getEditor(), caretRect, ctorStrs, className -> this.generateSuperCall((IConstructorInfo)ctorMap.get(className)), "Select constructor", new CtorCellRenderer(this._selectionPopup::getList));
    }

    private void generateSuperCall(IConstructorInfo constructor) {
        int insertPos = this._editor.getText().indexOf("{", this._sourceOfIssue.getLocation().getOffset()) + 1;
        int firstParamStart = -1;
        int firstParamEnd = -1;
        StringBuilder superCall = new StringBuilder("\n    super(");
        for (IParameterInfo parameterInfo : constructor.getParameters()) {
            if (firstParamStart == -1) {
                firstParamStart = insertPos + superCall.length();
                firstParamEnd = firstParamStart + parameterInfo.getName().length();
            }
            superCall.append(parameterInfo.getName()).append(", ");
        }
        if (constructor.getParameters().length > 0) {
            superCall.setLength(superCall.length() - 2);
        }
        superCall.append(")");
        try {
            this._editor.getDocument().insertString(insertPos, superCall.toString(), null);
            if (firstParamStart != -1) {
                this._editor.setSelectionStart(firstParamStart);
                this._editor.setSelectionEnd(firstParamEnd);
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private int getOverrideTarget(int offset) {
        int functionLoc = this._editor.getText().indexOf("function", offset);
        int propertyLoc = this._editor.getText().indexOf("property", offset);
        if (functionLoc != -1 && (functionLoc < propertyLoc || propertyLoc == -1)) {
            return functionLoc;
        }
        return propertyLoc;
    }

    private boolean offerPassiveFix() {
        return false;
    }

    private void setMode(SmartFixMode mode) {
        if (this.isModeAvailable(mode)) {
            this._mode = mode;
        }
    }

    private void fixImplicitCast() {
        try {
            IParsedElement expr = this._peToFixWithAsStatement;
            if (expr.getParent() instanceof IImplicitTypeAsExpression) {
                expr = expr.getParent();
            }
            String to = this._typeToCoerceTo;
            IParsedElement parent = expr.getParent();
            if (parent == null || parent instanceof IStatement || parent instanceof IBeanMethodCallExpression || parent instanceof IMethodCallExpression) {
                this._editor.getDocument().insertString(expr.getLocation().getExtent() + 1, " as " + to, null);
            } else {
                this._editor.getDocument().insertString(expr.getLocation().getExtent() + 1, " as " + to + ")", null);
                this._editor.getDocument().insertString(expr.getLocation().getOffset(), "(", null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void fixConstructorSyntax() {
        try {
            Document document = this._editor.getDocument();
            document.remove(this._obsoleteCtorStart, this._obsoleteCtorEnd - this._obsoleteCtorStart);
            document.insertString(this._obsoleteCtorStart, Keyword.KW_construct.toString(), null);
            this._editor.setCaretPosition(this._obsoleteCtorStart + Keyword.KW_construct.toString().length());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void fixJavaStyleCast() {
        try {
            Document document = this._editor.getDocument();
            IParseTree location = this._javaStyleCast.getLocation();
            int pointToRemoveFrom = location.getOffset();
            int lengthToDelete = location.getLength();
            if (pointToRemoveFrom > 0 && document.getText(pointToRemoveFrom - 1, 1).equals(" ")) {
                --pointToRemoveFrom;
                ++lengthToDelete;
            }
            int startPosition = this._peToFixWithAsStatement.getLocation().getOffset() - lengthToDelete;
            int castInsertionPoint = this._peToFixWithAsStatement.getLocation().getExtent() - lengthToDelete + 1;
            String coercionString = " as " + this._typeToCoerceTo;
            document.remove(pointToRemoveFrom, lengthToDelete);
            document.insertString(castInsertionPoint, coercionString, null);
            this._editor.setCaretPosition(startPosition);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void fixImport() {
        Set<String> possibleTypesToImport = this._possibleTypesToImport;
        if (possibleTypesToImport != null) {
            if (possibleTypesToImport.size() == 1) {
                this._gosuEditor.addToUses(possibleTypesToImport.iterator().next());
            } else {
                try {
                    Rectangle rectangle = this.getLocationFromOffset(this._editor.getCaretPosition());
                    SelectClassToImportPopup.instance().show(this._editor, rectangle, possibleTypesToImport, this._gosuEditor::addToUses, "Select class to import", new TypeCellRenderer(SelectClassToImportPopup.instance().getList()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    public void updateState() {
        this.resetSmartHelpState();
        if (this.isOtherPopupShowing()) {
            return;
        }
        final List<IParseIssue> parseIssues = this.findParseIssuesOrderedByDistanceFromCaret(1);
        this.setMode(SmartFixMode.NONE);
        for (Highlighter.Highlight highlight : this._editor.getHighlighter().getHighlights()) {
            if (!(highlight.getPainter() instanceof SmartFixHighlightPainter)) continue;
            this._editor.getHighlighter().removeHighlight(highlight);
        }
        final HashSet processed = new HashSet();
        final ITypeUsesMap[] uses = new ITypeUsesMap[]{this._gosuEditor.getTypeUsesMapFromMostRecentParse()};
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (uses[0] == null) {
                    SmartFixManager.this._gosuEditor.waitForParser();
                    uses[0] = SmartFixManager.this._gosuEditor.getTypeUsesMapFromMostRecentParse();
                }
                for (IParseIssue parseIssue : parseIssues) {
                    IParsedElement source = parseIssue.getSource();
                    if (SmartFixManager.this.isModeAvailable(SmartFixMode.IMPORT) && SmartFixManager.this._gosuEditor.acceptsUses() && SmartFixManager.this.handlePossibleImportFix(source, uses[0], processed)) {
                        SmartFixManager.this.setMode(SmartFixMode.IMPORT);
                        return;
                    }
                    if (SmartFixManager.this.isModeAvailable(SmartFixMode.FIX_IMPLICIT_CAST) && SmartFixManager.this.isImplictCoercion(parseIssue)) {
                        SmartFixManager.this.setMode(SmartFixMode.FIX_IMPLICIT_CAST);
                        return;
                    }
                    if (SmartFixManager.this.isModeAvailable(SmartFixMode.FIX_CTOR_SYNTAX) && SmartFixManager.this.isObsoleteConstructor(parseIssue)) {
                        SmartFixManager.this.setMode(SmartFixMode.FIX_CTOR_SYNTAX);
                        return;
                    }
                    if (SmartFixManager.this.isModeAvailable(SmartFixMode.FIX_JAVA_STYLE_CAST) && SmartFixManager.this.isJavaStyleCast(parseIssue)) {
                        SmartFixManager.this.setMode(SmartFixMode.FIX_JAVA_STYLE_CAST);
                        return;
                    }
                    if (SmartFixManager.this.isModeAvailable(SmartFixMode.ADD_MISSING_OVERRIDE) && SmartFixManager.this.isMissingOverride(parseIssue)) {
                        SmartFixManager.this.setMode(SmartFixMode.ADD_MISSING_OVERRIDE);
                        return;
                    }
                    if (SmartFixManager.this.isModeAvailable(SmartFixMode.FIX_CASE) && SmartFixManager.this.isCaseIssue(parseIssue)) {
                        SmartFixManager.this.setMode(SmartFixMode.FIX_CASE);
                        return;
                    }
                    if (SmartFixManager.this.isModeAvailable(SmartFixMode.FIX_RETURN_TYPE) && SmartFixManager.this.isVoidReturnTypeIssue(parseIssue)) {
                        SmartFixManager.this.setMode(SmartFixMode.FIX_RETURN_TYPE);
                        return;
                    }
                    if (SmartFixManager.this.isModeAvailable(SmartFixMode.GENERATE_CONSTRUCTORS) && SmartFixManager.this.isMissingConstructor(parseIssue)) {
                        SmartFixManager.this.setMode(SmartFixMode.GENERATE_CONSTRUCTORS);
                        return;
                    }
                    if (!SmartFixManager.this.isModeAvailable(SmartFixMode.GENERATE_SUPER_CALL) || !SmartFixManager.this.isMissingSuperCall(parseIssue)) continue;
                    SmartFixManager.this.setMode(SmartFixMode.GENERATE_SUPER_CALL);
                    return;
                }
            }
        };
        EditorUtilities.doBackgroundOp(runnable);
    }

    private boolean isMissingConstructor(IParseIssue parseIssue) {
        if (parseIssue.getMessageKey() == Res.MSG_NO_DEFAULT_CTOR_IN) {
            this._sourceOfIssue = parseIssue.getSource();
            if (this._sourceOfIssue instanceof IClassStatement) {
                this.showSmartFix(this._sourceOfIssue, "Generate constructors");
                return true;
            }
        }
        return false;
    }

    private boolean isMissingSuperCall(IParseIssue parseIssue) {
        if (parseIssue.getMessageKey() == Res.MSG_NO_DEFAULT_CTOR_IN) {
            this._sourceOfIssue = parseIssue.getSource();
            if (this._sourceOfIssue instanceof IFunctionStatement) {
                this.showSmartFix(this._sourceOfIssue, "Generate super call");
                return true;
            }
        }
        return false;
    }

    private boolean isCaseIssue(IParseIssue parseIssue) {
        if (parseIssue instanceof ParseWarning && SmartFixManager.isCaseParseIssue(parseIssue)) {
            this._sourceOfIssue = parseIssue.getSource();
            this.showSmartFix(this._sourceOfIssue, "Fix case issue   (Alt+Enter)");
            return true;
        }
        return false;
    }

    private boolean isVoidReturnTypeIssue(IParseIssue parseIssue) {
        if (parseIssue instanceof ParseException && parseIssue.getMessageKey() == Res.MSG_RETURN_VAL_FROM_VOID_FUNCTION && this.getReturnTypeFromPartialStatement(parseIssue.getSource()) != null) {
            IType type = this.getReturnTypeFromPartialStatement(parseIssue.getSource());
            this._sourceOfIssue = parseIssue.getSource();
            this.showSmartFix(this._sourceOfIssue, "Make function return type " + type.getRelativeName() + "? (Alt+Enter)");
            return true;
        }
        return false;
    }

    private IType getReturnTypeFromPartialStatement(IParsedElement source) {
        if (source instanceof IAssignmentStatement) {
            return ((IAssignmentStatement)source).getIdentifier().getType();
        }
        if (source instanceof IArrayAssignmentStatement) {
            return ((IArrayAssignmentStatement)source).getArrayAccessExpression().getType();
        }
        if (source instanceof IMapAssignmentStatement) {
            return ((IMapAssignmentStatement)source).getMapAccessExpression().getType();
        }
        if (source instanceof IMemberAssignmentStatement) {
            return ((IMemberAssignmentStatement)source).getMemberAccess().getType();
        }
        if (source instanceof INotAStatement) {
            return ((INotAStatement)source).getExpression().getType();
        }
        if (source instanceof IBeanMethodCallStatement) {
            return ((IBeanMethodCallStatement)source).getBeanMethodCall().getType();
        }
        if (source instanceof IMethodCallStatement) {
            return ((IMethodCallStatement)source).getMethodCall().getType();
        }
        return null;
    }

    private boolean isModeAvailable(SmartFixMode mode) {
        if (mode == SmartFixMode.NONE) {
            return true;
        }
        return true;
    }

    private boolean isMissingOverride(IParseIssue parseIssue) {
        if (parseIssue.getMessageKey() == Res.MSG_MISSING_OVERRIDE_MODIFIER) {
            this._sourceOfIssue = parseIssue.getSource();
            if (this._sourceOfIssue != null && this._sourceOfIssue.getLocation() != null) {
                int offset = this._sourceOfIssue.getLocation().getOffset();
                int length = this._editor.getText().indexOf("\n", offset) - offset;
                if (offset <= this._editor.getCaretPosition() && offset + length >= this._editor.getCaretPosition()) {
                    this.showSmartFix(offset, length, "Add missing override? (Alt+Enter)");
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isOtherPopupShowing() {
        return this._gosuEditor.isCompletionPopupShowing();
    }

    private boolean isImplictCoercion(IParseIssue parseIssue) {
        if (parseIssue instanceof ImplicitCoercionWarning) {
            ImplicitCoercionWarning warning = (ImplicitCoercionWarning)parseIssue;
            IParsedElement element = warning.getSource();
            int caret = this._editor.getCaretPosition();
            if (element.getLocation().contains(caret) || element.getLocation().getExtent() + 1 == caret) {
                this._peToFixWithAsStatement = warning.getSource();
                this._typeToCoerceTo = warning.getTypeToCoerceTo().getName();
                this.showSmartFix(element, "Coerce to " + this._typeToCoerceTo + "? (Alt+Enter)");
                return true;
            }
        }
        return false;
    }

    private boolean isObsoleteConstructor(IParseIssue parseIssue) {
        if (parseIssue instanceof ObsoleteConstructorWarning) {
            ObsoleteConstructorWarning warning = (ObsoleteConstructorWarning)parseIssue;
            IParsedElement element = warning.getSource();
            int offset = element.getLocation().getOffset();
            String text = this._editor.getText();
            int nextParen = text.indexOf(40, offset);
            if (nextParen != -1) {
                String functionDecl = text.substring(offset, nextParen);
                int caret = this._editor.getCaretPosition();
                if (caret >= offset && caret <= offset + functionDecl.length()) {
                    this._obsoleteCtorStart = offset;
                    this._obsoleteCtorEnd = offset + functionDecl.length();
                    this.showSmartFix(this._obsoleteCtorStart, this._obsoleteCtorEnd - this._obsoleteCtorStart, "Convert to new constructor syntax  (Alt+Enter)");
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isJavaStyleCast(IParseIssue parseIssue) {
        if (parseIssue.getMessageKey() == Res.MSG_LIKELY_JAVA_CAST) {
            IParseTree nextSibling;
            IParsedElement source = parseIssue.getSource();
            IParenthesizedExpression parenthesizedExpr = source instanceof IParenthesizedExpression ? (IParenthesizedExpression)source : (IParenthesizedExpression)((IImplicitTypeAsExpression)source).getLHS();
            int caret = this._editor.getCaretPosition();
            if ((parenthesizedExpr.getLocation().contains(caret) || parenthesizedExpr.getLocation().getExtent() + 1 == caret) && (nextSibling = parenthesizedExpr.getParent().getLocation().getNextSibling()) != null && parenthesizedExpr.getLocation().getLineNum() == nextSibling.getLineNum()) {
                this._javaStyleCast = parenthesizedExpr;
                this._peToFixWithAsStatement = nextSibling.getDeepestFirstChild().getParsedElement();
                this._typeToCoerceTo = ((IMetaType)parenthesizedExpr.getType()).getType().getName();
                this.showSmartFix((IParsedElement)parenthesizedExpr, "This appears to be a java-style cast.  Shall I convert it to a Gosu style cast? (Alt+Enter)");
                return true;
            }
        }
        return false;
    }

    public void resetSmartHelpState() {
        this._possibleTypesToImport = null;
        this._peToFixWithAsStatement = null;
        this._typeToCoerceTo = null;
        this._javaStyleCast = null;
        this._possibleDisplayKey = null;
        this._stringLiteralLocationToReplace = null;
        if (this._managerPopup != null) {
            this._managerPopup.setVisible(false);
            this._managerPopup = null;
        }
    }

    private boolean handlePossibleImportFix(IParsedElement source, ITypeUsesMap typeUses, Set<String> processed) {
        block14: {
            INotAStatement nas;
            ISymbol symbol;
            IIdentifierExpression identifier;
            String relativeTypeName = null;
            if (source instanceof ITypeLiteralExpression) {
                IErrorType errorType;
                ITypeLiteralExpression typeLiteral = (ITypeLiteralExpression)source;
                IType iIntrinsicType = typeLiteral.getType().getType();
                if (iIntrinsicType.isArray()) {
                    iIntrinsicType = iIntrinsicType.getComponentType();
                }
                if (iIntrinsicType instanceof IErrorType && !(errorType = (IErrorType)iIntrinsicType).getErrantTypeName().equals("ErrorType")) {
                    relativeTypeName = errorType.getErrantTypeName();
                }
            }
            if (source instanceof IIdentifierExpression && (identifier = (IIdentifierExpression)source).getType() instanceof IErrorType && (symbol = identifier.getSymbol()) != null) {
                relativeTypeName = symbol.getName();
            }
            if (source instanceof INotAStatement && (nas = (INotAStatement)source).getExpression() != null && nas.getExpression() instanceof IIdentifierExpression && ((IIdentifierExpression)nas.getExpression()).getSymbol() != null) {
                relativeTypeName = ((IIdentifierExpression)nas.getExpression()).getSymbol().getName();
            }
            if (relativeTypeName != null && !processed.contains(relativeTypeName)) {
                processed.add(relativeTypeName);
                try {
                    List<String> fullyQualifiedNames;
                    Rectangle rectangle = this.getLocationFromOffset(source.getLocation().getOffset());
                    if (!this._editor.getVisibleRect().contains(rectangle) && rectangle != TEST_RECTANGLE) break block14;
                    IType type = typeUses.resolveType(relativeTypeName);
                    if (type == null) {
                        try {
                            type = TypeSystem.getByFullName((String)relativeTypeName);
                        }
                        catch (Exception errorType) {
                            // empty catch block
                        }
                    }
                    TreeSet<String> possibleTypesToImport = new TreeSet<String>(new TypeNameComparator());
                    if (type == null && (fullyQualifiedNames = LabFrame.instance().getGosuPanel().getTypeNamesCache().getFullyQualifiedClassNameFromRelativeName(relativeTypeName)) != null) {
                        for (CharSequence charSequence : fullyQualifiedNames) {
                            possibleTypesToImport.add(charSequence.toString());
                        }
                    }
                    if (possibleTypesToImport.size() > 0) {
                        String displayText = possibleTypesToImport.size() == 1 ? possibleTypesToImport.iterator().next() + "? (Alt+Enter)" : "Multiple Matches...(Alt+Enter)";
                        this._possibleTypesToImport = possibleTypesToImport;
                        this.showSmartFix(source, displayText);
                        return true;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private Rectangle getLocationFromOffset(int i) throws BadLocationException {
        Rectangle rectangle = this._editor.modelToView(i);
        if (rectangle == null) {
            rectangle = TEST_RECTANGLE;
        }
        return rectangle;
    }

    private void showSmartFix(IParsedElement source, String displayText) {
        this.showSmartFix(source.getLocation().getOffset(), source.getLocation().getLength(), displayText);
    }

    public void showSmartFix(int offset, int length, String displayText) {
        Runnable runnable = () -> {
            try {
                this._offset = offset;
                this._length = length;
                Rectangle rectangle = this.getLocationFromOffset(this._offset);
                if (rectangle != TEST_RECTANGLE && this._editor.isShowing()) {
                    this._managerPopup = new SmartFixPopup(displayText);
                }
                this._editor.getHighlighter().addHighlight(this._offset, this._offset + this._length, new SmartFixHighlightPainter(SMARTFIX_HIGHLIGHT_COLOR));
            }
            catch (BadLocationException e) {
                this.resetSmartHelpState();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private List<IParseIssue> findParseIssuesOrderedByDistanceFromCaret(int maxLines) {
        ArrayList<IParseIssue> issues = new ArrayList<IParseIssue>();
        int caretPosition = this._editor.getCaretPosition();
        int line = TextComponentUtil.getLineAtPosition(this._editor, caretPosition);
        int col = TextComponentUtil.getColumnAtPosition(this._editor, caretPosition);
        ParseResultsException pe = this._gosuEditor.getParseResultsException();
        if (pe != null) {
            for (IParseIssue parseIssue : pe.getParseIssues()) {
                if (Math.abs(parseIssue.getLine() - line) > maxLines) continue;
                issues.add(parseIssue);
            }
        }
        Collections.sort(issues, (o1, o2) -> {
            double d2;
            double d1 = this.getDistanceFromPosition((IParseIssue)o1, line, col);
            if (d1 > (d2 = this.getDistanceFromPosition((IParseIssue)o2, line, col))) {
                return 1;
            }
            if (d1 < d2) {
                return -1;
            }
            return 0;
        });
        return issues;
    }

    private double getDistanceFromPosition(IParseIssue pi, int line, int col) {
        if (pi.getSource() != null && pi.getSource().getLocation() != null) {
            int squaredDist = (pi.getSource().getLocation().getLineNum() - line) * (pi.getSource().getLocation().getLineNum() - line) + (pi.getSource().getLocation().getColumn() - col) * (pi.getSource().getLocation().getColumn() - col);
            return Math.sqrt(squaredDist);
        }
        return Double.MAX_VALUE;
    }

    public SmartFixMode getMode() {
        return this._mode;
    }

    public Set<String> getPossibleTypesToImport() {
        return this._possibleTypesToImport;
    }

    public IParsedElement getPeToFixWithAsStatement() {
        return this._peToFixWithAsStatement;
    }

    public IParsedElement getJavaStyleCast() {
        return this._javaStyleCast;
    }

    public String getTypeToCoerceTo() {
        return this._typeToCoerceTo;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this._managerPopup != null) {
            if (this.getTargetBounds().contains(e.getPoint())) {
                if (!this._managerPopup.isShowing() && this._selectionPopup == null) {
                    this.bufferShowPopup(true);
                }
            } else if (this._managerPopup.isShowing()) {
                this.hidePopup();
            }
        }
    }

    private void hidePopup() {
        if (this._managerPopup != null) {
            this._managerPopup.setVisible(false);
        }
        if (this._timer != null) {
            if (this._timer.isRunning()) {
                this._timer.stop();
            }
            this._timer = null;
        }
    }

    private void bufferShowPopup(boolean restartIfActive) {
        if (this._timer == null) {
            this._timer = new Timer(500, e -> SwingUtilities.invokeLater(this::showPopup));
            this._timer.setRepeats(false);
            this._timer.start();
        } else if (restartIfActive) {
            this._timer.restart();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this._managerPopup != null && e.getKeyCode() == 18 && !this._managerPopup.isShowing()) {
            this.bufferShowPopup(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this._managerPopup != null && e.getKeyCode() == 18) {
            this.hidePopup();
        }
    }

    private void showPopup() {
        if (this._managerPopup != null) {
            try {
                if (!(SelectClassToImportPopup.instance().isShowing() || this._gosuEditor.getCompletionPopup() != null && this._gosuEditor.getCompletionPopup().isShowing() || this._gosuEditor.getCompletionPopup() instanceof Component && this._gosuEditor.getCompletionPopup().isShowing() || this._gosuEditor.getJavadocPopup() != null && this._gosuEditor.getJavadocPopup().isShowing())) {
                    this._managerPopup.show(this._editor, this.getLocationFromOffset(this._offset));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private Rectangle getTargetBounds() {
        Rectangle p1;
        Rectangle p0;
        try {
            TextUI mapper = this._editor.getUI();
            p0 = mapper.modelToView(this._editor, this._offset);
            p1 = mapper.modelToView(this._editor, this._offset + this._length);
        }
        catch (Exception e) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle bounds = this._editor.getBounds();
        if (p0.y == p1.y) {
            Rectangle r1 = p0.union(p1);
            r1.grow(20, 20);
            return r1;
        }
        int p0ToMarginWidth = bounds.x + bounds.width - p0.x;
        Rectangle r1 = new Rectangle(p0.x, p0.y, p0ToMarginWidth, p0.height);
        if (p0.y + p0.height != p1.y) {
            r1 = r1.union(new Rectangle(bounds.x, p0.y + p0.height, bounds.width, p1.y - (p0.y + p0.height)));
        }
        r1 = r1.union(new Rectangle(bounds.x, p1.y, p1.x - bounds.x, p1.height));
        r1.grow(20, 20);
        return r1;
    }

    public static boolean isCaseParseIssue(IParseIssue parseIssue) {
        boolean caseIssue = parseIssue.getMessageKey() == Res.MSG_VAR_CASE_MISMATCH || parseIssue.getMessageKey() == Res.MSG_PROPERTY_CASE_MISMATCH || parseIssue.getMessageKey() == Res.MSG_TYPE_CASE_MISMATCH || parseIssue.getMessageKey() == Res.MSG_FUNCTION_CASE_MISMATCH;
        IParsedElement sourceOfIssue = parseIssue.getSource();
        boolean fixableElement = sourceOfIssue instanceof IIdentifierExpression || sourceOfIssue instanceof IBeanMethodCallExpression || sourceOfIssue instanceof ITypeLiteralExpression || sourceOfIssue instanceof ISynthesizedMemberAccessExpression || sourceOfIssue instanceof IFieldAccessExpression;
        return caseIssue && fixableElement;
    }

    public static ReplaceChunk getReplaceChunk(IParsedElement sourceOfIssue, String gosuSource) {
        ReplaceChunk returnChunk = new ReplaceChunk();
        if (sourceOfIssue instanceof IIdentifierExpression) {
            returnChunk.offset = sourceOfIssue.getLocation().getOffset();
            returnChunk.length = sourceOfIssue.getLocation().getLength();
            returnChunk.replaceText = ((IIdentifierExpression)sourceOfIssue).getSymbol().getName();
        } else if (sourceOfIssue instanceof IBeanMethodCallExpression) {
            returnChunk.offset = ((IBeanMethodCallExpression)sourceOfIssue).getStartOffset();
            returnChunk.replaceText = ((IBeanMethodCallExpression)sourceOfIssue).getFunctionType().getName();
            returnChunk.length = returnChunk.replaceText.length();
        } else if (sourceOfIssue instanceof ITypeLiteralExpression) {
            if (gosuSource == null) {
                throw new IllegalArgumentException("The original source must be passed into getReplaceChunk() so that it can determine what text to replace");
            }
            String literalToReplace = gosuSource.substring(sourceOfIssue.getLocation().getOffset(), sourceOfIssue.getLocation().getExtent() + 1);
            int openCaret = literalToReplace.indexOf(60);
            if (openCaret != -1) {
                literalToReplace = gosuSource.substring(0, openCaret);
            }
            returnChunk.offset = sourceOfIssue.getLocation().getOffset();
            IType type = ((ITypeLiteralExpression)sourceOfIssue).getType().getType();
            if (type.isParameterizedType()) {
                type = type.getGenericType();
            }
            String typeName = type.getName();
            returnChunk.replaceText = typeName.substring(Math.max(0, typeName.length() - literalToReplace.length()));
            returnChunk.length = returnChunk.replaceText.length();
        } else if (sourceOfIssue instanceof ISynthesizedMemberAccessExpression) {
            ISynthesizedMemberAccessExpression access = (ISynthesizedMemberAccessExpression)sourceOfIssue;
            returnChunk.offset = access.getStartOffset();
            returnChunk.replaceText = ((IFieldAccessExpression)sourceOfIssue).getPropertyInfo().getName();
            returnChunk.length = access.getLocation().getExtent() - access.getStartOffset() + 1;
        } else if (sourceOfIssue instanceof IFieldAccessExpression) {
            returnChunk.offset = ((IFieldAccessExpression)sourceOfIssue).getStartOffset();
            returnChunk.replaceText = ((IFieldAccessExpression)sourceOfIssue).getPropertyInfo().getName();
            returnChunk.length = returnChunk.replaceText.length();
        } else {
            return null;
        }
        return returnChunk;
    }

    private class CtorCellRenderer
    extends AbstractListCellRenderer<String> {
        public CtorCellRenderer(Supplier<JComponent> list) {
            super(list, true);
        }

        @Override
        public void configure() {
            this.setText((String)this.getNode());
        }
    }

    private static class TypeNameComparator
    implements Comparator<String> {
        private TypeNameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int o2category;
            int o1category = this.getCategory(o1).ordinal();
            if (o1category != (o2category = this.getCategory(o2).ordinal())) {
                return o1category - o2category;
            }
            for (int idx = 0; idx < o1.length() && idx < o2.length(); ++idx) {
                char o1ch = o1.charAt(idx);
                char o2ch = o2.charAt(idx);
                if (o1ch == o2ch) continue;
                if (Character.isUpperCase(o1ch) && !Character.isUpperCase(o2ch)) {
                    return -1;
                }
                if (Character.isUpperCase(o2ch) && !Character.isUpperCase(o1ch)) {
                    return 1;
                }
                return o1ch - o2ch;
            }
            return o1.length() - o2.length();
        }

        private ITypeCategory getCategory(String typeName) {
            if (typeName.startsWith("java.lang.")) {
                return ITypeCategory.JAVA;
            }
            if (typeName.startsWith("java.util.")) {
                return ITypeCategory.JAVA;
            }
            if (typeName.equals("javax.xml.namespace.QName")) {
                return ITypeCategory.QNAME;
            }
            return ITypeCategory.NORMAL;
        }

        private static enum ITypeCategory {
            JAVA,
            QNAME,
            NORMAL;

        }
    }

    public static class ReplaceChunk {
        public int offset;
        public int length;
        public String replaceText;
    }

    private class SmartFixHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public SmartFixHighlightPainter(Color c) {
            super(c);
        }

        @Override
        public Shape paintLayer(Graphics g, int p0, int p1, Shape shape, JTextComponent c, View view) {
            if (shape == null) {
                return null;
            }
            Shape result = null;
            try {
                result = view.modelToView(Math.min(p0, p1), Position.Bias.Forward, Math.max(p0, p1), Position.Bias.Backward, shape);
                Rectangle bounds = result.getBounds();
                this.drawWavyLine(g, bounds.x, bounds.y + bounds.height - 2, bounds.x + bounds.width - 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void drawWavyLine(Graphics g, int x, int y, int x2) {
            Color oldColor = g.getColor();
            try {
                g.setColor(this.getColor());
                int wavyLineWidth = x2 - x;
                if (wavyLineWidth > 0) {
                    int[] wf = new int[]{0, 1, 0, -1};
                    int[] xPoints = new int[wavyLineWidth + 1];
                    int[] yPoints = new int[wavyLineWidth + 1];
                    for (int i = 0; i <= wavyLineWidth; ++i) {
                        xPoints[i] = x + i;
                        yPoints[i] = y + wf[i % 4];
                    }
                    g.drawPolyline(xPoints, yPoints, wavyLineWidth);
                }
            }
            finally {
                g.setColor(oldColor);
            }
        }
    }

    public static enum SmartFixMode {
        NONE(""),
        IMPORT("Add import for unrecognized symbol"),
        FIX_IMPLICIT_CAST("Make implicit coercion explicit"),
        FIX_JAVA_STYLE_CAST("Fix Java-style type cast"),
        FIX_CTOR_SYNTAX("Change old constructor syntax to new"),
        FIX_UNUSED_ELEMENT("Remove unused variable"),
        ADD_MISSING_OVERRIDE("Add missing \"override\" modifier"),
        FIX_CASE("Fix case issue"),
        FIX_RETURN_TYPE("Fix return type"),
        GENERATE_CONSTRUCTORS("Generate constructors"),
        GENERATE_SUPER_CALL("Generate super call");

        private final String _humanName;

        private SmartFixMode(String humanName) {
            this._humanName = humanName;
        }

        public String toString() {
            return this._humanName;
        }
    }
}

