/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.util.EditorUtilities;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.ISymbol;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IType;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class SymbolCellRenderer
extends DefaultListCellRenderer {
    @Override
    public Component getListCellRendererComponent(JList list, Object value, int modelIndex, boolean isSelected, boolean cellHasFocus) {
        ISymbol symbol = (ISymbol)value;
        ImageIcon icon = symbol.getType() instanceof IFunctionType ? EditorUtilities.loadIcon("images/Function.png") : EditorUtilities.loadIcon("images/Properties.png");
        String text = this.getDisplayText(symbol);
        Component renderer = super.getListCellRendererComponent((JList<?>)list, text, modelIndex, isSelected, cellHasFocus);
        ((JLabel)renderer).setIcon(icon);
        return renderer;
    }

    private String getDisplayText(ISymbol symbol) {
        if (symbol.getType() instanceof IFunctionType) {
            IFunctionType type = (IFunctionType)symbol.getType();
            return type.getName() + this.getParamSignatureText(symbol) + " : " + this.getReturnTypeText(type.getReturnType());
        }
        return symbol.getName() + " : " + this.getTypeDisplayText(symbol.getType());
    }

    private String getReturnTypeText(IType type) {
        return this.getTypeDisplayText(type);
    }

    private String getParamSignatureText(ISymbol symbol) {
        if (symbol instanceof IDynamicFunctionSymbol) {
            return this.getDynParamSignatureText((IDynamicFunctionSymbol)symbol);
        }
        return this.getStaticParamSignatureText((IFunctionType)symbol.getType());
    }

    private String getDynParamSignatureText(IDynamicFunctionSymbol symbol) {
        List args = symbol.getArgs();
        if (args == null || args.size() == 0) {
            return "()";
        }
        Object strParams = "(";
        for (int i = 0; i < args.size(); ++i) {
            strParams = (String)strParams + (i == 0 ? "" : ", ") + ((ISymbol)args.get(i)).getName() + " : " + this.getTypeDisplayText(((ISymbol)args.get(i)).getType());
        }
        strParams = (String)strParams + ")";
        return strParams;
    }

    private String getStaticParamSignatureText(IFunctionType type) {
        IType[] argTypes = type.getParameterTypes();
        if (argTypes == null || argTypes.length == 0) {
            return "()";
        }
        Object strParams = "(";
        for (int i = 0; i < argTypes.length; ++i) {
            strParams = (String)strParams + (i == 0 ? "" : ", ") + this.getTypeDisplayText(argTypes[i]);
        }
        strParams = (String)strParams + ")";
        return strParams;
    }

    private String getTypeDisplayText(IType type) {
        Object strType = type.isArray() ? "List: " + this.getTypeDisplayText(type.getComponentType()) : type.getRelativeName();
        return strType;
    }
}

