/*
 * Decompiled with CFR 0.152.
 */
package editor.run;

import com.sun.jdi.VirtualMachine;
import editor.GosuEditor;
import editor.GosuPanel;
import editor.LabFrame;
import editor.TextComponentWriter;
import editor.run.IProcessRunner;
import editor.run.IRunConfig;
import editor.run.RunState;
import editor.settings.CompilerSettings;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import editor.util.TaskQueue;
import gw.util.GosuExceptionUtil;
import gw.util.PathUtil;
import java.awt.Color;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public abstract class AbstractOutOfProcessExecutor<T extends IRunConfig>
implements IProcessRunner<T> {
    private T _runConfig;
    private RunState _runState;
    private Process _process;
    private VirtualMachine _vm;

    public AbstractOutOfProcessExecutor(RunState runState) {
        this._runState = runState;
    }

    protected abstract String exec() throws Exception;

    @Override
    public T getRunConfig() {
        return this._runConfig;
    }

    @Override
    public RunState getRunState() {
        return this._runState;
    }

    @Override
    public Process getProcess() {
        return this._process;
    }

    protected void setProcess(Process process) {
        this._process = process;
    }

    @Override
    public VirtualMachine getVm() {
        return this._vm;
    }

    public void setVm(VirtualMachine vm) {
        this._vm = vm;
    }

    @Override
    public void execute(T runConfig) {
        try {
            this._runConfig = runConfig;
            TaskQueue queue = TaskQueue.getInstance("_execute_gosu");
            this.getGosuPanel().addBusySignal(this._runState);
            queue.postTask(() -> {
                GosuEditor.getParserTaskQueue().waitUntilAllCurrentTasksFinish();
                try {
                    String result = null;
                    try {
                        result = this.exec();
                    }
                    finally {
                        String programResults = result;
                        EventQueue.invokeLater(() -> {
                            this.getGosuPanel().removeBusySignal();
                            if (programResults != null) {
                                this.printLabMessage(programResults);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Throwable cause = GosuExceptionUtil.findExceptionCause((Throwable)e);
                    throw GosuExceptionUtil.forceThrow((Throwable)cause);
                }
            });
        }
        catch (Throwable t) {
            EditorUtilities.handleUncaughtException(t);
        }
    }

    int waitFor() throws IOException, InterruptedException {
        this.captureErrorStream();
        InputStream input = this._process.getInputStream();
        byte[] b = new byte[512];
        int read = 1;
        while (read > -1) {
            read = input.read(b, 0, b.length);
            if (read <= -1) continue;
            System.out.write(b, 0, read);
        }
        return this._process.waitFor();
    }

    private void captureErrorStream() throws IOException {
        new Thread(() -> {
            InputStream input = this._process.getErrorStream();
            byte[] b = new byte[512];
            int read = 1;
            while (read > -1) {
                try {
                    read = input.read(b, 0, b.length);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (read > -1) {
                    System.out.write(b, 0, read);
                }
                if (this._process.isAlive()) continue;
                break;
            }
        }, "Capture Error Stream").start();
    }

    String makeClasspath(GosuPanel gosuPanel) throws IOException {
        return this.makeClasspath(gosuPanel, true);
    }

    String makeClasspath(GosuPanel gosuPanel, boolean bToolsJar) throws IOException {
        StringBuilder classpath = new StringBuilder();
        String javaHomePath = System.getProperty("java.home");
        this.addExperimentPaths(gosuPanel, classpath, javaHomePath);
        String cp = System.getProperty("java.class.path");
        StringTokenizer tok = new StringTokenizer(cp, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            if (!path.contains("gw-asm-all") && !path.contains("gosu-core") && !path.contains("manifold")) continue;
            classpath.append(path).append(File.pathSeparator);
        }
        cp = classpath.toString();
        if (cp.endsWith(File.pathSeparator)) {
            cp = cp.substring(0, cp.length() - 1);
        }
        return cp;
    }

    private void addExperimentPaths(GosuPanel gosuPanel, StringBuilder classpath, String javaHomePath) {
        if (CompilerSettings.isStaticCompile()) {
            classpath.append(PathUtil.getAbsolutePathName((Path)CompilerSettings.getCompilerOutputDir())).append(File.pathSeparator);
        }
        Experiment experiment = gosuPanel.getExperiment();
        List<String> srcPaths = experiment.getSourcePath();
        for (String path : srcPaths) {
            if (path.startsWith(javaHomePath) || CompilerSettings.isStaticCompile() && !PathUtil.isFile((Path)PathUtil.getAbsolutePath((Path)PathUtil.create((String)path, (String[])new String[0])), (LinkOption[])new LinkOption[0])) continue;
            classpath.append(path).append(File.pathSeparator);
        }
    }

    void printLabMessage(String message) {
        if (this.getGosuPanel().getConsolePanel() == null) {
            return;
        }
        SimpleAttributeSet attr = new SimpleAttributeSet();
        attr.addAttribute(StyleConstants.Foreground, new Color(192, 192, 192));
        TextComponentWriter out = (TextComponentWriter)System.out;
        out.setAttributes(attr);
        System.out.println(message);
        out.setAttributes(null);
    }

    protected GosuPanel getGosuPanel() {
        return LabFrame.instance().getGosuPanel();
    }
}

