/*
 * Decompiled with CFR 0.152.
 */
package editor.settings;

import editor.settings.AbstractSettingsParameters;
import editor.settings.ISettings;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;

public abstract class AbstractSettings<T extends AbstractSettingsParameters<T>>
implements ISettings<T> {
    private T _params;
    private transient String _name;
    private transient String _path;
    private transient Set<BiConsumer<T, T>> _listeners;

    public AbstractSettings(T params, String name, String path) {
        this._params = params;
        this._name = name;
        this._path = path;
        this._listeners = new HashSet<BiConsumer<T, T>>();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public T getParams() {
        return this._params;
    }

    @Override
    public void setParams(T params, boolean persistent) {
        T oldValue = this._params;
        this._params = params;
        if (persistent) {
            this.notifyListeners(oldValue, params);
        }
    }

    @Override
    public void addChangeListener(BiConsumer<T, T> listener) {
        this._listeners.add(listener);
    }

    protected void notifyListeners(T oldValue, T params) {
        this._listeners.forEach(bicon -> bicon.accept(oldValue, params));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractSettings)) {
            return false;
        }
        AbstractSettings that = (AbstractSettings)o;
        return this._params.equals(that._params);
    }

    public int hashCode() {
        int result = this._params.hashCode();
        result = 31 * result + this._params.hashCode();
        return result;
    }
}

