/*
 * Decompiled with CFR 0.152.
 */
package editor.tabpane;

import editor.util.IEditableLabel;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class SimpleLabel
implements IEditableLabel {
    private String _strText;
    private Icon _icon;
    private EventListenerList _changeListeners;

    public SimpleLabel(String strText, Icon icon) {
        this.innerSetDisplayName(strText);
        this._icon = icon;
        this._changeListeners = new EventListenerList();
    }

    @Override
    public String getDisplayName() {
        return this._strText;
    }

    @Override
    public void setDisplayName(String strName) {
        this.innerSetDisplayName(strName);
        this.fireChanged();
    }

    private void innerSetDisplayName(String strText) {
        this._strText = strText;
    }

    @Override
    public Icon getIcon(int iTypeFlags) {
        return this._icon;
    }

    @Override
    public void setIcon(Icon icon, int iTypeFlags) {
        this._icon = icon;
        this.fireChanged();
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this._changeListeners.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this._changeListeners.remove(ChangeListener.class, l);
    }

    private void fireChanged() {
        Object[] listeners = this._changeListeners.getListenerList();
        if (listeners.length == 0) {
            return;
        }
        ChangeEvent e = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }
}

