/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.LabFrame;
import editor.util.BackgroundOperation;
import editor.util.EditorUtilities;
import editor.util.IModalHandler;
import editor.util.IProgressCallback;
import editor.util.IRunnableWithProgress;
import editor.util.LabGlassPane;
import editor.util.ModalEventQueue;
import editor.util.ProgressPanel;
import editor.util.ProgressWindow;
import gw.util.GosuExceptionUtil;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ProgressFeedback
implements IProgressCallback,
ActionListener {
    private static final int UPDATE_DELAY = 100;
    private String _strNotice;
    private ProgressPanel _pp;
    private ProgressWindow _pw;
    private boolean _bAbort;
    private boolean _bHideAbortButton;
    private boolean _bShowInStudioGlassPane;
    private String _currentMessage = "";
    private int _currentValue = 0;
    private int _length = 0;
    private boolean _changeLength = true;
    private Timer _timer;

    public static ProgressFeedback runWithProgress(String strNotice, IRunnableWithProgress task) {
        return ProgressFeedback.runWithProgress(strNotice, task, false, false);
    }

    public static ProgressFeedback runWithProgress(String strNotice, IRunnableWithProgress task, boolean bHideAbortBtn) {
        return ProgressFeedback.runWithProgress(task, new ProgressFeedback(strNotice, bHideAbortBtn, false));
    }

    public static ProgressFeedback runWithProgress(String strNotice, IRunnableWithProgress task, boolean bHideAbortBtn, boolean bShowInStudioGlassPane) {
        return ProgressFeedback.runWithProgress(task, new ProgressFeedback(strNotice, bHideAbortBtn, bShowInStudioGlassPane));
    }

    protected static ProgressFeedback runWithProgress(IRunnableWithProgress task, ProgressFeedback progressFeedback) {
        BackgroundOperation.instance().doBackgroundWaitOp(() -> {
            try {
                progressFeedback.startTimer();
                task.run(progressFeedback);
            }
            catch (Throwable e) {
                EditorUtilities.handleUncaughtException(e);
            }
            finally {
                progressFeedback.stopTimer();
                progressFeedback.dispose();
            }
        });
        return progressFeedback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <T> T runWithPossibleDialog(final Callable<T> callable, String message) {
        if (!LabFrame.instance().isVisible() || !SwingUtilities.isEventDispatchThread()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw GosuExceptionUtil.convertToRuntimeException((Throwable)e);
            }
        }
        final ProgressFeedback[] waitDialog = new ProgressFeedback[]{null};
        final boolean[] done = new boolean[]{false};
        final Object[] ret = new Object[]{null};
        final Throwable[] throwable = new Throwable[]{null};
        new ProgressFeedbackThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ret[0] = callable.call();
                }
                catch (Throwable t) {
                    throwable[0] = t;
                }
                finally {
                    boolean[] blArray = done;
                    synchronized (done) {
                        done[0] = true;
                        done.notifyAll();
                        SwingUtilities.invokeLater(() -> {
                            ProgressFeedback[] progressFeedbackArray = waitDialog;
                            synchronized (waitDialog) {
                                if (waitDialog[0] != null) {
                                    waitDialog[0].stopTimer();
                                    waitDialog[0].dispose();
                                }
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                        });
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
            }
        }.start();
        boolean localDone = ProgressFeedback.shortWait(100L, done);
        if (!localDone) {
            try {
                EditorUtilities.showWaitCursor(true);
                localDone = ProgressFeedback.shortWait(2900L, done);
            }
            finally {
                EditorUtilities.showWaitCursor(false);
            }
        }
        if (!localDone) {
            ProgressFeedback[] progressFeedbackArray = waitDialog;
            // MONITORENTER : waitDialog
            waitDialog[0] = new ProgressFeedback(message, true, false);
            waitDialog[0].setLength(-1);
            waitDialog[0].startTimer();
            // MONITOREXIT : progressFeedbackArray
            ProgressFeedback.waitForProgress(done);
        }
        if (throwable[0] == null) return (T)ret[0];
        if (!(throwable[0] instanceof InvocationTargetException)) throw GosuExceptionUtil.forceThrow((Throwable)throwable[0]);
        throw GosuExceptionUtil.forceThrow((Throwable)throwable[0].getCause());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean shortWait(long delay, boolean[] done) {
        long waitUntil = System.currentTimeMillis() + delay;
        boolean[] blArray = done;
        synchronized (done) {
            while (true) {
                long remainingTime = waitUntil - System.currentTimeMillis();
                if (done[0]) return done[0];
                if (remainingTime <= 0L) break;
                try {
                    done.wait(remainingTime);
                }
                catch (InterruptedException interruptedException) {}
            }
            return done[0];
        }
    }

    private static void waitForProgress(final boolean[] done) {
        new ModalEventQueue(new IModalHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isModal() {
                boolean[] blArray = done;
                synchronized (done) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return !done[0];
                }
            }
        }).run();
    }

    protected ProgressFeedback(String strNotice, boolean bHideAbortButton, boolean bShowInStudioGlassPane) {
        this._strNotice = strNotice;
        this._bHideAbortButton = bHideAbortButton;
        this._bShowInStudioGlassPane = bShowInStudioGlassPane;
    }

    void dispose() {
        if (this._pp == null) {
            return;
        }
        EditorUtilities.invokeInDispatchThread(() -> {
            if (this._bShowInStudioGlassPane) {
                LabGlassPane.getInstance().removeModalComponent(this._pp);
            } else {
                this._pw.dispose();
            }
            this._pp = null;
            this._pw = null;
        });
    }

    private void startTimer() {
        this._timer = new Timer(100, e -> {
            if (!GraphicsEnvironment.isHeadless()) {
                if (this._pp == null) {
                    this._pp = new ProgressPanel(this._length, this._strNotice, this, this._bHideAbortButton);
                    this._pp.setSize(this._pp.getPreferredSize());
                    if (this._pp.getWidth() < 400) {
                        Dimension size = new Dimension(400, this._pp.getHeight());
                        this._pp.setSize(size);
                        this._pp.setPreferredSize(size);
                    }
                    if (this._bShowInStudioGlassPane) {
                        LabGlassPane.getInstance().addModalComponent(this._pp);
                    } else {
                        this._pw = new ProgressWindow(this._pp);
                        this._pw.show();
                    }
                }
                if (this._changeLength) {
                    this._pp.setLength(this._length);
                    this._changeLength = false;
                }
                this._pp.updateProgress(this._currentValue, this._currentMessage);
            }
            if (this._bAbort) {
                this._timer.stop();
            }
        });
        this._timer.setRepeats(true);
        this._timer.start();
    }

    private void stopTimer() {
        if (this._timer != null) {
            this._timer.stop();
        }
    }

    @Override
    public void setLength(int iLength) {
        this._length = iLength;
        this._changeLength = true;
    }

    @Override
    public boolean updateProgress(int iProgress, String strMessage, String ... args) {
        this._currentValue = iProgress;
        this.setCurrentMessage(strMessage, args);
        return this._bAbort;
    }

    @Override
    public boolean incrementProgress(String strMessage, String ... args) {
        ++this._currentValue;
        this.setCurrentMessage(strMessage, args);
        return this._bAbort;
    }

    private void setCurrentMessage(String strMessage, String[] args) {
        this._currentMessage = strMessage == null ? "" : strMessage;
    }

    @Override
    public boolean updateProgress(String strMessage, String ... args) {
        this.setCurrentMessage(strMessage, args);
        return this._bAbort;
    }

    @Override
    public int getProgress() {
        return this._pp.getProgess();
    }

    @Override
    public boolean isAbort() {
        return this._bAbort;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._bAbort = true;
        this._timer.stop();
    }

    @Override
    public void operationComplete() {
        this.dispose();
    }

    public static class ProgressFeedbackThread
    extends Thread {
    }
}

