/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.BeanInfoPopup;
import editor.GosuEditor;
import editor.IPathCompletionHandler;
import editor.util.TextComponentUtil;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;

public abstract class AbstractPathCompletionHandler
implements IPathCompletionHandler {
    private GosuEditor _gsEditor;

    @Override
    public GosuEditor getGosuEditor() {
        return this._gsEditor;
    }

    @Override
    public void setGosuEditor(GosuEditor gsEditor) {
        this._gsEditor = gsEditor;
    }

    protected void displayPathCompletionBeanInfoPopup(BeanInfoPopup popup) {
        this.getGosuEditor().setCompletionPopup(popup);
        this.getGosuEditor().displayPathCompletionPopup(false);
    }

    protected void displayFeaturePathCompletionBeanInfoPopup(BeanInfoPopup popup) {
        this.getGosuEditor().setCompletionPopup(popup);
        this.getGosuEditor().displayPathCompletionPopup(true);
    }

    protected String getPathAtCaret() {
        return TextComponentUtil.getWordAtCaret(this._gsEditor.getEditor());
    }

    protected String getWordAtCaret() {
        return this.getLastWordInPath(this.getPathAtCaret());
    }

    protected String getSingleNameAtCaret() {
        String strMemberPath = TextComponentUtil.getPartialWordBeforeCaret(this._gsEditor.getEditor());
        if (strMemberPath != null && strMemberPath.length() > 0) {
            char cFirst;
            int iIndex = strMemberPath.lastIndexOf(46);
            if (iIndex >= 0) {
                strMemberPath = strMemberPath.substring(iIndex + 1);
            }
            char c = cFirst = strMemberPath.length() == 0 ? (char)'\u0000' : strMemberPath.charAt(0);
            if (!Character.isJavaIdentifierPart(cFirst) && cFirst != '.') {
                strMemberPath = " ";
            }
        }
        if (strMemberPath.endsWith(" ")) {
            return "";
        }
        return strMemberPath;
    }

    protected String getWordBeforeCaret() {
        return this.getLastWordInPath(this.getSingleNameAtCaret());
    }

    protected String getMemberPathFromPath(String strPath) {
        if (strPath == null) {
            return null;
        }
        int iDotIndex = strPath.indexOf(46);
        if (iDotIndex < 0) {
            return null;
        }
        return strPath.substring(iDotIndex + 1);
    }

    private String getLastWordInPath(String strMemberPath) {
        int iIndex;
        if (strMemberPath != null && (iIndex = strMemberPath.lastIndexOf(46)) >= 0) {
            return iIndex + 1 >= strMemberPath.length() ? "" : strMemberPath.substring(iIndex + 1);
        }
        return strMemberPath;
    }

    protected boolean isWordAtCaret(ISymbolTable transientSymTable) {
        String strMemberPath = this.getSingleNameAtCaret();
        String strBeanName = this.getRootBeanFromPath(strMemberPath);
        return strBeanName == null || strBeanName.length() == 0 || !Character.isJavaIdentifierPart(strBeanName.charAt(0));
    }

    protected ISymbol getSymbolAtCaret(ISymbolTable transientSymTable) {
        String strMemberPath = this.getSingleNameAtCaret();
        String strBeanName = this.getRootBeanFromPath(strMemberPath);
        boolean bHasWordAtCaret = this.isWordAtCaret(transientSymTable);
        ISymbol sym = null;
        if (!bHasWordAtCaret && (sym = this.getGosuEditor().getSymbolTable().getSymbol((CharSequence)strBeanName)) == null && transientSymTable != null) {
            sym = transientSymTable.getSymbol((CharSequence)strBeanName);
        }
        return sym;
    }

    protected String getRootBeanFromPath(String strPath) {
        int iDotIndex = strPath.indexOf(46);
        if (iDotIndex <= 0) {
            return strPath;
        }
        return strPath.substring(0, iDotIndex);
    }
}

