/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.Scheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public abstract class AbstractTreeCellRenderer<T>
extends JLabel
implements TreeCellRenderer {
    private boolean _bSelected;
    private T _node;
    private JTree _tree;

    public AbstractTreeCellRenderer(JTree tree) {
        this._tree = tree;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bHasFocus) {
        if (value != null) {
            this._node = value;
            this._bSelected = bSelected;
            this.configure();
        }
        return this;
    }

    protected T getNode() {
        return this._node;
    }

    public void update() {
        this._tree.repaint();
    }

    public abstract void configure();

    @Override
    public void paint(Graphics g) {
        Color bkColor;
        boolean bFocus;
        boolean bl = bFocus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == this._tree;
        if (this._bSelected) {
            bkColor = this._tree.isEnabled() && bFocus ? Scheme.active().getActiveCaption() : Scheme.active().getControl();
        } else {
            bkColor = this._tree.getBackground();
            if (bkColor == null) {
                bkColor = this.getBackground();
            }
        }
        if (bkColor != null) {
            g.setColor(bkColor);
            g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            if (this._bSelected) {
                g.setColor(this._tree.isEnabled() && bFocus ? Scheme.active().getXpBorderColor() : Scheme.active().getFieldBorderColor());
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            g.setColor(bkColor);
        }
        this.setForeground(Scheme.active().getWindowText());
        super.paint(g);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (dim != null) {
            dim = new Dimension(dim.width + 3, dim.height);
        }
        return dim;
    }
}

