/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.ArrayElementNode;
import editor.BeanInfoNode;
import editor.MethodNode;
import editor.PropertyNode;
import editor.util.EditorUtilities;
import gw.config.CommonServices;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.TypeInfoUtil;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import gw.util.CaseInsensitiveSet;
import gw.util.GosuStringUtil;
import gw.util.IFeatureFilter;
import java.beans.IndexedPropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class BeanTree
implements MutableTreeNode,
Comparable<BeanTree> {
    private static final String ARRAY_LENGTH_PREFIX = "length = ";
    private BeanInfoNode _node;
    private TreeNode _parent;
    private List<BeanTree> _children;
    private String _strNameConstraint;
    private boolean _bIncludeOnlySimpleDescriptors;
    private boolean _bChildrenEvaluated;
    private Boolean _bIncludeStaticMembers;
    private IFeatureFilter _filter;
    private IType _whosaskin;
    private boolean _bExpansion = true;

    public BeanTree(IType classBean, IType whosaskin, String strDisplayName, String strNameConstraint, Boolean bIncludeStaticMembers) {
        this(classBean, whosaskin, strDisplayName, strNameConstraint, bIncludeStaticMembers, null, true);
    }

    public BeanTree(IType classBean, IType whosaskin, String strDisplayName, String strNameConstraint, Boolean bIncludeStaticMembers, IFeatureFilter filter, boolean bExpansion) {
        this._whosaskin = whosaskin;
        this._node = new BeanInfoNode(classBean);
        this._node.setDisplayName(strDisplayName);
        this._strNameConstraint = strNameConstraint;
        this._bIncludeStaticMembers = bIncludeStaticMembers;
        this._filter = filter;
        this._bExpansion = bExpansion;
        this.initializeChildren();
    }

    public BeanTree(IType classBean, IType whosaskin, String strDisplayName, boolean bIncludeOnlySimpleDescriptors, Boolean bIncludeStaticMembers) {
        this(classBean, whosaskin, strDisplayName, bIncludeOnlySimpleDescriptors, bIncludeStaticMembers, null, true);
    }

    public BeanTree(IType classBean, IType whosaskin, String strDisplayName, boolean bIncludeOnlySimpleDescriptors, Boolean bIncludeStaticMembers, IFeatureFilter filter, boolean bExpansion) {
        this._whosaskin = whosaskin;
        this._node = new BeanInfoNode(classBean);
        this._node.setDisplayName(strDisplayName);
        this._bIncludeOnlySimpleDescriptors = bIncludeOnlySimpleDescriptors;
        this._bIncludeStaticMembers = bIncludeStaticMembers;
        this._filter = filter;
        this._bExpansion = bExpansion;
        this.initializeChildren();
    }

    public BeanTree(IType[] classBean, IType whosaskin) {
        this(classBean, whosaskin, false, false);
    }

    public BeanTree(IType[] classBean, IType whosaskin, boolean bIncludeOnlySimpleDescriptors, Boolean bIncludeStaticMembers) {
        this._whosaskin = whosaskin;
        this._bIncludeOnlySimpleDescriptors = bIncludeOnlySimpleDescriptors;
        this._bIncludeStaticMembers = bIncludeStaticMembers;
        this._node = new BeanInfoNode("Root");
        this._children = new ArrayList<BeanTree>();
        for (int i = 0; i < classBean.length; ++i) {
            String strBeanClassName = classBean[i].getName();
            int iDotIndex = strBeanClassName.lastIndexOf(46);
            String strSymbolName = strBeanClassName.substring(iDotIndex + 1);
            BeanTree beanTree = new BeanTree(classBean[i], whosaskin, strSymbolName, bIncludeOnlySimpleDescriptors, bIncludeStaticMembers);
            this._children.add(beanTree);
            beanTree.setParent(this);
        }
    }

    BeanTree(IMethodInfo descriptor, TreeNode parent, IType whosAskin) {
        this._whosaskin = whosAskin;
        this._node = new MethodNode(descriptor);
        this._parent = parent;
    }

    private BeanTree(IMethodInfo descriptor, BeanTree parent) {
        this._whosaskin = parent._whosaskin;
        this._node = new MethodNode(descriptor);
        this._parent = parent;
    }

    BeanTree(ITypeInfo owner, IPropertyInfo pi, boolean arrayicize, IType whosAskin, TreeNode parent) {
        this._whosaskin = whosAskin;
        this._node = new PropertyNode(owner, pi, arrayicize, this._whosaskin);
        this._parent = parent;
    }

    private BeanTree(ITypeInfo owner, IPropertyInfo pi, boolean arrayicize, BeanTree parent) {
        this._whosaskin = parent._whosaskin;
        this._node = new PropertyNode(owner, pi, arrayicize, this._whosaskin);
        this._parent = parent;
    }

    BeanTree(BeanInfoNode node, IType whosAskin, TreeNode parent) {
        this._whosaskin = whosAskin;
        this._node = node;
        this._parent = parent;
    }

    private BeanTree(BeanInfoNode node, BeanTree parent) {
        this._whosaskin = parent._whosaskin;
        this._node = node;
        this._parent = parent;
    }

    public BeanInfoNode getBeanNode() {
        return this._node;
    }

    public void setBeanNode(BeanInfoNode node) {
        this._node = node;
    }

    protected void initializeChildren() {
        if (this._children != null) {
            return;
        }
        this._children = new ArrayList<BeanTree>();
        IType type = this._node.getType();
        if (!(TypeSystem.isBeanType((IType)type) || type instanceof IMetaType || type == JavaTypes.STRING() || type == JavaTypes.NUMBER() || type.isArray())) {
            return;
        }
        try {
            boolean wasArray;
            boolean bl = wasArray = this._bExpansion && TypeSystem.isExpandable((IType)type);
            if (wasArray) {
                if (type.isArray() && this.getBeanNode().getValue() != null) {
                    this.addArrayElementNodes();
                    return;
                }
                type = CommonServices.getTypeSystem().getExpandableComponentType(type);
            }
            ITypeInfo beanInfo = null;
            try {
                beanInfo = type.getTypeInfo();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (beanInfo == null) {
                return;
            }
            this.addFeatureNodes(beanInfo, wasArray);
            Collections.sort(this._children);
        }
        catch (Exception e) {
            EditorUtilities.handleUncaughtException(e);
            String message = e.getMessage();
            if (GosuStringUtil.isEmpty((String)message)) {
                EditorUtilities.displayError(e);
            }
            EditorUtilities.displayError(message);
        }
    }

    private void addFeatureNodes(ITypeInfo beanInfo, boolean arrayicize) {
        this.addPropertyNodes(beanInfo, arrayicize);
        if (!this.excludeMethodDescriptors() && !this.includeOnlySimpleDescriptors()) {
            this.addMethodNodes(beanInfo);
        }
    }

    private void addArrayElementNodes() {
        String strLengthValue = this.getBeanNode().getValue();
        if (strLengthValue == null) {
            return;
        }
        int iIndex = strLengthValue.indexOf(ARRAY_LENGTH_PREFIX);
        if (iIndex < 0) {
            return;
        }
        strLengthValue = strLengthValue.substring(iIndex + ARRAY_LENGTH_PREFIX.length());
        try {
            int iArrayLength = Integer.parseInt(strLengthValue);
            IType atomicType = this._node.getType().getComponentType();
            for (int i = 0; i < iArrayLength; ++i) {
                this._children.add(new BeanTree(new ArrayElementNode(atomicType, i), this));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.evaluateProperties();
    }

    private void addMethodNodes(ITypeInfo beanInfo) {
        MethodList methods = beanInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)beanInfo).getMethods(this._whosaskin) : beanInfo.getMethods();
        CaseInsensitiveSet signatures = new CaseInsensitiveSet();
        if (!methods.isEmpty()) {
            for (IMethodInfo method : methods) {
                String signature;
                if (this.shouldFilter(method.getDisplayName()) || this.isHidden(beanInfo, (IAttributedFeatureInfo)method) || !this.mutualExclusiveStaticFilter(beanInfo, (IAttributedFeatureInfo)method) || signatures.contains(signature = TypeInfoUtil.getMethodSignature((IMethodInfo)method))) continue;
                this._children.add(new BeanTree(method, this));
                signatures.add(signature);
            }
        }
    }

    private void addPropertyNodes(ITypeInfo beanInfo, boolean arrayicize) {
        List properties = beanInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)beanInfo).getProperties(this._whosaskin) : beanInfo.getProperties();
        CaseInsensitiveSet propertyNames = new CaseInsensitiveSet();
        for (IPropertyInfo property : properties) {
            String displayName;
            IType propType;
            IndexedPropertyDescriptor indexedProp;
            if (this.shouldFilter(property.getName()) || property instanceof IndexedPropertyDescriptor && (indexedProp = (IndexedPropertyDescriptor)property).getPropertyType() == null || this.isHidden(beanInfo, (IAttributedFeatureInfo)property) || !this.mutualExclusiveStaticFilter(beanInfo, (IAttributedFeatureInfo)property) || this.includeOnlySimpleDescriptors() && ((propType = property.getFeatureType()).isArray() || !this.isSimple(propType)) || propertyNames.contains(displayName = property.getDisplayName())) continue;
            this._children.add(new BeanTree(beanInfo, property, arrayicize && !TypeSystem.isExpandable((IType)property.getFeatureType()), this));
            propertyNames.add(displayName);
        }
        this.evaluateProperties();
    }

    private boolean isSimple(IType cls) {
        return cls.isPrimitive() || JavaTypes.STRING().isAssignableFrom(cls) || JavaTypes.NUMBER().isAssignableFrom(cls) || JavaTypes.BOOLEAN().isAssignableFrom(cls) || JavaTypes.DATE().isAssignableFrom(cls);
    }

    private boolean isHidden(ITypeInfo beanInfo, IAttributedFeatureInfo feature) {
        return feature.isHidden() || !feature.isScriptable() || this.hideDeprecated(feature) || this.isInternal(feature) || feature.getName().equals("IntrinsicType") || this.getFeatureFilter() != null && !this.getFeatureFilter().acceptFeature(beanInfo.getOwnersType(), (IFeatureInfo)feature);
    }

    private boolean mutualExclusiveStaticFilter(ITypeInfo beanInfo, IAttributedFeatureInfo descriptor) {
        if (this.includeStaticMembers() == null) {
            return true;
        }
        if (beanInfo.getOwnersType() instanceof IMetaType || this.includeStaticMembers().booleanValue()) {
            return descriptor.isStatic();
        }
        return !descriptor.isStatic();
    }

    private boolean isInternal(IAttributedFeatureInfo feature) {
        return feature instanceof IMethodInfo && feature.getDisplayName().startsWith("@");
    }

    private boolean shouldFilter(String strMemberName) {
        if (this._strNameConstraint != null && this._strNameConstraint.length() > 0 && Character.isJavaIdentifierStart(this._strNameConstraint.charAt(0))) {
            return !strMemberName.toLowerCase().startsWith(this._strNameConstraint.toLowerCase());
        }
        return false;
    }

    final boolean methodsEqual(Method m1, Method m2) {
        Class<?>[] params2;
        Class<?>[] params1;
        if (m1 == null || m2 == null) {
            return false;
        }
        if (m1.getName().equals(m2.getName()) && (params1 = m1.getParameterTypes()).length == (params2 = m2.getParameterTypes()).length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public TreeNode getChildAt(int iChildIndex) {
        return this._children.get(iChildIndex);
    }

    @Override
    public int getChildCount() {
        this.initializeChildren();
        return this._children.size();
    }

    @Override
    public TreeNode getParent() {
        return this._parent;
    }

    public void setParent(TreeNode parent) {
        this._parent = parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        BeanTree beanTree = (BeanTree)node;
        return this._children.indexOf(beanTree);
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        if (this._children == null) {
            return false;
        }
        return this.getChildCount() == 0;
    }

    public Enumeration children() {
        this.initializeChildren();
        return new BeanTreeEnumeration();
    }

    @Override
    public int compareTo(BeanTree o) {
        if (this._node == null) {
            return o._node == null ? 0 : -1;
        }
        if (o._node == null) {
            return 1;
        }
        return this._node.compareTo(o._node);
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        MutableTreeNode oldParent = (MutableTreeNode)child.getParent();
        if (oldParent != null) {
            oldParent.remove(child);
        }
        child.setParent(this);
        this._children.add(index, (BeanTree)child);
    }

    @Override
    public void remove(int index) {
        MutableTreeNode child = (MutableTreeNode)this.getChildAt(index);
        this._children.remove(index);
        child.setParent(null);
    }

    @Override
    public void remove(MutableTreeNode node) {
        this._children.remove(node);
        node.setParent(null);
    }

    @Override
    public void setUserObject(Object object) {
    }

    @Override
    public void removeFromParent() {
        MutableTreeNode parent = (MutableTreeNode)this.getParent();
        if (parent != null) {
            parent.remove(this);
        }
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this._parent = (BeanTree)newParent;
    }

    public String makePath(boolean bFeatureLiteralCompletion) {
        BeanInfoNode node;
        StringBuilder path = new StringBuilder();
        TreeNode tree = this;
        while (tree instanceof BeanTree && (node = tree.getBeanNode()).getType() != null) {
            if (path.length() == 0) {
                path.append(node.getPathComponent(bFeatureLiteralCompletion));
            } else {
                if (node.getName() != null && node.getName().length() > 0) {
                    path.insert(0, '.');
                }
                path.insert(0, node.getName());
            }
            tree = tree.getParent();
        }
        return path.toString();
    }

    public List<BeanTree> getChildren() {
        return this._children;
    }

    private boolean includeOnlySimpleDescriptors() {
        if (this._bIncludeOnlySimpleDescriptors) {
            return true;
        }
        if (!(this._parent instanceof BeanTree)) {
            return false;
        }
        return ((BeanTree)this._parent).includeOnlySimpleDescriptors();
    }

    private boolean excludeMethodDescriptors() {
        if (!(this._parent instanceof BeanTree)) {
            return false;
        }
        return ((BeanTree)this._parent).excludeMethodDescriptors();
    }

    private IFeatureFilter getFeatureFilter() {
        if (this._filter != null) {
            return this._filter;
        }
        if (!(this._parent instanceof BeanTree)) {
            return null;
        }
        return ((BeanTree)this._parent).getFeatureFilter();
    }

    private Boolean includeStaticMembers() {
        return this._bIncludeStaticMembers;
    }

    private void evaluateProperties() {
        if (this.isChildrenEvaluated()) {
            return;
        }
        this.setChildrenEvaluated(true);
    }

    private String getRootPath(BeanTree tree) {
        if (tree.getParent().getParent() == null) {
            return tree.getBeanNode().getName();
        }
        if (tree.getBeanNode() instanceof ArrayElementNode) {
            return this.getRootPath((BeanTree)tree.getParent()) + tree.getBeanNode().getName();
        }
        return this.getRootPath((BeanTree)tree.getParent()) + "." + tree.getBeanNode().getName();
    }

    private boolean isChildrenEvaluated() {
        return this._bChildrenEvaluated;
    }

    private void setChildrenEvaluated(boolean bChildrenEvaluated) {
        this._bChildrenEvaluated = bChildrenEvaluated;
    }

    private boolean hideDeprecated(IAttributedFeatureInfo descriptor) {
        return BeanTree.isHideDeprecatedMembers() && descriptor.isDeprecated();
    }

    public static boolean isHideDeprecatedMembers() {
        return true;
    }

    class BeanTreeEnumeration
    implements Enumeration {
        int _iCount;
        int _iChildCount;

        public BeanTreeEnumeration() {
            this._iChildCount = BeanTree.this._children.size();
        }

        @Override
        public boolean hasMoreElements() {
            return this._iCount < this._iChildCount;
        }

        public Object nextElement() {
            if (this._iCount >= this._iChildCount) {
                return null;
            }
            return BeanTree.this._children.get(this._iCount++);
        }
    }
}

