/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.DefaultContextMenuHandler;
import editor.EditorHost;
import editor.FileTree;
import editor.FileTreeUtil;
import editor.GosuClassLineInfoManager;
import editor.GosuEditor;
import editor.SimpleLineInfoManager;
import editor.StandardEditor;
import editor.undo.AtomicUndoManager;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ScriptabilityModifiers;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuClass;
import gw.util.PathUtil;
import java.nio.file.Path;

public class EditorFactory {
    public static EditorHost createEditor(Path file, IScriptPartId partId) {
        FileTree fileTree = FileTreeUtil.find(file, partId == null ? null : partId.getContainingTypeName());
        IType type = fileTree.getType();
        return EditorFactory.createEditor(file, type);
    }

    private static EditorHost createEditor(Path file, IType type) {
        if (type instanceof IGosuClass) {
            GosuEditor editor = new GosuEditor(new GosuClassLineInfoManager(), new AtomicUndoManager(10000), (IScriptabilityModifier)ScriptabilityModifiers.SCRIPTABLE, new DefaultContextMenuHandler(), false, true);
            EditorFactory.initEditorMode(file, editor);
            return editor;
        }
        return new StandardEditor(new SimpleLineInfoManager(), type);
    }

    private static GosuEditor initEditorMode(Path file, GosuEditor editor) {
        if (file != null && PathUtil.getName((Path)file) != null) {
            if (PathUtil.getName((Path)file).endsWith(".gsx")) {
                editor.setProgram(false);
                editor.setTemplate(false);
                editor.setClass(false);
                editor.setEnhancement(true);
            } else if (PathUtil.getName((Path)file).endsWith(".gs")) {
                editor.setProgram(false);
                editor.setTemplate(false);
                editor.setClass(true);
                editor.setEnhancement(false);
            } else if (PathUtil.getName((Path)file).endsWith(".gst")) {
                editor.setProgram(false);
                editor.setTemplate(true);
                editor.setClass(false);
                editor.setEnhancement(false);
            } else {
                editor.setProgram(true);
                editor.setTemplate(false);
                editor.setClass(false);
                editor.setEnhancement(false);
            }
        }
        return editor;
    }
}

