/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractTree;
import editor.ITreeNode;
import editor.LabFrame;
import editor.NodeKind;
import editor.util.EditorUtilities;
import gw.lang.parser.IParseIssue;
import gw.lang.reflect.IType;
import java.awt.EventQueue;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class MessageTree
extends AbstractTree<MessageTree, IssueNode> {
    public MessageTree(JTree tree) {
        super(tree);
    }

    public MessageTree(String text, NodeKind kind, IssueNode data) {
        super(text, kind, data);
    }

    @Override
    public Icon getIcon() {
        return this.findIcon();
    }

    private Icon findIcon() {
        return this.hasFailures() ? EditorUtilities.loadIcon("images/failure.png") : (this.hasErrors() ? EditorUtilities.loadIcon("images/error.png") : (this.hasWarnings() ? EditorUtilities.loadIcon("images/warning.png") : EditorUtilities.loadIcon("images/info.png")));
    }

    @Override
    public JTree getTree() {
        return LabFrame.instance().getGosuPanel().getMessagesPanel().getTree();
    }

    public static IssueNode makeIssueMessage(IParseIssue issue) {
        return new IssueNode(issue);
    }

    public static IssueNode makeIssueMessage(Diagnostic<? extends JavaFileObject> issue, IType type) {
        return new IssueNode(issue, type);
    }

    public static IssueNode empty() {
        return IssueNode.EMPTY;
    }

    static class IssueNode
    implements ITreeNode {
        private static final IssueNode EMPTY = new IssueNode();
        private final int _line;
        private final int _column;
        private final String _fqn;

        private IssueNode() {
            this._line = -1;
            this._column = -1;
            this._fqn = null;
        }

        public IssueNode(IParseIssue issue) {
            this._line = issue.getLine();
            this._column = issue.getColumn();
            this._fqn = this.getOuterMostEnclosingClass((IType)issue.getSource().getGosuClass()).getName();
        }

        public IssueNode(Diagnostic<? extends JavaFileObject> issue, IType type) {
            this._line = (int)issue.getLineNumber();
            this._column = (int)issue.getColumnNumber();
            this._fqn = this.getOuterMostEnclosingClass(type).getName();
        }

        @Override
        public boolean hasTarget() {
            return this._fqn != null;
        }

        @Override
        public void jumpToTarget() {
            LabFrame.instance().getGosuPanel().openType(this._fqn, true);
            EventQueue.invokeLater(() -> LabFrame.instance().getGosuPanel().getCurrentEditor().gotoLine(this._line, this._column));
        }

        private IType getOuterMostEnclosingClass(IType innerClass) {
            IType outerMost;
            for (outerMost = innerClass; outerMost != null && outerMost.getEnclosingType() != null; outerMost = outerMost.getEnclosingType()) {
            }
            return outerMost;
        }
    }
}

