/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractPathCompletionHandler;
import editor.MetaInfoPopup;
import editor.PackageType;
import editor.PackageTypeLoader;
import editor.util.TextComponentUtil;
import gw.lang.parser.IExpression;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.expressions.IMemberAccessExpression;
import gw.lang.parser.expressions.INewExpression;
import gw.lang.parser.expressions.ITypeLiteralExpression;
import gw.lang.parser.statements.IUsesStatement;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.INamespaceType;
import gw.lang.reflect.IType;
import gw.util.GosuObjectUtil;

public class PackageCompletionHandler
extends AbstractPathCompletionHandler {
    @Override
    public boolean handleCompletePath(ISymbolTable transientSymTable) {
        IParsedElement prevElement;
        IParseTree prevSibling;
        IParseTree location;
        IExpression exprAtCaret = this.getGosuEditor().getExpressionAtCaret();
        if (exprAtCaret == null) {
            return false;
        }
        if (exprAtCaret instanceof ITypeLiteralExpression && exprAtCaret.getParent() instanceof INewExpression && (location = exprAtCaret.getLocation()) != null && (prevSibling = location.getPreviousSibling()) != null && (prevElement = prevSibling.getParsedElement()) instanceof IExpression) {
            exprAtCaret = (IExpression)prevElement;
        }
        Object strMemberPath = this.getSingleNameAtCaret();
        boolean bDotAtCaret = GosuObjectUtil.equals((Object)TextComponentUtil.getPartialWordBeforeCaret(this.getGosuEditor().getEditor()), (Object)".");
        boolean bFilterByLastPathElement = strMemberPath == null || !bDotAtCaret;
        PackageType type = null;
        StringBuffer sbFilter = new StringBuffer();
        if (exprAtCaret instanceof IMemberAccessExpression) {
            IMemberAccessExpression memberExpr = (IMemberAccessExpression)exprAtCaret;
            IType rootType = memberExpr.getRootType();
            if (!(rootType instanceof IErrorType) && !(rootType instanceof INamespaceType)) {
                return false;
            }
            type = PackageTypeLoader.instance().getType(rootType.getName());
            if (type == null) {
                strMemberPath = strMemberPath == null || ((String)strMemberPath).length() == 0 || memberExpr.getMemberName() == null ? "" : memberExpr.getMemberName();
                strMemberPath = memberExpr.getRootExpression().toString() + "." + (String)strMemberPath;
                type = this.getParentPackageType((String)strMemberPath, sbFilter);
            } else {
                sbFilter.append((String)strMemberPath);
            }
        } else if (exprAtCaret instanceof ITypeLiteralExpression && exprAtCaret.getParent() instanceof IUsesStatement) {
            type = this.getParentPackageType(((ITypeLiteralExpression)exprAtCaret).getType().getRelativeName(), sbFilter);
        }
        try {
            if (type != null) {
                MetaInfoPopup beanInfoPopup = new MetaInfoPopup(type, sbFilter.toString(), bFilterByLastPathElement, this.getGosuEditor());
                this.displayPathCompletionBeanInfoPopup(beanInfoPopup);
                return true;
            }
        }
        catch (ParseException e) {
            return false;
        }
        return false;
    }

    private PackageType getParentPackageType(String strMemberPath, StringBuffer sbOutFilter) {
        int iIndex = strMemberPath.lastIndexOf(46);
        if (iIndex > 0) {
            sbOutFilter.append(strMemberPath.substring(iIndex + 1));
            strMemberPath = strMemberPath.substring(0, iIndex);
            return PackageTypeLoader.instance().getType(strMemberPath);
        }
        return null;
    }
}

