/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.EditorHost;
import editor.EditorHostTextPane;
import editor.GosuEditor;
import editor.Scheme;
import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ScopeHighlighter
implements DocumentListener,
CaretListener,
FocusListener {
    private GosuEditor _editor;
    private Object _highlightTag;
    private Object _highlightTag2;
    private Runnable _highlightImmediately;
    private Timer _timer;
    private static final EditorHost.LabHighlighter HIGHLIGHTER = new EditorHost.LabHighlighter(Scheme.active().scopeHighlightColor());

    public ScopeHighlighter(GosuEditor gosuEditor) {
        this._editor = gosuEditor;
        this._highlightImmediately = this::highlightImmediately;
        this._timer = new Timer(300, e -> this.highlightUsagesUnderCaret());
        this._timer.setRepeats(false);
    }

    public void updateState() {
        SwingUtilities.invokeLater(this._highlightImmediately);
    }

    private void highlightImmediately() {
        EditorHostTextPane editor = this._editor.getEditor();
        if (this._highlightTag != null) {
            editor.getHighlighter().removeHighlight(this._highlightTag);
            editor.getHighlighter().removeHighlight(this._highlightTag2);
            this._highlightTag = null;
            this._highlightTag2 = null;
        }
        if (!editor.hasFocus() || editor.getSelectionStart() != editor.getSelectionEnd()) {
            return;
        }
        int caret = editor.getCaretPosition();
        try {
            String backwardsChar;
            Document doc = editor.getDocument();
            String forwardChar = this.positionInDoc(caret, doc) ? doc.getText(caret, 1) : "";
            String string = backwardsChar = this.positionInDoc(caret - 1, doc) ? doc.getText(caret - 1, 1) : "";
            if (forwardChar.equals("{")) {
                this.highlightMatchForward(editor, caret, forwardChar, "}");
            } else if (forwardChar.equals("(")) {
                this.highlightMatchForward(editor, caret, forwardChar, ")");
            } else if (forwardChar.equals("[")) {
                this.highlightMatchForward(editor, caret, forwardChar, "]");
            } else if (backwardsChar.equals("}")) {
                this.highlightMatchBackwards(editor, caret - 1, backwardsChar, "{");
            } else if (backwardsChar.equals(")")) {
                this.highlightMatchBackwards(editor, caret - 1, backwardsChar, "(");
            } else if (backwardsChar.equals("]")) {
                this.highlightMatchBackwards(editor, caret - 1, backwardsChar, "[");
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void highlightUsages() {
        if (this._timer.isRunning()) {
            this._timer.stop();
            this._timer.restart();
        } else {
            this._timer.start();
        }
    }

    private void highlightUsagesUnderCaret() {
        if (!this._editor.isVisible()) {
            return;
        }
        if (this._editor.isCompletionPopupShowing() || this._editor.isCompleteCode()) {
            return;
        }
        GosuEditor.postTaskInParserThread(() -> EventQueue.invokeLater(this._editor::highlightUsagesOfFeatureUnderCaret));
    }

    private boolean positionInDoc(int caret, Document doc) {
        return caret >= 0 && caret < doc.getLength();
    }

    private void highlightMatchForward(JEditorPane editor, int i, String c, String oppositeString) throws BadLocationException {
        Document document = editor.getDocument();
        int count = 1;
        int initial = i++;
        while (i < document.getLength()) {
            String text = document.getText(i, 1);
            if (text.equals(c)) {
                ++count;
            } else if (text.equals(oppositeString)) {
                --count;
            }
            if (count == 0) {
                if (i <= initial + 1) break;
                this._highlightTag = editor.getHighlighter().addHighlight(i, i + 1, HIGHLIGHTER);
                this._highlightTag2 = editor.getHighlighter().addHighlight(initial, initial + 1, HIGHLIGHTER);
                break;
            }
            ++i;
        }
    }

    private void highlightMatchBackwards(JEditorPane editor, int i, String c, String oppositeString) throws BadLocationException {
        Document document = editor.getDocument();
        int count = 1;
        int initial = i--;
        while (i > 0) {
            String text = document.getText(i, 1);
            if (text.equals(c)) {
                ++count;
            } else if (text.equals(oppositeString)) {
                --count;
            }
            if (count == 0) {
                if (i + 1 >= initial) break;
                this._highlightTag = editor.getHighlighter().addHighlight(i, i + 1, HIGHLIGHTER);
                this._highlightTag2 = editor.getHighlighter().addHighlight(initial, initial + 1, HIGHLIGHTER);
                break;
            }
            --i;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateState();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateState();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.highlightImmediately();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.highlightImmediately();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.highlightImmediately();
    }
}

