/*
 * Decompiled with CFR 0.152.
 */
package editor.debugger;

import editor.debugger.Breakpoint;
import editor.debugger.IBreakpointFactory;
import editor.util.EditorUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BreakpointTree
implements MutableTreeNode {
    private Breakpoint _bp;
    private IBreakpointFactory _factory;
    private BreakpointTree _parent;
    private List<BreakpointTree> _children;

    public BreakpointTree() {
        this._children = Collections.emptyList();
    }

    public BreakpointTree(IBreakpointFactory factory, BreakpointTree parent) {
        this._parent = parent;
        this._factory = factory;
        this._children = Collections.emptyList();
    }

    public BreakpointTree(Breakpoint bp, BreakpointTree parent) {
        this._parent = parent;
        this._bp = bp;
        this._children = Collections.emptyList();
    }

    public Breakpoint getBreakpoint() {
        return this._bp;
    }

    public IBreakpointFactory getFactory() {
        return this._factory;
    }

    public boolean isTerminal() {
        return this.getBreakpoint() != null;
    }

    public List<BreakpointTree> getChildren() {
        return this._children;
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        if (this._children.isEmpty()) {
            this._children = new ArrayList<BreakpointTree>();
        }
        this._children.add(index, (BreakpointTree)child);
        child.setParent(this);
    }

    public void addChild(BreakpointTree child) {
        this.insert(child, this._children.size());
    }

    public void addViaModel(JTree tree, MutableTreeNode child) {
        ((DefaultTreeModel)tree.getModel()).insertNodeInto(child, this, this.getChildCount());
    }

    public void insertViaModel(JTree tree, MutableTreeNode child, int index) {
        ((DefaultTreeModel)tree.getModel()).insertNodeInto(child, this, index);
    }

    public void deleteViaModel(JTree tree, MutableTreeNode child) {
        ((DefaultTreeModel)tree.getModel()).removeNodeFromParent(child);
    }

    @Override
    public void remove(int index) {
        this.remove(this.getChildren().get(index));
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.getChildren().remove(node);
    }

    @Override
    public void setUserObject(Object object) {
    }

    @Override
    public void removeFromParent() {
        this._parent.remove(this);
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this._parent = (BreakpointTree)newParent;
    }

    @Override
    public BreakpointTree getChildAt(int childIndex) {
        return this.getChildren().get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    public BreakpointTree getParent() {
        return this._parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getChildren().indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isTerminal();
    }

    @Override
    public boolean isLeaf() {
        return this.isTerminal();
    }

    public Enumeration children() {
        final Iterator<BreakpointTree> iter = this.getChildren().iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            public Object nextElement() {
                return iter.next();
            }
        };
    }

    public String toString() {
        return this._bp != null ? this._bp.getTitle() : (this._factory != null ? this._factory.getName() : "<root>");
    }

    public void select(JTree tree) {
        TreePath path = this.getPath();
        tree.expandPath(path);
        tree.setSelectionPath(path);
        tree.scrollPathToVisible(path);
    }

    public TreePath getPath() {
        List<BreakpointTree> path = this.makePath(new ArrayList<BreakpointTree>());
        return new TreePath(path.toArray(new BreakpointTree[path.size()]));
    }

    private List<BreakpointTree> makePath(List<BreakpointTree> path) {
        if (this.getParent() != null) {
            this.getParent().makePath(path);
        }
        path.add(this);
        return path;
    }

    public BreakpointTree find(Breakpoint bp) {
        if (bp == null) {
            return null;
        }
        if (bp.equals(this.getBreakpoint())) {
            return this;
        }
        for (BreakpointTree tree : this.getChildren()) {
            BreakpointTree found = tree.find(bp);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public Icon getIcon() {
        return this.getBreakpoint() == null || this.getBreakpoint().isActive() ? EditorUtilities.loadIcon("images/debug_linebreakpoint.png") : EditorUtilities.loadIcon("images/disabled_breakpoint.png");
    }
}

