/*
 * Decompiled with CFR 0.152.
 */
package editor.run;

import editor.run.AbstractRunConfig;
import editor.run.FqnRunConfigParameters;
import editor.run.IProcessRunner;
import editor.run.OutOfProcessDebug;
import editor.run.OutOfProcessRun;
import gw.lang.reflect.TypeSystem;
import gw.util.PathUtil;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public abstract class FqnRunConfig<T extends FqnRunConfigParameters<T>>
extends AbstractRunConfig<T> {
    public FqnRunConfig(T params) {
        super(params);
    }

    protected FqnRunConfig() {
    }

    public String getFqn() {
        return ((FqnRunConfigParameters)this.getParams()).getFqn();
    }

    public String getVmArgs() {
        return ((FqnRunConfigParameters)this.getParams()).getVmArgs();
    }

    public String getProgArgs() {
        return ((FqnRunConfigParameters)this.getParams()).getProgArgs();
    }

    public String getWorkingDir() {
        return ((FqnRunConfigParameters)this.getParams()).getWorkingDir();
    }

    public boolean isJreEnabled() {
        return ((FqnRunConfigParameters)this.getParams()).isJreEnabled();
    }

    public String getJre() {
        return ((FqnRunConfigParameters)this.getParams()).getJre();
    }

    @Override
    public boolean isValid() {
        return TypeSystem.getByFullNameIfValid((String)this.getFqn()) != null;
    }

    @Override
    public boolean isRunnable() {
        return true;
    }

    @Override
    public boolean isDebuggable() {
        return true;
    }

    @Override
    public IProcessRunner run() {
        OutOfProcessRun processRunner = new OutOfProcessRun();
        processRunner.execute(this);
        return processRunner;
    }

    @Override
    public IProcessRunner debug() {
        OutOfProcessDebug processRunner = new OutOfProcessDebug();
        processRunner.execute(this);
        return processRunner;
    }

    public List<String> makeVmArgs() {
        String vmArgs = this.getVmArgs();
        if (vmArgs == null || vmArgs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(vmArgs, " \t\n");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            list.add(token);
        }
        return list;
    }

    public List<String> makeProgArgs() {
        String ProgArgs = this.getProgArgs();
        if (ProgArgs == null || ProgArgs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(ProgArgs, " \t\n");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            list.add(token);
        }
        return list;
    }

    public String getJreForProcessOrDefault() {
        return this.getJreForProcessOrDefault(null);
    }

    public String getJreForProcessOrDefault(String defaultJreHome) {
        String jreHomeDir;
        String string = jreHomeDir = this.isJreEnabled() ? this.getJre() : null;
        if (jreHomeDir != null && !jreHomeDir.isEmpty()) {
            Path dir = PathUtil.create((String)jreHomeDir, (String[])new String[]{"bin"});
            if (PathUtil.isDirectory((Path)dir, (LinkOption[])new LinkOption[0])) {
                return jreHomeDir;
            }
            throw new RuntimeException("Invalid JRE path: " + jreHomeDir);
        }
        return defaultJreHome == null ? System.getProperty("java.home") : defaultJreHome;
    }

    public Path getWorkingDirForProcess() {
        Path dir;
        String workingDir = this.getWorkingDir();
        if (workingDir != null && !workingDir.isEmpty() && PathUtil.isDirectory((Path)(dir = PathUtil.create((String)workingDir, (String[])new String[0])), (LinkOption[])new LinkOption[0])) {
            return dir;
        }
        return PathUtil.create((String)".", (String[])new String[0]);
    }
}

