/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import gw.lang.parser.IReducedDynamicFunctionSymbol;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.MethodInfoDelegate;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.PropertyInfoDelegate;
import gw.lang.reflect.gs.IGosuConstructorInfo;
import gw.lang.reflect.gs.IGosuMethodInfo;
import gw.lang.reflect.java.IJavaClassConstructor;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaConstructorInfo;
import gw.lang.reflect.java.IJavaMethodInfo;
import gw.lang.reflect.java.IJavaType;
import java.util.List;

public class FeatureUtil {
    static IConstructorInfo findRootConstructorInfo(IConstructorInfo ci) {
        IType ownersType = ci.getOwnersType();
        IType genType = FeatureUtil.getGenericType(ownersType);
        if (genType != ownersType) {
            if (ci instanceof IGosuConstructorInfo) {
                IReducedDynamicFunctionSymbol dfs = ((IGosuConstructorInfo)ci).getDfs();
                if (dfs != null) {
                    IReducedDynamicFunctionSymbol backingDfs = dfs.getBackingDfs();
                    while (backingDfs != null && backingDfs != dfs) {
                        ci = (IConstructorInfo)backingDfs.getMethodOrConstructorInfo();
                        dfs = backingDfs;
                        backingDfs = dfs.getBackingDfs();
                    }
                }
            } else if (ci instanceof IJavaConstructorInfo) {
                return FeatureUtil.findConstructor((IJavaType)genType, ((IJavaConstructorInfo)ci).getJavaConstructor());
            }
        }
        return ci;
    }

    static IPropertyInfo findRootPropertyInfo(IPropertyInfo pi) {
        while (pi instanceof PropertyInfoDelegate) {
            pi = ((PropertyInfoDelegate)pi).getSource();
        }
        IType ownersType = pi.getOwnersType();
        IType genType = FeatureUtil.getGenericType(ownersType = (pi = FeatureUtil.findRootPropertyInfo(ownersType, pi)).getOwnersType());
        if (genType != ownersType) {
            ITypeInfo ti = genType.getTypeInfo();
            pi = ti instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)ti).getProperty(genType, (CharSequence)pi.getDisplayName()) : ti.getProperty((CharSequence)pi.getDisplayName());
        }
        return pi;
    }

    static IMethodInfo findRootMethodInfo(IMethodInfo mi) {
        while (mi instanceof MethodInfoDelegate) {
            mi = ((MethodInfoDelegate)mi).getSource();
        }
        IType ownersType = mi.getOwnersType();
        IType genType = FeatureUtil.getGenericType(ownersType = (mi = FeatureUtil.findRootMethodInfo(ownersType, mi)).getOwnersType());
        if (genType != ownersType) {
            if (mi instanceof IGosuMethodInfo) {
                IReducedDynamicFunctionSymbol dfs = ((IGosuMethodInfo)mi).getDfs();
                if (dfs != null) {
                    IReducedDynamicFunctionSymbol backingDfs = dfs.getBackingDfs();
                    while (backingDfs != null && backingDfs != dfs) {
                        mi = (IMethodInfo)backingDfs.getMethodOrConstructorInfo();
                        dfs = backingDfs;
                        backingDfs = dfs.getBackingDfs();
                    }
                }
            } else if (mi instanceof IJavaMethodInfo) {
                return FeatureUtil.findMethod((IJavaType)genType, ((IJavaMethodInfo)mi).getMethod());
            }
        }
        return mi;
    }

    private static IMethodInfo findMethod(IJavaType genType, IJavaClassMethod method) {
        MethodList methods = ((IRelativeTypeInfo)genType.getTypeInfo()).getMethods((IType)genType);
        for (IMethodInfo mi : methods.getMethods(method.getName())) {
            if (!(mi instanceof IJavaMethodInfo) || ((IJavaMethodInfo)mi).getMethod() != method) continue;
            return mi;
        }
        return null;
    }

    private static IConstructorInfo findConstructor(IJavaType genType, IJavaClassConstructor ctor) {
        List constructors = ((IRelativeTypeInfo)genType.getTypeInfo()).getConstructors((IType)genType);
        for (IConstructorInfo ci : constructors) {
            if (!(ci instanceof IJavaConstructorInfo) || ((IJavaConstructorInfo)ci).getJavaConstructor() != ctor) continue;
            return ci;
        }
        return null;
    }

    private static IPropertyInfo findRootPropertyInfo(IType genType, IPropertyInfo pi) {
        ITypeInfo ti;
        IPropertyInfo superPi;
        IType supertype = genType.getSupertype();
        if (supertype != null && (superPi = (ti = supertype.getTypeInfo()) instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)ti).getProperty(genType, (CharSequence)pi.getDisplayName()) : ti.getProperty((CharSequence)pi.getDisplayName())) != null) {
            return FeatureUtil.findRootPropertyInfo(supertype, superPi);
        }
        for (IType iface : genType.getInterfaces()) {
            ITypeInfo ti2 = iface.getTypeInfo();
            IPropertyInfo ifacePi = ti2 instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)ti2).getProperty(iface, (CharSequence)pi.getDisplayName()) : ti2.getProperty((CharSequence)pi.getDisplayName());
            if (ifacePi == null) continue;
            return FeatureUtil.findRootPropertyInfo(iface, ifacePi);
        }
        return pi;
    }

    private static IMethodInfo findRootMethodInfo(IType genType, IMethodInfo mi) {
        ITypeInfo ti;
        IMethodInfo superMi;
        IType supertype = genType.getSupertype();
        if (supertype != null && (superMi = (ti = supertype.getTypeInfo()) instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)ti).getMethod(genType, (CharSequence)mi.getDisplayName(), FeatureUtil.getParamTypes(mi.getParameters())) : ti.getMethod((CharSequence)mi.getDisplayName(), FeatureUtil.getParamTypes(mi.getParameters()))) != null) {
            return FeatureUtil.findRootMethodInfo(supertype, superMi);
        }
        for (IType iface : genType.getInterfaces()) {
            ITypeInfo ti2 = iface.getTypeInfo();
            IMethodInfo ifacePi = ti2 instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)ti2).getMethod(iface, (CharSequence)mi.getDisplayName(), FeatureUtil.getParamTypes(mi.getParameters())) : ti2.getMethod((CharSequence)mi.getDisplayName(), FeatureUtil.getParamTypes(mi.getParameters()));
            if (ifacePi == null) continue;
            return FeatureUtil.findRootMethodInfo(iface, ifacePi);
        }
        return mi;
    }

    static boolean methodInfosEqual(IMethodInfo mi, IMethodInfo targetMi) {
        IParameterInfo[] targetMiParams;
        if (mi == targetMi) {
            return true;
        }
        String name = mi.getDisplayName();
        if (name == null || !name.equals(targetMi.getDisplayName())) {
            return false;
        }
        IType targetType = targetMi.getOwnersType();
        if (!targetType.isAssignableFrom(mi.getOwnersType())) {
            return false;
        }
        IParameterInfo[] miParams = mi.getParameters();
        if (miParams.length != (targetMiParams = targetMi.getParameters()).length) {
            return false;
        }
        if (miParams.length == 0) {
            return true;
        }
        IType ownersType = mi.getOwnersType();
        ITypeInfo typeInfo = ownersType.getTypeInfo();
        return typeInfo instanceof IRelativeTypeInfo && (mi = ((IRelativeTypeInfo)typeInfo).getMethod(mi.getOwnersType(), (CharSequence)mi.getDisplayName(), FeatureUtil.getParamTypes(mi.getParameters()))) == targetMi;
    }

    static boolean constructorInfosEqual(IConstructorInfo ci, IConstructorInfo targetCi) {
        IParameterInfo[] targetMiParams;
        if (ci == targetCi) {
            return true;
        }
        IType targetType = targetCi.getOwnersType();
        if (!targetType.isAssignableFrom(ci.getOwnersType())) {
            return false;
        }
        IParameterInfo[] miParams = ci.getParameters();
        if (miParams.length != (targetMiParams = targetCi.getParameters()).length) {
            return false;
        }
        if (miParams.length == 0) {
            return true;
        }
        IType ownersType = ci.getOwnersType();
        ITypeInfo typeInfo = ownersType.getTypeInfo();
        return typeInfo instanceof IRelativeTypeInfo && (ci = ((IRelativeTypeInfo)typeInfo).getConstructor(ci.getOwnersType(), FeatureUtil.getParamTypes(ci.getParameters()))) == targetCi;
    }

    public static IType[] getParamTypes(IParameterInfo[] paramInfos) {
        IType[] argTypes = new IType[paramInfos.length];
        for (int i = 0; i < paramInfos.length; ++i) {
            IParameterInfo iParameterInfo = paramInfos[i];
            argTypes[i] = iParameterInfo.getFeatureType();
        }
        return argTypes;
    }

    static IType getGenericType(IType ownersType) {
        if (ownersType.isParameterizedType()) {
            return ownersType.getGenericType();
        }
        return ownersType;
    }
}

