/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import gw.lang.parser.ICapturedSymbol;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.ISymbol;
import gw.lang.parser.expressions.IIdentifierExpression;
import gw.lang.parser.expressions.ILocalVarDeclaration;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IType;

public class LocalVarFeatureInfo
implements IFeatureInfo {
    private final ISymbol _symbol;
    private final IFeatureInfo _container;

    public LocalVarFeatureInfo(IIdentifierExpression id) {
        this._symbol = this.findRootSymbol(id.getSymbol());
        this._container = this.findMethodInfo((IParsedElement)id);
    }

    public LocalVarFeatureInfo(IVarStatement decl) {
        this._symbol = decl.getSymbol();
        this._container = this.findMethodInfo((IParsedElement)decl);
    }

    public LocalVarFeatureInfo(ILocalVarDeclaration decl) {
        this._symbol = decl.getSymbol();
        this._container = this.findMethodInfo((IParsedElement)decl);
    }

    public ISymbol getSymbol() {
        return this._symbol;
    }

    public IFeatureInfo getContainer() {
        return this._container;
    }

    public IType getOwnersType() {
        return this._container.getOwnersType();
    }

    public String getName() {
        return this._symbol.getName();
    }

    public String getDisplayName() {
        return this._symbol.getDisplayName();
    }

    public String getDescription() {
        return this._symbol.getDisplayName();
    }

    private ISymbol findRootSymbol(ISymbol symbol) {
        while (symbol instanceof ICapturedSymbol) {
            symbol = ((ICapturedSymbol)symbol).getReferredSymbol();
        }
        return symbol;
    }

    private IFeatureInfo findMethodInfo(IParsedElement pe) {
        if (pe == null) {
            return null;
        }
        if (pe instanceof IFunctionStatement) {
            return ((IFunctionStatement)pe).getDynamicFunctionSymbol().getMethodOrConstructorInfo();
        }
        return this.findMethodInfo(pe.getParent());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalVarFeatureInfo that = (LocalVarFeatureInfo)o;
        if (this._symbol == that._symbol) {
            return true;
        }
        if (this._container != null ? !this._container.equals(that._container) : that._container != null) {
            return false;
        }
        if (this._symbol != null ? !this._symbol.equals(that._symbol) : that._symbol != null) {
            return false;
        }
        if (this._symbol != null) {
            return this._symbol.getIndex() == that._symbol.getIndex();
        }
        return true;
    }

    public int hashCode() {
        int result = this._symbol != null ? this._symbol.hashCode() : 0;
        result = 31 * result + (this._container != null ? this._container.hashCode() : 0);
        return result;
    }
}

