/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.FileTree;
import editor.FileTreeUtil;
import editor.GosuPanel;
import editor.LabFrame;
import editor.NodeKind;
import editor.search.AbstractSearcher;
import editor.search.FeatureUtil;
import editor.search.LocalVarFeatureInfo;
import editor.search.SearchElement;
import editor.search.SearchLocation;
import editor.search.SearchPanel;
import editor.search.SearchTree;
import editor.search.TextSearcher;
import editor.search.UsageTarget;
import editor.util.EditorUtilities;
import editor.util.ModalEventQueue;
import editor.util.ProgressFeedback;
import gw.lang.parser.IDynamicPropertySymbol;
import gw.lang.parser.IDynamicSymbol;
import gw.lang.parser.IExpression;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.ISymbol;
import gw.lang.parser.IToken;
import gw.lang.parser.expressions.IBeanMethodCallExpression;
import gw.lang.parser.expressions.IIdentifierExpression;
import gw.lang.parser.expressions.IMemberAccessExpression;
import gw.lang.parser.expressions.IMethodCallExpression;
import gw.lang.parser.expressions.INewExpression;
import gw.lang.parser.expressions.IPropertyAccessIdentifier;
import gw.lang.parser.expressions.IPropertyAsMethodCallIdentifier;
import gw.lang.parser.expressions.ITypeLiteralExpression;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.parser.statements.IAssignmentStatement;
import gw.lang.parser.statements.IClassFileStatement;
import gw.lang.parser.statements.IClassStatement;
import gw.lang.parser.statements.IMemberAssignmentStatement;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.INamespaceType;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IPropertyInfoDelegate;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.gs.IGosuClass;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;

public class UsageSearcher
extends AbstractSearcher {
    private final UsageTarget _target;
    private final boolean _searchText;
    private boolean _includeMemberUsage;
    private SearchTree _results;

    public UsageSearcher(UsageTarget target, boolean searchText, boolean includeMemberUsage) {
        this._target = target;
        this._searchText = searchText;
        this._includeMemberUsage = includeMemberUsage;
    }

    boolean includeMemberUsage() {
        return this._includeMemberUsage;
    }

    @Override
    public boolean search(FileTree tree, SearchTree results) {
        if (this.isExcluded(tree)) {
            return false;
        }
        IType type = tree.getType();
        if (this._searchText && !(type instanceof IGosuClass)) {
            return this.maybeSearchForText(tree, results);
        }
        List<SearchLocation> locations = this.findUsage((IGosuClass)type);
        if (locations.isEmpty()) {
            return false;
        }
        SearchTree searchTree = this.getOrMakePath(tree, results);
        for (SearchLocation loc : locations) {
            SearchTree.SearchTreeNode node = new SearchTree.SearchTreeNode(tree, loc);
            SearchTree res = new SearchTree(NodeKind.Info, node);
            if (searchTree.getTree() != null) {
                EditorUtilities.invokeInDispatchThread(() -> {
                    searchTree.addViaModel(res);
                    ((DefaultTreeModel)searchTree.getTree().getModel()).nodeChanged(this._results);
                });
                continue;
            }
            results.insert(res, res.getChildCount());
        }
        return true;
    }

    List<SearchLocation> findUsage(IGosuClass gsClass) {
        gsClass.isValid();
        IClassStatement classStmt = gsClass.getClassStatement();
        if (classStmt != null) {
            IClassFileStatement classFileStmt = classStmt.getClassFileStatement();
            Object pe = classFileStmt != null ? classFileStmt : classStmt;
            return this.findUsage((IParsedElement)pe);
        }
        return Collections.emptyList();
    }

    private List<SearchLocation> findUsage(IParsedElement pe) {
        List[] locations = new List[]{Collections.emptyList()};
        IFeatureInfo rootFi = this._target.getRootFeatureInfo();
        if (rootFi instanceof ITypeInfo) {
            IType type = rootFi.getOwnersType();
            pe.visit(elem -> {
                locations[0] = this.findUsage((IParsedElement)elem, type, (List<SearchLocation>)locations[0]);
            });
        } else if (rootFi instanceof IPropertyInfo) {
            pe.visit(elem -> {
                locations[0] = this.findUsage((IParsedElement)elem, (IPropertyInfo)rootFi, (List<SearchLocation>)locations[0]);
            });
        } else if (rootFi instanceof IMethodInfo) {
            pe.visit(elem -> {
                locations[0] = this.findUsage((IParsedElement)elem, (IMethodInfo)rootFi, (List<SearchLocation>)locations[0]);
            });
        } else if (rootFi instanceof IConstructorInfo) {
            pe.visit(elem -> {
                locations[0] = this.findUsage((IParsedElement)elem, (IConstructorInfo)rootFi, (List<SearchLocation>)locations[0]);
            });
        } else if (rootFi instanceof LocalVarFeatureInfo) {
            pe.visit(elem -> {
                locations[0] = this.findUsage((IParsedElement)elem, (LocalVarFeatureInfo)rootFi, (List<SearchLocation>)locations[0]);
            });
        } else {
            throw new IllegalStateException();
        }
        return locations[0];
    }

    private List<SearchLocation> findUsage(IParsedElement pe, IConstructorInfo findCi, List<SearchLocation> locations) {
        if (pe instanceof INewExpression) {
            IConstructorInfo latestCi;
            ITypeInfo typeInfo;
            IConstructorInfo ci = ((INewExpression)pe).getConstructor();
            if (ci == findCi) {
                return this.addSearchLocation(pe, locations);
            }
            if (ci == null) {
                return locations;
            }
            IType declaringType = ci.getOwnersType();
            if (declaringType == findCi.getOwnersType() && (typeInfo = declaringType.getTypeInfo()) instanceof IRelativeTypeInfo && (latestCi = ((IRelativeTypeInfo)typeInfo).getConstructor(declaringType, FeatureUtil.getParamTypes(ci.getParameters()))) != null && FeatureUtil.constructorInfosEqual(FeatureUtil.findRootConstructorInfo(latestCi), findCi)) {
                return this.addSearchLocation(pe, locations);
            }
        }
        return locations;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<SearchLocation> findUsage(IParsedElement pe, IMethodInfo findMi, List<SearchLocation> locations) {
        if (pe instanceof IMethodCallExpression) {
            IFunctionSymbol funcSym = ((IMethodCallExpression)pe).getFunctionSymbol();
            if (funcSym == null) return locations;
            if (!findMi.getDisplayName().equals(funcSym.getDisplayName())) {
                return locations;
            }
            IFunctionType functionType = ((IMethodCallExpression)pe).getFunctionType();
            if (functionType == null) return locations;
            IFeatureInfo mi = functionType.getMethodOrConstructorInfo();
            if (mi == null) return locations;
            if (!FeatureUtil.methodInfosEqual(FeatureUtil.findRootMethodInfo((IMethodInfo)mi), findMi)) return locations;
            return this.addSearchLocation(this.findNameToken(findMi.getDisplayName(), pe), locations);
        }
        if (pe instanceof IBeanMethodCallExpression) {
            if (!findMi.getDisplayName().equals(((IBeanMethodCallExpression)pe).getMemberName())) {
                return locations;
            }
            IFunctionType functionType = ((IBeanMethodCallExpression)pe).getFunctionType();
            if (functionType == null) return locations;
            IFeatureInfo mi = functionType.getMethodOrConstructorInfo();
            if (!(mi instanceof IMethodInfo)) return locations;
            if (!FeatureUtil.methodInfosEqual(FeatureUtil.findRootMethodInfo((IMethodInfo)mi), findMi)) return locations;
            return this.addSearchLocation(this.findNameToken(((IBeanMethodCallExpression)pe).getMemberName(), pe), locations);
        }
        if (!findMi.getName().startsWith("@")) return locations;
        String propertyName = findMi.getDisplayName().substring(1);
        if (pe instanceof IMemberAccessExpression) {
            if (((IMemberAccessExpression)pe).getType() instanceof INamespaceType) {
                return locations;
            }
            if (!propertyName.equals(((IMemberAccessExpression)pe).getMemberName())) {
                return locations;
            }
            boolean bSetter = findMi.getParameters().length > 0;
            IGosuClass gsClass = (IGosuClass)findMi.getOwnersType();
            IPropertyInfo findPi = gsClass.getTypeInfo().getProperty((IType)gsClass, (CharSequence)propertyName);
            try {
                IPropertyInfo pi = ((IMemberAccessExpression)pe).getPropertyInfo();
                if (pi == null) return locations;
                if (!this.propertyInfosEqual(pi, findPi)) return locations;
                IParsedElement parent = pe.getParent();
                if (bSetter) {
                    if (!(parent instanceof IMemberAssignmentStatement)) return locations;
                    if (((IMemberAssignmentStatement)parent).getMemberAccess() == pe) return this.addSearchLocation(this.findNameToken(findPi.getDisplayName(), pe), locations);
                    if (((IMemberAssignmentStatement)parent).getRootExpression() != pe) return locations;
                    return this.addSearchLocation(this.findNameToken(findPi.getDisplayName(), pe), locations);
                }
                if (!(parent instanceof IMemberAssignmentStatement)) return this.addSearchLocation(this.findNameToken(findPi.getDisplayName(), pe), locations);
                if (((IMemberAssignmentStatement)parent).getMemberAccess() == pe) return locations;
                if (((IMemberAssignmentStatement)parent).getRootExpression() == pe) return locations;
                return this.addSearchLocation(this.findNameToken(findPi.getDisplayName(), pe), locations);
            }
            catch (Exception e) {
                return locations;
            }
        }
        if (!(pe instanceof IIdentifierExpression)) return locations;
        if (pe instanceof IPropertyAccessIdentifier || pe instanceof IPropertyAsMethodCallIdentifier) {
            boolean bSetter = findMi.getParameters().length > 0;
            IGosuClass gsClass = (IGosuClass)findMi.getOwnersType();
            IPropertyInfo findPi = gsClass.getTypeInfo().getProperty((IType)gsClass, (CharSequence)propertyName);
            IPropertyInfo pi = (IPropertyInfo)((IDynamicPropertySymbol)((IIdentifierExpression)pe).getSymbol()).getPropertyInfo();
            if (pi == null) return locations;
            if (!this.propertyInfosEqual(pi, findPi)) return locations;
            IParsedElement parent = pe.getParent();
            if (bSetter) {
                if (!(parent instanceof IAssignmentStatement)) return locations;
                if (((IAssignmentStatement)parent).getIdentifier() != pe) return locations;
                return this.addSearchLocation(this.findNameToken(findPi.getDisplayName(), pe), locations);
            }
            if (!(parent instanceof IAssignmentStatement)) return this.addSearchLocation(this.findNameToken(findPi.getDisplayName(), pe), locations);
            if (((IAssignmentStatement)parent).getIdentifier() == pe) return locations;
            return this.addSearchLocation(this.findNameToken(findPi.getDisplayName(), pe), locations);
        }
        ISymbol symbol = ((IIdentifierExpression)pe).getSymbol();
        if (!(symbol instanceof IDynamicSymbol)) return locations;
        boolean bSetter = findMi.getParameters().length > 0;
        IGosuClass gsClass = (IGosuClass)findMi.getOwnersType();
        IPropertyInfo findPi = gsClass.getTypeInfo().getProperty((IType)gsClass, (CharSequence)propertyName);
        IType type = symbol.getScriptPart().getContainingType();
        if (type != findPi.getOwnersType()) return locations;
        if (!symbol.getName().equals(findPi.getName())) return locations;
        IParsedElement parent = pe.getParent();
        if (bSetter) {
            if (!(parent instanceof IAssignmentStatement)) return locations;
            if (((IAssignmentStatement)parent).getIdentifier() != pe) return locations;
            return this.addSearchLocation(this.findNameToken(findPi.getDisplayName(), pe), locations);
        }
        if (!(parent instanceof IAssignmentStatement)) return this.addSearchLocation(this.findNameToken(findPi.getDisplayName(), pe), locations);
        if (((IAssignmentStatement)parent).getIdentifier() == pe) return locations;
        return this.addSearchLocation(this.findNameToken(findPi.getDisplayName(), pe), locations);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<SearchLocation> findUsage(IParsedElement pe, IPropertyInfo findPi, List<SearchLocation> locations) {
        if (pe instanceof IMemberAccessExpression) {
            if (((IMemberAccessExpression)pe).getType() instanceof INamespaceType) {
                return locations;
            }
            if (!findPi.getName().equals(((IMemberAccessExpression)pe).getMemberName())) {
                return locations;
            }
            try {
                IPropertyInfo pi = ((IMemberAccessExpression)pe).getPropertyInfo();
                if (pi == null) return locations;
                if (!this.propertyInfosEqual(pi, findPi)) return locations;
                return this.addSearchLocation(this.findNameToken(findPi.getDisplayName(), pe), locations);
            }
            catch (Exception e) {
                return locations;
            }
        }
        if (!(pe instanceof IIdentifierExpression)) return locations;
        if (pe instanceof IPropertyAccessIdentifier || pe instanceof IPropertyAsMethodCallIdentifier) {
            IPropertyInfo pi = (IPropertyInfo)((IDynamicPropertySymbol)((IIdentifierExpression)pe).getSymbol()).getPropertyInfo();
            if (pi == null) return locations;
            if (!this.propertyInfosEqual(pi, findPi)) return locations;
            return this.addSearchLocation(this.findNameToken(findPi.getDisplayName(), pe), locations);
        }
        ISymbol symbol = ((IIdentifierExpression)pe).getSymbol();
        if (!(symbol instanceof IDynamicSymbol)) return locations;
        IType type = symbol.getScriptPart().getContainingType();
        if (type != findPi.getOwnersType()) return locations;
        if (!symbol.getName().equals(findPi.getName())) return locations;
        return this.addSearchLocation(this.findNameToken(findPi.getDisplayName(), pe), locations);
    }

    private boolean propertyInfosEqual(IPropertyInfo pi, IPropertyInfo findPi) {
        if (pi == findPi) {
            return true;
        }
        while (pi instanceof IPropertyInfoDelegate) {
            pi = ((IPropertyInfoDelegate)pi).getSource();
        }
        String name = pi.getName();
        return name != null && name.equals(findPi.getName()) && findPi.getOwnersType().isAssignableFrom(pi.getOwnersType());
    }

    private IToken findNameToken(String name, IParsedElement pe) {
        for (IToken token : pe.getTokens()) {
            int tt = token.getType();
            if (tt != -5 && tt != -7 || !token.getStringValue().contains(name)) continue;
            return token;
        }
        throw new IllegalStateException();
    }

    private List<SearchLocation> findUsage(IParsedElement pe, LocalVarFeatureInfo findLocal, List<SearchLocation> locations) {
        LocalVarFeatureInfo local;
        if (pe instanceof IIdentifierExpression && (local = new LocalVarFeatureInfo((IIdentifierExpression)pe)).equals(findLocal)) {
            locations = this.addSearchLocation(pe, locations);
        }
        return locations;
    }

    private List<SearchLocation> findUsage(IParsedElement pe, IType type, List<SearchLocation> locations) {
        if (pe instanceof ITypeLiteralExpression) {
            IType t = ((ITypeLiteralExpression)pe).getType().getType();
            while (t.isArray()) {
                t = t.getComponentType();
            }
            if (t == type) {
                locations = this.addSearchLocation(pe, locations);
            }
        } else if (pe instanceof INewExpression) {
            ITypeLiteralExpression typeLiteral = ((INewExpression)pe).getTypeLiteral();
            if (typeLiteral == null) {
                IConstructorInfo ctor = ((INewExpression)pe).getConstructor();
                if (ctor != null && ctor.getType() == type) {
                    locations = this.addSearchLocation(pe, locations);
                } else if (((INewExpression)pe).getType() == type) {
                    locations = this.addSearchLocation(pe, locations);
                }
            }
        } else if (pe instanceof IVarStatement) {
            IType varType;
            IVarStatement varStmt = (IVarStatement)pe;
            if (varStmt.getTypeLiteral() == null && (varType = varStmt.getType()) != null && this.referencesType(varType, type)) {
                locations = this.addZeroLengthSearchLocation(pe, locations);
            }
        } else if (this.includeMemberUsage()) {
            IFeatureInfo pi;
            if (pe instanceof IMethodCallExpression) {
                IType declaringType;
                IFunctionType functionType = ((IMethodCallExpression)pe).getFunctionType();
                if (functionType != null && (declaringType = functionType.getEnclosingType()) != null && this.encloses(type, declaringType)) {
                    locations = this.addSearchLocation(pe, locations);
                }
            } else if (pe instanceof IBeanMethodCallExpression) {
                IFunctionType functionType = ((IBeanMethodCallExpression)pe).getFunctionType();
                if (functionType != null) {
                    IType declaringType = functionType.getEnclosingType();
                    IExpression rootExpression = ((IBeanMethodCallExpression)pe).getRootExpression();
                    if (rootExpression != null && rootExpression instanceof ITypeLiteralExpression) {
                        IType typeLiteral = ((ITypeLiteralExpression)rootExpression).getType().getType();
                        if (typeLiteral != type && this.encloses(type, declaringType)) {
                            locations = this.addSearchLocation(pe, locations);
                        }
                    } else if (declaringType != null && this.encloses(type, declaringType)) {
                        locations = this.addSearchLocation(pe, locations);
                    }
                }
            } else if (pe instanceof IMemberAccessExpression) {
                IPropertyInfo pi2;
                if (((IMemberAccessExpression)pe).getType() instanceof INamespaceType) {
                    return locations;
                }
                try {
                    pi2 = ((IMemberAccessExpression)pe).getPropertyInfo();
                }
                catch (Exception e) {
                    return locations;
                }
                if (pi2 != null) {
                    locations = this.getSearchLocations(pe, type, locations, (IFeatureInfo)pi2);
                }
            } else if (pe instanceof IIdentifierExpression && (pe instanceof IPropertyAccessIdentifier || pe instanceof IPropertyAsMethodCallIdentifier) && (pi = ((IDynamicPropertySymbol)((IIdentifierExpression)pe).getSymbol()).getPropertyInfo()) != null) {
                locations = this.getSearchLocations(pe, type, locations, pi);
            }
        }
        return locations;
    }

    private List<SearchLocation> getSearchLocations(IParsedElement pe, IType type, List<SearchLocation> locations, IFeatureInfo pi) {
        IType declaringType = pi.getOwnersType();
        IExpression rootExpression = ((IMemberAccessExpression)pe).getRootExpression();
        if (rootExpression != null && rootExpression instanceof ITypeLiteralExpression) {
            IType typeLiteral = ((ITypeLiteralExpression)rootExpression).getType().getType();
            if (typeLiteral != type && this.encloses(type, declaringType)) {
                locations = this.addSearchLocation(pe, locations);
            }
        } else if (declaringType != null && this.encloses(type, declaringType)) {
            locations = this.addSearchLocation(pe, locations);
        }
        return locations;
    }

    private boolean referencesType(IType ref, IType type) {
        if (ref == type) {
            return true;
        }
        if (ref.isArray()) {
            return this.referencesType(ref.getComponentType(), type);
        }
        if (ref.isParameterizedType()) {
            for (IType param : ref.getTypeParameters()) {
                if (!this.referencesType(param, type)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean encloses(IType type, IType inner) {
        return inner != null && (inner == type || this.encloses(type, inner.getEnclosingType()));
    }

    private List<SearchLocation> addZeroLengthSearchLocation(IParsedElement elem, List<SearchLocation> locations) {
        IParseTree parseTree = elem.getLocation();
        SearchLocation loc = this.makeZeroLengthSearchLocation(parseTree);
        if (locations.isEmpty()) {
            locations = new ArrayList<SearchLocation>();
        }
        locations.add(loc);
        return locations;
    }

    private List<SearchLocation> addSearchLocation(IParsedElement elem, List<SearchLocation> locations) {
        IParseTree parseTree = elem.getLocation();
        SearchLocation loc = UsageSearcher.makeSearchLocation(parseTree);
        if (locations.isEmpty()) {
            locations = new ArrayList<SearchLocation>();
        }
        locations.add(loc);
        return locations;
    }

    private List<SearchLocation> addSearchLocation(IToken token, List<SearchLocation> locations) {
        SearchLocation loc = this.makeSearchLocation(token);
        if (locations.isEmpty()) {
            locations = new ArrayList<SearchLocation>();
        }
        locations.add(loc);
        return locations;
    }

    private SearchLocation makeZeroLengthSearchLocation(IParseTree parseTree) {
        SearchLocation loc = UsageSearcher.makeSearchLocation(parseTree);
        loc._iLength = 0;
        return loc;
    }

    public static SearchLocation makeSearchLocation(IParseTree parseTree) {
        SearchLocation loc = new SearchLocation();
        loc._iOffset = parseTree.getOffset();
        loc._iLength = parseTree.getLength();
        loc._iLineOffset = 0;
        loc._iLine = parseTree.getLineNum();
        loc._iColumn = parseTree.getColumn();
        return loc;
    }

    private SearchLocation makeSearchLocation(IToken token) {
        SearchLocation loc = new SearchLocation();
        loc._iOffset = token.getTokenStart();
        loc._iLength = token.getTokenEnd() - token.getTokenStart();
        loc._iLineOffset = 0;
        loc._iLine = token.getLine();
        loc._iColumn = token.getTokenColumn();
        return loc;
    }

    private SearchLocation makeSearchLocation(SearchElement target) {
        SearchLocation loc = new SearchLocation();
        loc._iOffset = target.getOffset();
        loc._iLength = target.getLength();
        loc._iLineOffset = 0;
        loc._iLine = target.getLine();
        loc._iColumn = target.getColumn();
        return loc;
    }

    private boolean maybeSearchForText(FileTree tree, SearchTree results) {
        if (!(this._target instanceof ITypeInfo)) {
            return false;
        }
        IType type = this._target.getSelectedFeatureInfo().getOwnersType();
        if (type instanceof IErrorType) {
            return false;
        }
        return new TextSearcher(type.getName(), true, true, false).search(tree, results);
    }

    public void search(FileTree tree) {
        GosuPanel gosuPanel = LabFrame.instance().getGosuPanel();
        gosuPanel.showSearches(false);
        SearchPanel searchPanel = gosuPanel.showSearches(true);
        this._results = new SearchTree("<html><b>$count</b>&nbsp;usages&nbsp;of&nbsp;<b>'" + this._target.getRootFeatureInfo().getName() + "'</b>&nbsp;in&nbsp;" + tree.getName(), NodeKind.Directory, SearchTree.empty());
        searchPanel.add(this._results);
        this.doSearch(tree);
        EventQueue.invokeLater(() -> this.selectFirstMatch(this._results));
    }

    public void headlessSearch(FileTree tree) {
        this._results = new SearchTree(this._target.getRootFeatureInfo().getName() + " : " + tree.getName(), NodeKind.Directory, SearchTree.empty());
        this.doSearch(tree);
    }

    private void doSearch(FileTree tree) {
        boolean[] bFinished = new boolean[]{false};
        ProgressFeedback.runWithProgress("Searching...", progress -> {
            progress.setLength(tree.getTotalFiles());
            this.searchTree(tree, this._results, ft -> ft.getType() instanceof IGosuClass, progress);
            bFinished[0] = true;
        });
        new ModalEventQueue(() -> !bFinished[0]).run();
    }

    public List<SearchLocation> searchLocal() {
        GosuPanel gosuPanel = LabFrame.instance().getGosuPanel();
        FileTree tree = FileTreeUtil.find(gosuPanel.getCurrentFile(), gosuPanel.getCurrentEditor().getParsedClass().getName());
        IType type = tree.getType();
        SearchTree results = new SearchTree("root", NodeKind.Directory, SearchTree.empty());
        this.searchTree(tree, results, ft -> ft.getType() instanceof IGosuClass, null);
        List<SearchLocation> locations = this.findLocations(results, new ArrayList<SearchLocation>());
        SearchElement target = this._target.getTargetElement();
        if (target != null && this.getOuterMostEnclosingType(target.getEnclosingType()) == this.getOuterMostEnclosingType(type)) {
            locations.add(this.makeSearchLocation(target));
        }
        return locations;
    }

    private IType getOuterMostEnclosingType(IType innerClass) {
        IType outerMost;
        for (outerMost = innerClass; outerMost != null && outerMost.getEnclosingType() != null; outerMost = outerMost.getEnclosingType()) {
        }
        return outerMost;
    }

    private List<SearchLocation> findLocations(SearchTree tree, List<SearchLocation> locations) {
        if (tree == null) {
            return locations;
        }
        SearchTree.SearchTreeNode node = (SearchTree.SearchTreeNode)tree.getNode();
        if (node != null && node.getLocation() != null) {
            locations.add(node.getLocation());
        } else {
            for (int i = 0; i < tree.getChildCount(); ++i) {
                this.findLocations((SearchTree)tree.getChildAt(i), locations);
            }
        }
        return locations;
    }

    private void selectFirstMatch(SearchTree results) {
        if (results.getChildCount() == 0) {
            results.select();
        } else {
            this.selectFirstMatch((SearchTree)results.getChildAt(0));
        }
    }
}

