/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.FileWatcher;
import editor.GosuPanel;
import editor.LabFrame;
import editor.run.FqnRunConfig;
import editor.run.IRunConfig;
import editor.run.ProgramRunConfigFactory;
import editor.run.ProgramRunConfigParameters;
import editor.settings.CompilerSettings;
import editor.settings.ISettings;
import editor.settings.Settings;
import editor.tabpane.ITab;
import editor.tabpane.TabPane;
import editor.util.EditorUtilities;
import gw.lang.Gosu;
import gw.lang.reflect.Expando;
import gw.lang.reflect.IType;
import gw.lang.reflect.ReflectUtil;
import gw.lang.reflect.json.IJsonIO;
import gw.lang.reflect.module.IProject;
import gw.util.PathUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.script.Bindings;

public class Experiment
implements IProject {
    private String _name;
    private List<String> _sourcePath;
    private List<String> _backingSourcePath;
    private Path _experimentDir;
    private List<String> _openFiles;
    private String _activeFile;
    private IRunConfig _mruRunConfig;
    private List<IRunConfig> _runConfigs;
    private ISettings _mruSettings;
    private Map<String, ISettings> _settings;
    private GosuPanel _gosuPanel;

    public Experiment(String name, Path dir, GosuPanel gosuPanel) {
        this._name = name;
        this._gosuPanel = gosuPanel;
        this._sourcePath = Collections.singletonList(PathUtil.getAbsolutePathName((Path)PathUtil.create((Path)dir, (String)Experiment.getRelativeGosuSourcePath())));
        this._backingSourcePath = Gosu.findJreSources();
        this._experimentDir = dir;
        PathUtil.mkdirs((Path)this._experimentDir);
        this._openFiles = Collections.emptyList();
        this._runConfigs = Collections.emptyList();
        this._settings = Settings.makeDefaultSettings(this);
        this.addSettingsListeners();
    }

    public Experiment(Path dir, GosuPanel gosuPanel) {
        this._name = PathUtil.getName((Path)dir);
        this._gosuPanel = gosuPanel;
        this._sourcePath = Collections.emptyList();
        this._backingSourcePath = Gosu.findJreSources();
        this._experimentDir = dir;
        this._openFiles = Collections.emptyList();
        this._runConfigs = Collections.emptyList();
        this._settings = Settings.makeDefaultSettings(this);
        this.load();
        FileWatcher.instance(this);
    }

    public String getName() {
        return this._name;
    }

    public Object getNativeProject() {
        return this;
    }

    public boolean isDisposed() {
        return false;
    }

    public boolean isHeadless() {
        return false;
    }

    public boolean isShadowMode() {
        return false;
    }

    public void setName(String name) {
        this._name = name;
    }

    public List<String> getSourcePath() {
        return this._sourcePath;
    }

    public void setSourcePath(List<String> classpath) {
        this._sourcePath = classpath;
    }

    public List<String> getBackingSourcePath() {
        return this._backingSourcePath;
    }

    public void setBackingSourcePath(List<String> backingSource) {
        this._backingSourcePath = backingSource;
    }

    public Path getExperimentDir() {
        return this._experimentDir;
    }

    public void setExperimentDir(Path experimentDir) {
        this._experimentDir = experimentDir;
    }

    public List<String> getOpenFiles() {
        return this._openFiles;
    }

    public String getActiveFile() {
        return this._activeFile;
    }

    public GosuPanel getGosuPanel() {
        return this._gosuPanel;
    }

    private Path getExperimentFile() {
        Path experimentDir = this.getExperimentDir();
        PathUtil.mkdirs((Path)experimentDir);
        Path experiment = LabFrame.findExperimentFile(experimentDir);
        if (experiment == null) {
            experiment = PathUtil.create((String)(PathUtil.getAbsolutePathName((Path)experimentDir) + File.separator + PathUtil.getName((Path)experimentDir) + ".prj"), (String[])new String[0]);
        }
        return experiment;
    }

    public Path getOrMakeExperimentFile() {
        Path experiment = this.getExperimentFile();
        if (!PathUtil.exists((Path)experiment, (LinkOption[])new LinkOption[0])) {
            this.save();
        }
        return experiment;
    }

    public void save() {
        ITab selectedTab;
        TabPane tabPane = this.getGosuPanel().getEditorTabPane();
        Path userFile = this.getExperimentFile();
        Expando bindings = new Expando();
        bindings.put("Title", (Object)"Gosu Experiment");
        bindings.put("Version", (Object)2);
        bindings.put("Name", (Object)this.getName());
        if (tabPane != null && (selectedTab = tabPane.getSelectedTab()) != null) {
            bindings.put("ActiveTab", (Object)this.makeExperimentRelativePathWithSlashes((Path)tabPane.getSelectedTab().getContentPane().getClientProperty("_file")));
            bindings.put("Tabs", Arrays.stream(tabPane.getTabs()).map(e -> {
                Path file = (Path)e.getContentPane().getClientProperty("_file");
                return this.makeExperimentRelativePathWithSlashes(file);
            }).collect(Collectors.toList()));
        }
        bindings.put("SourcePath", this.getSourcePath().stream().map(path -> {
            String relativePath = this.makeExperimentRelativePathWithSlashes(PathUtil.create((String)path, (String[])new String[0]));
            path = relativePath == null ? path : relativePath;
            PathUtil.mkdirs((Path)PathUtil.create((String)path, (String[])new String[0]));
            return path;
        }).collect(Collectors.toList()));
        bindings.put("BackingSource", this.getBackingSourcePath().stream().map(path -> {
            String relativePath = this.makeExperimentRelativePathWithSlashes(PathUtil.create((String)path, (String[])new String[0]));
            path = relativePath == null ? path : relativePath;
            PathUtil.mkdirs((Path)PathUtil.create((String)path, (String[])new String[0]));
            return path;
        }).collect(Collectors.toList()));
        IJsonIO.writeList((String)"RunConfigs", this._runConfigs, (Bindings)bindings);
        bindings.put("MruRunConfig", this.getMruRunConfig() == null ? null : this.getMruRunConfig().getName());
        IJsonIO.writeList((String)"Settings", new ArrayList<ISettings>(this._settings.values()), (Bindings)bindings);
        bindings.put("MruSettings", this.getMruSettings() == null ? null : this.getMruSettings().getName());
        try (BufferedWriter fw = PathUtil.createWriter((Path)userFile);){
            String json = (String)ReflectUtil.invokeMethod((Object)bindings, (String)"toJson", (Object[])new Object[0]);
            fw.write(json);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public String makeExperimentRelativePath(Path file) {
        String absExperimentDir = PathUtil.getAbsolutePathName((Path)this.getExperimentDir());
        String absFile = PathUtil.getAbsolutePathName((Path)file);
        if (!absFile.startsWith(absExperimentDir + File.separator)) {
            return absFile;
        }
        return absFile.substring(absExperimentDir.length() + 1);
    }

    public String makeExperimentRelativePathWithSlashes(Path file) {
        return this.makeExperimentRelativePath(file).replace('\\', '/');
    }

    private void load() {
        try {
            System.setProperty("user.dir", PathUtil.getAbsolutePathName((Path)this.getExperimentDir()));
            Bindings bindings = (Bindings)ReflectUtil.getProperty((Object)this.getOrMakeExperimentFile().toUri().toURL(), (String)"JsonContent");
            this.setName(bindings.getOrDefault("Name", PathUtil.getName((Path)this.getExperimentDir())));
            List sourcePath = bindings.getOrDefault("SourcePath", Collections.emptyList());
            if (sourcePath.isEmpty()) {
                Path srcPath = PathUtil.create((Path)this.getExperimentDir(), (String)Experiment.getRelativeGosuSourcePath());
                sourcePath.add(PathUtil.getAbsolutePathName((Path)srcPath));
                this._sourcePath = sourcePath;
            } else {
                this._sourcePath = sourcePath.stream().map(e -> PathUtil.getAbsolutePathName((Path)PathUtil.create((String)e, (String[])new String[0]))).collect(Collectors.toList());
            }
            List backingSource = bindings.getOrDefault("BackingSource", Collections.emptyList());
            this._backingSourcePath = backingSource.isEmpty() ? Gosu.findJreSources() : backingSource.stream().map(e -> PathUtil.getAbsolutePathName((Path)PathUtil.create((String)e, (String[])new String[0]))).collect(Collectors.toList());
            List tabs = bindings.getOrDefault("Tabs", Collections.emptyList());
            ArrayList<String> openFiles = new ArrayList<String>();
            for (String strTab : tabs) {
                Path file = PathUtil.getAbsolutePath((Path)PathUtil.create((String)strTab, (String[])new String[0]));
                if (!PathUtil.isFile((Path)file, (LinkOption[])new LinkOption[0])) continue;
                openFiles.add(PathUtil.getAbsolutePathName((Path)file));
            }
            this._openFiles = openFiles;
            this._activeFile = (String)bindings.get("ActiveTab");
            if (this._activeFile != null && !this._activeFile.isEmpty()) {
                this._activeFile = PathUtil.getAbsolutePathName((Path)PathUtil.create((String)this._activeFile, (String[])new String[0]));
            }
            this._runConfigs = IJsonIO.readList((String)"RunConfigs", (Bindings)bindings);
            this._mruRunConfig = this.findRunConfig(rc -> rc.getName().equals(bindings.get("MruRunConfig")));
            this._settings = new TreeMap<String, ISettings>();
            List settingList = IJsonIO.readList((String)"Settings", (Bindings)bindings);
            settingList.forEach(setting -> this._settings.put(setting.getPath(), (ISettings)setting));
            this._settings = Settings.mergeSettings(this._settings, this);
            this.addSettingsListeners();
            this._mruSettings = this.findSettings(settings -> settings.getName().equals(bindings.get("MruSettings")));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void addSettingsListeners() {
        CompilerSettings compilerSettings = (CompilerSettings)this._settings.get("Compiler");
        compilerSettings.addChangeListener((oldParams, newParams) -> {
            Path path;
            String outputPath;
            if ((newParams.isSourceBased() && !oldParams.isSourceBased() || !oldParams.getOutputPath().equals(newParams.getOutputPath())) && (outputPath = oldParams.getOutputPath()) != null && !outputPath.isEmpty() && Files.isDirectory(path = PathUtil.create((String)outputPath, (String[])new String[0]), new LinkOption[0])) {
                PathUtil.delete((Path)path, (boolean)true);
            }
        });
    }

    public static String getRelativeGosuSourcePath() {
        return "src" + File.separator + "main" + File.separator + "gosu";
    }

    public IRunConfig getOrCreateRunConfig(IType type) {
        String fqn = type.getName();
        IRunConfig<ProgramRunConfigParameters> rc = this.findRunConfig(runConfig -> runConfig instanceof FqnRunConfig && ((FqnRunConfig)runConfig).getFqn().equals(fqn));
        return rc == null ? (EditorUtilities.isRunnable(type) ? ProgramRunConfigFactory.instance().newRunConfig(this.makeProgramParams(type.getRelativeName(), type.getName())) : null) : rc;
    }

    private ProgramRunConfigParameters makeProgramParams(String name, String fqn) {
        ProgramRunConfigParameters params = ProgramRunConfigFactory.instance().makeParameters();
        params.setName(name);
        params.setFqn(fqn);
        return params;
    }

    public IRunConfig findRunConfig(Predicate<IRunConfig> matcher) {
        if (matcher == null) {
            return null;
        }
        for (IRunConfig runConfig : this._runConfigs) {
            if (!matcher.test(runConfig)) continue;
            return runConfig;
        }
        return null;
    }

    public IRunConfig getMruRunConfig() {
        return this._mruRunConfig;
    }

    public void setMruRunConfig(IRunConfig runConfig) {
        this._mruRunConfig = runConfig;
    }

    public List<IRunConfig> getRunConfigs() {
        return this._runConfigs;
    }

    public void addRunConfig(IRunConfig runConfig) {
        int index;
        if (this._runConfigs.isEmpty()) {
            this._runConfigs = new ArrayList<IRunConfig>();
        }
        if ((index = this._runConfigs.indexOf(runConfig)) >= 0) {
            runConfig = this._runConfigs.get(index);
            this._runConfigs.remove(index);
        }
        this._runConfigs.add(0, runConfig);
        this.setMruRunConfig(runConfig);
        this.save();
    }

    public boolean removeRunConfig(IRunConfig runConfig) {
        if (this._runConfigs.isEmpty()) {
            return false;
        }
        return this._runConfigs.remove(runConfig);
    }

    public Map<String, ISettings> getSettings() {
        return this._settings;
    }

    public ISettings getMruSettings() {
        return this._mruSettings;
    }

    public void setMruSettings(ISettings settings) {
        this._mruSettings = settings;
    }

    public ISettings findSettings(Predicate<ISettings> matcher) {
        if (matcher == null) {
            return null;
        }
        for (ISettings settings : this._settings.values()) {
            if (!matcher.test(settings)) continue;
            return settings;
        }
        return null;
    }
}

