/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.CommonMenus;
import editor.EditorHost;
import editor.EditorHostTextPane;
import editor.EditorScrollPane;
import editor.GosuPanel;
import editor.ILineInfoManager;
import editor.LabFrame;
import editor.Scheme;
import editor.debugger.Breakpoint;
import editor.debugger.BreakpointManager;
import editor.debugger.BreakpointsDialog;
import editor.util.EditorUtilities;
import editor.util.SmartMenuItem;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;

public abstract class AbstractLineInfoManager
implements ILineInfoManager {
    private static int g_iRequiredWidth;
    private ImageIcon _iconBreakpoint = EditorUtilities.loadIcon("images/debug_linebreakpoint.png");
    private ImageIcon _iconBreakpointDisabled = EditorUtilities.loadIcon("images/disabled_breakpoint.png");
    private EditorHost _editor;

    public AbstractLineInfoManager() {
        g_iRequiredWidth = this._iconBreakpoint.getIconWidth();
    }

    @Override
    public void setEditor(EditorHost gosuEditor) {
        this._editor = gosuEditor;
    }

    @Override
    public EditorHost getEditor() {
        return this._editor;
    }

    @Override
    public int getRequiredWidth() {
        return g_iRequiredWidth;
    }

    @Override
    public void render(Graphics g, int iLine, int iLineHeight, int iX, int iY) {
        Breakpoint bp = this.getBreakpointAtLine(iLine);
        if (bp == null) {
            return;
        }
        ImageIcon icon = !this.getBreakpointManager().isMuted() && bp.isActive() ? this._iconBreakpoint : this._iconBreakpointDisabled;
        g.drawImage(icon.getImage(), iX, iY + iLineHeight / 2 - icon.getIconHeight() / 2, icon.getIconWidth(), icon.getIconHeight(), null);
    }

    protected BreakpointManager getBreakpointManager() {
        return this.getGosuPanel().getBreakpointManager();
    }

    protected GosuPanel getGosuPanel() {
        return LabFrame.instance().getGosuPanel();
    }

    @Override
    public void renderHighlight(Graphics g, int iLine) {
        Color color = null;
        if (this.isExecPointAtLine(iLine)) {
            color = Scheme.active().getExecBreakpoint();
        } else if (this.isBreakpointAtLine(iLine)) {
            color = Scheme.active().getBreakpointColor();
        } else if (this.isFramePointAtLine(iLine)) {
            color = Scheme.active().getFrameBreakpoint();
        }
        if (color == null) {
            return;
        }
        EditorHostTextPane editor = this.getEditor().getEditor();
        FontMetrics fm = g.getFontMetrics(editor.getFont());
        int iLineHeight = fm.getHeight();
        Element root = editor.getDocument().getRootElements()[0];
        Element elemLine = root.getElement(iLine - 1);
        try {
            g.setColor(color);
            Rectangle rcLineBounds = editor.modelToView(elemLine.getStartOffset());
            rcLineBounds.x = 0;
            rcLineBounds.width = editor.getWidth();
            rcLineBounds.height = iLineHeight;
            g.fillRect(rcLineBounds.x, rcLineBounds.y, rcLineBounds.width, rcLineBounds.height);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Cursor getCursor(int iLine) {
        return null;
    }

    public void showContextMenu(MouseEvent e, final int iLine) {
        final Breakpoint bp = this.getBreakpointAtLine(iLine);
        if (bp == null) {
            return;
        }
        if (BreakpointsDialog.getShowing() != null) {
            return;
        }
        JPopupMenu contextMenu = new JPopupMenu();
        SmartMenuItem disableItem = new SmartMenuItem(new AbstractAction(bp.isActive() ? "Disable" : "Enable"){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHost editor;
                bp.setActive(!bp.isActive());
                BreakpointManager bmp = LabFrame.instance().getGosuPanel().getBreakpointManager();
                Breakpoint csr = bmp.getBreakpoint(bp);
                if (csr != null) {
                    csr.setActive(bp.isActive());
                }
                if ((editor = AbstractLineInfoManager.this.getEditor()) != null) {
                    List<EditorScrollPane.AdviceColumn> columns = EditorUtilities.findDecendents(editor, EditorScrollPane.AdviceColumn.class);
                    for (JComponent jComponent : columns) {
                        jComponent.repaint();
                    }
                }
            }
        });
        contextMenu.add(disableItem);
        SmartMenuItem removeItem = new SmartMenuItem(new AbstractAction("Remove"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointManager bmp = AbstractLineInfoManager.this.getGosuPanel().getBreakpointManager();
                bmp.toggleLineBreakpoint(AbstractLineInfoManager.this.getEditor(), AbstractLineInfoManager.this.getEditor().getScriptPart().getContainingTypeName(), AbstractLineInfoManager.this.getEditor().getTypeAtLine(iLine), iLine);
                AbstractLineInfoManager.this.getEditor().repaint();
            }
        });
        contextMenu.add(removeItem);
        contextMenu.addSeparator();
        contextMenu.add(CommonMenus.makeViewBreakpoints(() -> bp));
        contextMenu.add(CommonMenus.makeMuteBreakpoints(this::getBreakpointManager));
        contextMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    protected abstract boolean isBreakpointAtLine(int var1);

    protected abstract Breakpoint getBreakpointAtLine(int var1);

    protected abstract boolean isExecPointAtLine(int var1);

    protected abstract Breakpoint getExecPointAtLine(int var1);

    protected abstract boolean isFramePointAtLine(int var1);

    protected abstract Breakpoint getFramePointAtLine(int var1);
}

