/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.ExperimentView;
import editor.FileWatcher;
import editor.IFileWatcherListener;
import editor.LabFrame;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import editor.util.SourceFileCreator;
import gw.config.CommonServices;
import gw.fs.IResource;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.module.IModule;
import gw.util.PathUtil;
import java.awt.EventQueue;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FileTree
implements MutableTreeNode,
IFileWatcherListener {
    private String _name;
    private Path _fileOrDir;
    private FileTree _parent;
    private List<FileTree> _children;
    private Experiment _experiment;
    private Icon _icon;
    private long _lastModified;

    public FileTree(Experiment experiment) {
        this._fileOrDir = experiment.getExperimentDir();
        this._experiment = experiment;
        this._name = experiment.getName();
        this.addSourcePaths(experiment);
    }

    protected FileTree(Path fileOrDir, FileTree parent, Experiment experiment) {
        this._fileOrDir = fileOrDir;
        this._parent = parent;
        this._experiment = experiment;
        this._name = PathUtil.getName((Path)this._fileOrDir);
        if (PathUtil.isDirectory((Path)this._fileOrDir, (LinkOption[])new LinkOption[0])) {
            this.makeSourcePathChildren();
            FileWatcher.instance(this._experiment).register(this);
        } else {
            this._children = Collections.emptyList();
        }
    }

    public String getName() {
        return this._name;
    }

    private void setName(String name) {
        this._name = name;
    }

    private void addSourcePaths(Experiment experiment) {
        List<String> sourcePath = experiment.getSourcePath();
        this._children = new ArrayList<FileTree>();
        for (String path : sourcePath) {
            String experimentDir;
            Path srcPath = PathUtil.create((String)path, (String[])new String[0]);
            PathUtil.mkdirs((Path)srcPath);
            String srcPathAbsolute = PathUtil.getAbsolutePathName((Path)srcPath);
            if (!srcPathAbsolute.startsWith((experimentDir = PathUtil.getAbsolutePathName((Path)experiment.getExperimentDir())) + File.separator)) continue;
            String srcPathName = srcPathAbsolute.substring(experimentDir.length());
            FileTree tree = new FileTree(srcPath, this, experiment);
            tree.setName(srcPathName);
            this._children.add(tree);
        }
    }

    private void makeSourcePathChildren() {
        this.makeSourcePathChildren(this._fileOrDir);
    }

    private void makeSourcePathChildren(Path fileOrDir) {
        ArrayList<FileTree> children = new ArrayList<FileTree>();
        Path[] files = PathUtil.listFiles((Path)fileOrDir);
        if (files != null) {
            for (Path path : files) {
                FileTree insert = new FileTree(path, this, this._experiment);
                children.add(this.getSortedIndex(children, insert), insert);
            }
        }
        this._children = children;
    }

    private int getSortedIndex(List<FileTree> children, FileTree insert) {
        int count = children.size();
        for (int i = 0; i < count; ++i) {
            FileTree tree = children.get(i);
            if ((tree.isDirectory() != insert.isDirectory() || insert.getName().toLowerCase().compareTo(tree.getName().toLowerCase()) > 0) && (!tree.isFile() || !insert.isDirectory())) continue;
            return i;
        }
        return count;
    }

    private boolean isInSourcePath(Path path) {
        String absolutePath = PathUtil.getAbsolutePathName((Path)path);
        for (String sp : this._experiment.getSourcePath()) {
            if (!absolutePath.contains(sp = PathUtil.getAbsolutePathName((String)sp))) continue;
            return true;
        }
        return false;
    }

    public FileTree find(Path file) {
        if (this.getFileOrDir().equals(file)) {
            return this;
        }
        for (FileTree tree : this.getChildren()) {
            FileTree found = tree.find(file);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public FileTree find(String fqn) {
        String dotPath;
        if (fqn == null) {
            return null;
        }
        String thisFqn = this.makeFqn();
        if (thisFqn != null) {
            if (fqn.equals(thisFqn) || fqn.startsWith(thisFqn) && fqn.startsWith(thisFqn + ".")) {
                return this;
            }
        } else if (this.isDirectory() && (dotPath = this.makeDotPath()) != null && !fqn.startsWith(dotPath)) {
            return null;
        }
        for (FileTree tree : this.getChildren()) {
            FileTree found = tree.find(fqn);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public void getAllTypeNames(Set<String> typeNames) {
        String fqn = this.makeFqn();
        if (fqn != null) {
            typeNames.add(fqn);
        }
        for (FileTree tree : this.getChildren()) {
            tree.getAllTypeNames(typeNames);
        }
    }

    public Path getFileOrDir() {
        return this._fileOrDir;
    }

    public boolean isDirectory() {
        return PathUtil.isDirectory((Path)this._fileOrDir, (LinkOption[])new LinkOption[0]);
    }

    public boolean isFile() {
        return PathUtil.isFile((Path)this._fileOrDir, (LinkOption[])new LinkOption[0]);
    }

    public List<FileTree> getChildren() {
        return this._children;
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        this.getChildren().add(index, (FileTree)child);
        child.setParent(this);
    }

    @Override
    public void remove(int index) {
        this.remove(this.getChildren().get(index));
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.getChildren().remove(node);
        if (((FileTree)node).isDirectory()) {
            FileWatcher.instance(this._experiment).unregister((FileTree)node);
        }
    }

    @Override
    public void setUserObject(Object object) {
    }

    @Override
    public void removeFromParent() {
        this._parent.remove(this);
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this._parent = (FileTree)newParent;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.getChildren().get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    public FileTree getParent() {
        return this._parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getChildren().indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.isDirectory() && this.isInSourcePath(this._fileOrDir);
    }

    @Override
    public boolean isLeaf() {
        return this.isFile();
    }

    public Enumeration children() {
        final Iterator<FileTree> iter = this.getChildren().iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            public Object nextElement() {
                return iter.next();
            }
        };
    }

    public String toString() {
        return this._name;
    }

    @Override
    public void fireCreate(String dir, String file) {
        Path newFileOrDir = PathUtil.create((String)dir, (String[])new String[]{file});
        EventQueue.invokeLater(() -> {
            FileTree fileTree = new FileTree(newFileOrDir, this, this._experiment);
            ((DefaultTreeModel)this.getExperimentView().getTree().getModel()).insertNodeInto(fileTree, this, this.getSortedIndex(this.getChildren(), fileTree));
            this.handleNewFileTree(fileTree);
        });
    }

    private void handleNewFileTree(FileTree fileTree) {
        if (fileTree.isDirectory()) {
            fileTree.getChildren().forEach(this::handleNewFileTree);
        } else {
            this.handleNewFile(fileTree);
        }
    }

    private void handleNewFile(FileTree fileTree) {
        Path createdFile;
        Path file = fileTree.getFileOrDir();
        if (this.isTypeFile(fileTree)) {
            TypeSystem.created((IResource)CommonServices.getFileSystem().getIFile(file.toFile()));
            TypeSystem.refresh((IModule)TypeSystem.getGlobalModule());
        }
        if ((createdFile = SourceFileCreator.instance().getCreated()) != null && createdFile.equals(file)) {
            this.openFile(fileTree, file);
        }
    }

    private void openFile(FileTree fileTree, Path file) {
        LabFrame.instance().openFile(file);
        SourceFileCreator.instance().clearCreated();
        EventQueue.invokeLater(() -> {
            Path currentFile = this.getExperiment().getGosuPanel().getCurrentFile();
            if (currentFile != null && currentFile.equals(file)) {
                fileTree.select();
            }
        });
    }

    private boolean isTypeFile(FileTree fileTree) {
        if (fileTree.isDirectory()) {
            return false;
        }
        for (ITypeLoader tl : TypeSystem.getAllTypeLoaders()) {
            if (!tl.handlesFile(PathUtil.getIFile((Path)fileTree.getFileOrDir()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void fireModify(String dir, String file) {
        Path existingFile = PathUtil.create((String)dir, (String[])new String[]{file});
        if (!PathUtil.exists((Path)existingFile, (LinkOption[])new LinkOption[0])) {
            return;
        }
        FileTree child = this.find(existingFile);
        if (child == null || child._lastModified - PathUtil.lastModified((Path)existingFile, (LinkOption[])new LinkOption[0]) >= 0L) {
            return;
        }
        child._lastModified = PathUtil.lastModified((Path)existingFile, (LinkOption[])new LinkOption[0]);
        EventQueue.invokeLater(() -> this.getExperiment().getGosuPanel().refresh(existingFile));
    }

    @Override
    public void fireDelete(String dir, String file) {
        Path existingFile = PathUtil.create((String)dir, (String[])new String[]{file});
        FileTree fileTree = this.find(existingFile);
        if (fileTree != null) {
            EventQueue.invokeLater(() -> ((DefaultTreeModel)this.getExperimentView().getTree().getModel()).removeNodeFromParent(fileTree));
            this.getExperiment().getGosuPanel().closeTab(existingFile);
            this.handleDeletedFileTree(fileTree);
        }
    }

    private void handleDeletedFileTree(FileTree fileTree) {
        if (fileTree.isDirectory()) {
            fileTree.getChildren().forEach(this::handleDeletedFileTree);
        } else {
            this.handlePossibleDeletedType(fileTree);
        }
    }

    private boolean handlePossibleDeletedType(FileTree fileTree) {
        if (this.isTypeFile(fileTree)) {
            TypeSystem.deleted((IResource)PathUtil.getIFile((Path)fileTree.getFileOrDir()));
            return true;
        }
        return false;
    }

    @Override
    public void setLastModified() {
        this._lastModified = System.currentTimeMillis() + 100L;
    }

    public void select() {
        JTree tree = this.getExperimentView().getTree();
        TreePath path = this.getPath();
        tree.expandPath(path);
        tree.setSelectionPath(path);
        tree.scrollPathToVisible(path);
    }

    public TreePath getPath() {
        List<FileTree> path = this.makePath(new ArrayList<FileTree>());
        return new TreePath(path.toArray(new FileTree[path.size()]));
    }

    private List<FileTree> makePath(List<FileTree> path) {
        if (this.getParent() != null) {
            this.getParent().makePath(path);
        }
        path.add(this);
        return path;
    }

    private ExperimentView getExperimentView() {
        return this._experiment.getGosuPanel().getExperimentView();
    }

    public Experiment getExperiment() {
        return this._experiment;
    }

    public boolean isSourcePathRoot() {
        return this.isDirectory() && this.getExperiment().getSourcePath().contains(PathUtil.getAbsolutePathName((Path)this.getFileOrDir()));
    }

    public FileTree getSourcePathRoot() {
        FileTree srcPathRoot;
        for (srcPathRoot = this; srcPathRoot != null && !srcPathRoot.isSourcePathRoot(); srcPathRoot = srcPathRoot.getParent()) {
        }
        return srcPathRoot;
    }

    public IType getType() {
        String fqn = this.makeFqn();
        if (fqn == null) {
            return null;
        }
        return TypeSystem.getByFullNameIfValid((String)fqn);
    }

    public String makeFqn() {
        FileTree sourcePathRoot = this.getSourcePathRoot();
        if (this.isDirectory() || this.isSourcePathRoot() || sourcePathRoot == null || PathUtil.getName((Path)this.getFileOrDir()).indexOf(46) < 0) {
            return null;
        }
        return this._makeDotPath(sourcePathRoot);
    }

    private String makeDotPath() {
        return this.makeDotPath(this.getSourcePathRoot());
    }

    private String makeDotPath(FileTree sourcePathRoot) {
        if (this.isSourcePathRoot() || sourcePathRoot == null) {
            return null;
        }
        return this._makeDotPath(sourcePathRoot);
    }

    private String _makeDotPath(FileTree sourcePathRoot) {
        String fqn = PathUtil.getAbsolutePathName((Path)this.getFileOrDir()).substring(PathUtil.getAbsolutePathName((Path)sourcePathRoot.getFileOrDir()).length() + 1);
        int iDot = fqn.lastIndexOf(46);
        if (iDot >= 0) {
            fqn = fqn.substring(0, iDot);
        }
        fqn = fqn.replace(File.separatorChar, '.');
        return fqn;
    }

    public boolean canDelete() {
        return !this.isSourcePathRoot() && this.getParent() != null;
    }

    public void delete() {
        if (this.canDelete()) {
            if (this.isFile() ? JOptionPane.showConfirmDialog(LabFrame.instance(), "Delete file \"" + this.getName() + "\"?", "Gosu Lab", 2) != 0 : JOptionPane.showConfirmDialog(LabFrame.instance(), "<html>Delete directory \"" + this.getName() + "\"?<br>All files and subdirectories in \"" + this.getName() + "\" will be deleted!", "Gosu Lab", 2) != 0) {
                return;
            }
            PathUtil.delete((Path)this.getFileOrDir(), (boolean)true);
        }
    }

    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = this.findIcon();
        }
        return this._icon;
    }

    private Icon findIcon() {
        if (this.getParent() == null) {
            return LabFrame.loadLabIcon();
        }
        if (this.isDirectory()) {
            if (this.getSourcePathRoot() != null && !this.isSourcePathRoot()) {
                return EditorUtilities.loadIcon("images/folder.png");
            }
            return EditorUtilities.loadIcon("images/srcfolder.png");
        }
        if (this.getType() != null) {
            return EditorUtilities.findIcon(this.getType());
        }
        try {
            File file = this.getFileOrDir().toFile();
            return FileSystemView.getFileSystemView().getSystemIcon(file);
        }
        catch (UnsupportedOperationException e) {
            return EditorUtilities.loadIcon("images/FileText.png");
        }
    }

    public int getTotalFiles() {
        int iCount = 0;
        if (this.isDirectory()) {
            for (FileTree csr : this.getChildren()) {
                iCount += csr.getTotalFiles();
            }
        } else {
            return 1;
        }
        return iCount;
    }

    public boolean traverse(Predicate<FileTree> visitor) {
        if (!visitor.test(this)) {
            return false;
        }
        for (FileTree ft : this.getChildren()) {
            if (ft.traverse(visitor)) continue;
            return false;
        }
        return true;
    }
}

