/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.LabButtonUI;
import editor.LabComboBoxUI;
import editor.LabTreeUi;
import editor.Scheme;
import editor.util.EditorUtilities;
import editor.util.FixupLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.metal.MetalIconFactory;

public class GosuLabLAF
extends BasicLookAndFeel {
    @Override
    public String getName() {
        return "Gosu L&F";
    }

    @Override
    public String getID() {
        return "GosuL&F";
    }

    @Override
    public String getDescription() {
        return "Gosu";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        ColorUIResource darkGray;
        super.initComponentDefaults(table);
        String metalPackageName = "javax.swing.plaf.metal.";
        UIDefaults.LazyValue dialogPlain12 = t -> new FontUIResource("Dialog", 0, 12);
        UIDefaults.LazyValue sansSerifPlain12 = t -> new FontUIResource("SansSerif", 0, 12);
        UIDefaults.LazyValue monospacedPlain12 = t -> new FontUIResource("Monospaced", 0, 12);
        UIDefaults.LazyValue dialogBold12 = t -> new FontUIResource("Dialog", 1, 12);
        ColorUIResource red = new ColorUIResource(Color.red);
        ColorUIResource black = new ColorUIResource(Color.black);
        ColorUIResource white = new ColorUIResource(Color.white);
        ColorUIResource gray = new ColorUIResource(Color.gray);
        ColorUIResource scrollBarTrackHighlight = darkGray = new ColorUIResource(Color.darkGray);
        Icon treeExpandedIcon = LabTreeUi.ExpandedIcon.createExpandedIcon();
        Icon treeCollapsedIcon = LabTreeUi.CollapsedIcon.createCollapsedIcon();
        UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "control A", "select-all", "control BACK_SLASH", "unselect", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap passwordInputMap = new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "control A", "select-all", "control BACK_SLASH", "unselect", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-begin-line", "control RIGHT", "caret-end-line", "control shift LEFT", "selection-begin-line", "control shift RIGHT", "selection-end-line", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "control A", "select-all", "control BACK_SLASH", "unselect", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "control HOME", "caret-begin", "control END", "caret-end", "control shift HOME", "selection-begin", "control shift END", "selection-end", "UP", "caret-up", "DOWN", "caret-down", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift DOWN", "selection-down", "ENTER", "insert-break", "TAB", "insert-tab", "control T", "next-link-action", "control shift T", "previous-link-action", "control SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyValue MenuFont = dialogPlain12;
        UIDefaults.LazyValue FixedControlFont = monospacedPlain12;
        UIDefaults.LazyValue ControlFont = dialogPlain12;
        UIDefaults.LazyValue MessageFont = dialogPlain12;
        UIDefaults.LazyValue WindowFont = dialogBold12;
        UIDefaults.LazyValue ToolTipFont = sansSerifPlain12;
        UIDefaults.LazyValue IconFont = ControlFont;
        Object[] defaults = new Object[]{"AuditoryCues.playList", null, "TextField.focusInputMap", fieldInputMap, "PasswordField.focusInputMap", passwordInputMap, "TextArea.focusInputMap", multilineInputMap, "TextPane.focusInputMap", multilineInputMap, "EditorPane.focusInputMap", multilineInputMap, "Button.font", ControlFont, "Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "CheckBox.font", ControlFont, "CheckBox.icon", t -> new CheckBoxIcon(), "RadioButton.icon", t -> new RadioButtonIcon(), "CheckBox.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "CheckBox.totalInsets", new Insets(4, 4, 4, 4), "CheckBoxMenuItem.font", MenuFont, "ComboBox.font", ControlFont, "ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext2", "KP_DOWN", "selectNext2", "UP", "selectPrevious2", "KP_UP", "selectPrevious2", "ENTER", "enterPressed", "F4", "togglePopup", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup"}), "DesktopIcon.width", 160, "EditorPane.font", ControlFont, "FileChooser.listFont", IconFont, "FileChooser.usesSingleFilePane", Boolean.TRUE, "FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "F2", "editFileName", "F5", "refresh", "BACK_SPACE", "Go Up"}), "FormattedTextField.font", ControlFont, "InternalFrame.titleFont", WindowFont, "InternalFrame.windowBindings", new Object[]{"shift ESCAPE", "showSystemMenu", "ctrl SPACE", "showSystemMenu", "ESCAPE", "hideSystemMenu"}, "List.lockToPositionOnScroll", Boolean.TRUE, "List.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "ctrl shift UP", "selectPreviousRowExtendSelection", "ctrl shift KP_UP", "selectPreviousRowExtendSelection", "ctrl UP", "selectPreviousRowChangeLead", "ctrl KP_UP", "selectPreviousRowChangeLead", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "ctrl shift DOWN", "selectNextRowExtendSelection", "ctrl shift KP_DOWN", "selectNextRowExtendSelection", "ctrl DOWN", "selectNextRowChangeLead", "ctrl KP_DOWN", "selectNextRowChangeLead", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl shift LEFT", "selectPreviousColumnExtendSelection", "ctrl shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl LEFT", "selectPreviousColumnChangeLead", "ctrl KP_LEFT", "selectPreviousColumnChangeLead", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl shift RIGHT", "selectNextColumnExtendSelection", "ctrl shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl RIGHT", "selectNextColumnChangeLead", "ctrl KP_RIGHT", "selectNextColumnChangeLead", "HOME", "selectFirstRow", "shift HOME", "selectFirstRowExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl HOME", "selectFirstRowChangeLead", "END", "selectLastRow", "shift END", "selectLastRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "ctrl END", "selectLastRowChangeLead", "PAGE_UP", "scrollUp", "shift PAGE_UP", "scrollUpExtendSelection", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "PAGE_DOWN", "scrollDown", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_DOWN", "scrollDownChangeLead", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo"}), "FormattedTextField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "RootPane.defaultButtonWindowKeyBindings", new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release"}, "ScrollBar.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "positiveUnitIncrement", "KP_DOWN", "positiveUnitIncrement", "PAGE_DOWN", "positiveBlockIncrement", "ctrl PAGE_DOWN", "positiveBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "negativeUnitIncrement", "KP_UP", "negativeUnitIncrement", "PAGE_UP", "negativeBlockIncrement", "ctrl PAGE_UP", "negativeBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "ScrollPane.font", ControlFont, "ScrollPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "unitScrollRight", "KP_RIGHT", "unitScrollRight", "DOWN", "unitScrollDown", "KP_DOWN", "unitScrollDown", "LEFT", "unitScrollLeft", "KP_LEFT", "unitScrollLeft", "UP", "unitScrollUp", "KP_UP", "unitScrollUp", "PAGE_UP", "scrollUp", "PAGE_DOWN", "scrollDown", "ctrl PAGE_UP", "scrollLeft", "ctrl PAGE_DOWN", "scrollRight", "ctrl HOME", "scrollHome", "ctrl END", "scrollEnd"}), "SplitPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "negativeIncrement", "DOWN", "positiveIncrement", "LEFT", "negativeIncrement", "RIGHT", "positiveIncrement", "KP_UP", "negativeIncrement", "KP_DOWN", "positiveIncrement", "KP_LEFT", "negativeIncrement", "KP_RIGHT", "positiveIncrement", "HOME", "selectMin", "END", "selectMax", "F8", "startResize", "F6", "toggleFocus", "ctrl TAB", "focusOutForward", "ctrl shift TAB", "focusOutBackward"}), "TabbedPane.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "navigateRight", "KP_RIGHT", "navigateRight", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "ctrl DOWN", "requestFocusForVisibleComponent", "ctrl KP_DOWN", "requestFocusForVisibleComponent"}), "TabbedPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl TAB", "navigateNext", "ctrl shift TAB", "navigatePrevious", "ctrl PAGE_DOWN", "navigatePageDown", "ctrl PAGE_UP", "navigatePageUp", "ctrl UP", "requestFocus", "ctrl KP_UP", "requestFocus"}), "TextArea.font", FixedControlFont, "TextField.font", ControlFont, "TextPane.font", ControlFont, "TitledBorder.font", ControlFont, "ToggleButton.font", ControlFont, "ToggleButton.textShiftOffset", 1, "ToggleButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "ToolBar.font", MenuFont, "ToolBar.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "RIGHT", "navigateRight", "KP_RIGHT", "navigateRight"}), "ToolTip.font", ToolTipFont, "ToolTipManager.enableToolTipMode", "activeApplication", "Tree.selectionBorderColor", black, "Tree.drawDashedFocusIndicator", Boolean.TRUE, "Tree.lineTypeDashed", Boolean.TRUE, "Tree.font", ControlFont, "Tree.hash", gray, "Tree.leftChildIndent", 8, "Tree.rightChildIndent", 11, "Tree.expandedIcon", treeExpandedIcon, "Tree.collapsedIcon", treeCollapsedIcon, "Tree.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ADD", "expand", "SUBTRACT", "collapse", "ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "ctrl shift UP", "selectPreviousExtendSelection", "ctrl shift KP_UP", "selectPreviousExtendSelection", "ctrl UP", "selectPreviousChangeLead", "ctrl KP_UP", "selectPreviousChangeLead", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "ctrl shift DOWN", "selectNextExtendSelection", "ctrl shift KP_DOWN", "selectNextExtendSelection", "ctrl DOWN", "selectNextChangeLead", "ctrl KP_DOWN", "selectNextChangeLead", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "LEFT", "selectParent", "KP_LEFT", "selectParent", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_DOWN", "scrollDownChangeLead", "HOME", "selectFirst", "shift HOME", "selectFirstExtendSelection", "ctrl shift HOME", "selectFirstExtendSelection", "ctrl HOME", "selectFirstChangeLead", "END", "selectLast", "shift END", "selectLastExtendSelection", "ctrl shift END", "selectLastExtendSelection", "ctrl END", "selectLastChangeLead", "F2", "startEditing", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ctrl LEFT", "scrollLeft", "ctrl KP_LEFT", "scrollLeft", "ctrl RIGHT", "scrollRight", "ctrl KP_RIGHT", "scrollRight", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo"}), "Tree.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancel"}), "Viewport.font", ControlFont, "FileView.directoryIcon", t -> MetalIconFactory.getTreeFolderIcon(), "FileView.fileIcon", t -> MetalIconFactory.getTreeLeafIcon(), "FileView.computerIcon", t -> MetalIconFactory.getTreeComputerIcon(), "FileView.hardDriveIcon", t -> MetalIconFactory.getTreeHardDriveIcon(), "FileView.floppyDriveIcon", t -> MetalIconFactory.getTreeFloppyDriveIcon(), "FileChooserUI", "javax.swing.plaf.metal.MetalFileChooserUI", "FileChooser.detailsViewIcon", t -> MetalIconFactory.getFileChooserDetailViewIcon(), "FileChooser.homeFolderIcon", t -> MetalIconFactory.getFileChooserHomeFolderIcon(), "FileChooser.listViewIcon", t -> MetalIconFactory.getFileChooserListViewIcon(), "FileChooser.newFolderIcon", t -> MetalIconFactory.getFileChooserNewFolderIcon(), "FileChooser.upFolderIcon", t -> MetalIconFactory.getFileChooserUpFolderIcon(), "FileChooser.usesSingleFilePane", Boolean.TRUE, "FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "F2", "editFileName", "F5", "refresh", "BACK_SPACE", "Go Up"})};
        table.putDefaults(defaults);
    }

    public static void setLookAndFeel() {
        try {
            System.setProperty("swing.noxp", "true");
            UIManager.setLookAndFeel(GosuLabLAF.class.getName());
            FixupLookAndFeel.fixupFieldBorders();
            FixupLookAndFeel.fixupTreeHandles();
            UIDefaults table = UIManager.getLookAndFeelDefaults();
            table.put("ComboBoxUI", LabComboBoxUI.class.getName());
            table.put("MenuItemUI", BasicMenuItemUI.class.getName());
            table.put("ButtonUI", LabButtonUI.class.getName());
            table.put("desktop", Scheme.active().getControl());
            table.put("activeCaption", Scheme.active().getActiveCaption());
            table.put("activeCaptionText", Scheme.active().getActiveCaptionText());
            table.put("activeCaptionBorder", Scheme.active().getControl());
            table.put("inactiveCaption", Scheme.active().getControlDarkshadow());
            table.put("inactiveCaptionText", Scheme.active().getControl());
            table.put("inactiveCaptionBorder", Scheme.active().getControl());
            table.put("window", Scheme.active().getWindow());
            table.put("windowBorder", Scheme.active().getWindowBorder());
            table.put("windowText", Scheme.active().getWindowText());
            table.put("text", Scheme.active().getControl());
            table.put("textText", Scheme.active().getControlText());
            table.put("textHighlight", Scheme.active().getTextHighlight());
            table.put("textHighlightText", Scheme.active().getTextHighlightText());
            table.put("textInactiveText", Scheme.active().getControlShadow());
            table.put("control", Scheme.active().getControl());
            table.put("controlText", Scheme.active().getControlText());
            table.put("controlHighlight", Scheme.active().getControl());
            table.put("controlLtHighlight", Scheme.active().getControlLight());
            table.put("controlShadow", Scheme.active().getControlDarkshadow());
            table.put("controlDkShadow", Scheme.active().getControlDarkshadow());
            table.put("info", Scheme.active().getTooltipBackground());
            table.put("infoText", Scheme.active().getTooltipText());
            table.put("ScrollBar.width", (Object)11);
            table.put("ScrollBar.squareButtons", (Object)true);
            table.put("scrollbar", Scheme.active().getControl());
            table.put("ScrollBar.background", Scheme.active().getControl());
            table.put("ScrollBar.foreground", Scheme.active().getControl());
            table.put("ScrollBar.trackHighlight", Scheme.active().getControl());
            table.put("ScrollBar.track", Scheme.active().getControl());
            table.put("ScrollBar.trackForeground", Scheme.active().getControl());
            table.put("ScrollBar.trackHighlightForeground", Scheme.active().getControl());
            table.put("ScrollBar.thumb", Scheme.active().getControl());
            table.put("ScrollBar.thumbHighlight", Scheme.active().getScrollbarBorderColor());
            table.put("ScrollBar.thumbDarkShadow", Scheme.active().getControl());
            table.put("ScrollBar.thumbShadow", Scheme.active().getScrollbarBorderColor());
            table.put("ScrollBar.border", (Object)null);
            table.put("ToolTip.background", Scheme.active().getTooltipBackground());
            table.put("ToolTip.foreground", Scheme.active().getTooltipText());
            table.put("ToolTip.border", BorderFactory.createLineBorder(Scheme.active().getFieldBorderColor()));
            table.put("Separator.foreground", Scheme.active().getSeparator1());
            table.put("Separator.background", Scheme.active().getSeparator2());
            table.put("Button.foreground", Scheme.active().getControlText());
            table.put("Button.disabledForeground", Scheme.active().getControlDisabledText());
            table.put("Button.disabledShadow", Scheme.active().getControl());
            table.put("Button.background", Scheme.active().getControl());
            table.put("Button.interiorBackground", Scheme.active().getControl());
            table.put("Button.shadow", Scheme.active().getControl());
            table.put("Button.darkShadow", Scheme.active().getControlDarkshadow());
            table.put("Button.light", Scheme.active().getControl());
            table.put("Button.highlight", Scheme.active().getControlDarkshadow());
            table.put("MenuBar.border", BorderFactory.createEmptyBorder(0, 0, 0, 0));
            table.put("MenuBar.background", Scheme.active().getMenu());
            table.put("PopupMenu.border", BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Scheme.active().getMenuBorder()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            table.put("PopupMenu.foreground", Scheme.active().getMenuText());
            table.put("PopupMenu.background", Scheme.active().getMenu());
            table.put("Popup.foreground", Scheme.active().getMenuText());
            table.put("Popup.background", Scheme.active().getMenu());
            table.put("menu", Scheme.active().getMenu());
            table.put("menuText", Scheme.active().getMenuText());
            table.put("Menu.foreground", Scheme.active().getMenuText());
            table.put("Menu.background", Scheme.active().getMenu());
            table.put("Menu.selectionForeground", Scheme.active().getWindowText());
            table.put("Menu.selectionBackground", Scheme.active().getActiveCaption());
            table.put("Menu.disabledForeground", Scheme.active().getControlDisabledText());
            table.put("Menu.acceleratorForeground", Scheme.active().getWindowText());
            table.put("Menu.acceleratorSelectionForeground", Scheme.active().getWindowText());
            table.put("Menu.border", BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Scheme.active().getMenuBorder()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            table.put("Menu.margin", Scheme.active().getWindowText());
            table.put("menuPressedItemB", Scheme.active().getTextHighlight());
            table.put("menuPressedItemF", Scheme.active().getTextHighlightText());
            table.put("MenuItem.foreground", Scheme.active().getMenuText());
            table.put("MenuItem.background", Scheme.active().getMenu());
            table.put("MenuItem.selectionForeground", Scheme.active().getWindowText());
            table.put("MenuItem.selectionBackground", Scheme.active().getActiveCaption());
            table.put("MenuItem.disabledForeground", Scheme.active().getControlDisabledText());
            table.put("MenuItem.acceleratorForeground", Scheme.active().getWindowText());
            table.put("MenuItem.acceleratorSelectionForeground", Scheme.active().getWindowText());
            table.put("MenuItem.border", BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Scheme.active().getXpBorderColor()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            table.put("MenuItem.disabledAreNavigable", (Object)false);
            table.put("RadioButtonMenuItem.foreground", Scheme.active().getMenuText());
            table.put("RadioButtonMenuItem.background", Scheme.active().getMenu());
            table.put("RadioButtonMenuItem.selectionForeground", Scheme.active().getWindowText());
            table.put("RadioButtonMenuItem.selectionBackground", Scheme.active().getActiveCaption());
            table.put("RadioButtonMenuItem.disabledForeground", Scheme.active().getControlDisabledText());
            table.put("RadioButtonMenuItem.acceleratorForeground", Scheme.active().getWindowText());
            table.put("RadioButtonMenuItem.acceleratorSelectionForeground", Scheme.active().getWindowText());
            table.put("RadioButtonMenuItem.border", BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Scheme.active().getXpBorderColor()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            table.put("RadioButtonMenuItem.disabledAreNavigable", (Object)false);
            table.put("CheckBoxMenuItem.foreground", Scheme.active().getMenuText());
            table.put("CheckBoxMenuItem.background", Scheme.active().getMenu());
            table.put("CheckBoxMenuItem.selectionForeground", Scheme.active().getWindowText());
            table.put("CheckBoxMenuItem.selectionBackground", Scheme.active().getActiveCaption());
            table.put("CheckBoxMenuItem.disabledForeground", Scheme.active().getControlDisabledText());
            table.put("CheckBoxMenuItem.acceleratorForeground", Scheme.active().getWindowText());
            table.put("CheckBoxMenuItem.acceleratorSelectionForeground", Scheme.active().getWindowText());
            table.put("CheckBoxMenuItem.border", BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Scheme.active().getXpBorderColor()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            table.put("CheckBoxMenuItem.disabledAreNavigable", (Object)false);
            table.put("List.foreground", Scheme.active().getWindowText());
            table.put("List.background", Scheme.active().getWindow());
            table.put("Tree.foreground", Scheme.active().getWindowText());
            table.put("Tree.background", Scheme.active().getWindow());
            table.put("Table.foreground", Scheme.active().getWindowText());
            table.put("Table.background", Scheme.active().getWindow());
            table.put("ComboBox.foreground", Scheme.active().getWindowText());
            table.put("ComboBox.background", Scheme.active().getWindow());
            table.put("ComboBox.disabledForeground", Scheme.active().getControlShadow());
            table.put("ComboBox.disabledBackground", Scheme.active().getControl());
            table.put("ComboBox.buttonBackground", Scheme.active().getControl());
            table.put("ComboBox.buttonShadow", Scheme.active().getControlShadow());
            table.put("ComboBox.buttonDarkShadow", Scheme.active().getControlDarkshadow());
            table.put("ComboBox.buttonHighlight", Scheme.active().getControl());
            table.put("ComboBox.selectionBackground", Scheme.active().getTextHighlight());
            table.put("TextField.foreground", Scheme.active().getWindowText());
            table.put("TextField.background", Scheme.active().getWindow());
            table.put("TextField.caretForeground", Scheme.active().getWindowText());
            table.put("TextField.selectionBackground", Scheme.active().getTextHighlight());
            table.put("TextArea.foreground", Scheme.active().getWindowText());
            table.put("TextArea.background", Scheme.active().getWindow());
            table.put("TextArea.caretForeground", Scheme.active().getWindowText());
            table.put("TextArea.selectionBackground", Scheme.active().getTextHighlight());
            table.put("TextPane.foreground", Scheme.active().getWindowText());
            table.put("TextPane.background", Scheme.active().getWindow());
            table.put("TextPane.caretForeground", Scheme.active().getWindowText());
            table.put("TextPane.selectionBackground", Scheme.active().getTextHighlight());
            table.put("Panel.foreground", Scheme.active().getControlText());
            table.put("Panel.background", Scheme.active().getControl());
            table.put("ScrollPane.background", Scheme.active().getControl());
            table.put("ScrollPane.foreground", Scheme.active().getControlText());
            table.put("Viewport.background", Scheme.active().getControl());
            table.put("Viewport.foreground", Scheme.active().getControlText());
            table.put("EditorPane.caretForeground", Scheme.active().getWindowText());
            table.put("EditorPane.selectionBackground", Scheme.active().getTextHighlight());
            table.put("Label.foreground", Scheme.active().getControlText());
            table.put("Label.disabledForeground", Scheme.active().getControlDisabledText());
            table.put("Label.disabledShadow", Scheme.active().getControl());
            table.put("Label.background", Scheme.active().getControl());
            table.put("Label.interiorBackground", Scheme.active().getControl());
            table.put("Label.shadow", Scheme.active().getControl());
            table.put("Label.darkShadow", Scheme.active().getControlDarkshadow());
            table.put("Label.light", Scheme.active().getControl());
            table.put("Label.highlight", Scheme.active().getControlDarkshadow());
            table.put("RadioButton.foreground", Scheme.active().getControlText());
            table.put("RadioButton.background", Scheme.active().getControl());
            table.put("RadioButton.interiorBackground", Scheme.active().getControl());
            table.put("RadioButton.shadow", Scheme.active().getButtonBorderColor());
            table.put("RadioButton.darkShadow", Scheme.active().getControl());
            table.put("RadioButton.light", Scheme.active().getControl());
            table.put("RadioButton.highlight", Scheme.active().getButtonBorderColor());
            table.put("CheckBox.foreground", Scheme.active().getControlText());
            table.put("CheckBox.background", Scheme.active().getControl());
            table.put("CheckBox.interiorBackground", Scheme.active().getControl());
            table.put("CheckBox.shadow", Scheme.active().getButtonBorderColor());
            table.put("CheckBox.darkShadow", Scheme.active().getControl());
            table.put("CheckBox.light", Scheme.active().getControl());
            table.put("CheckBox.highlight", Scheme.active().getButtonBorderColor());
            table.put("ToolBar.background", Scheme.active().getMenu());
            table.put("ToolBar.border", BorderFactory.createEmptyBorder());
            table.put("ToolBar.highlight", Scheme.active().getSeparator1());
            table.put("ToolBar.shadow", Scheme.active().getSeparator2());
            table.put("OptionPane.background", Scheme.active().getControl());
            table.put("OptionPane.foreground", Scheme.active().getControlText());
            table.put("OptionPane.messageForeground", Scheme.active().getControlText());
            table.put("FileChooser.listViewBackground", Scheme.active().getWindow());
            table.put("FileChooser.listViewIcon", EditorUtilities.loadIcon("images/ListView.gif"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JRadioButton rb = (JRadioButton)c;
            ButtonModel model = rb.getModel();
            boolean drawDot = model.isSelected();
            Color background = c.getBackground();
            Color dotColor = Scheme.active().getControlText();
            Color shadow = Scheme.active().getControlShadow();
            Color darkCircle = Scheme.active().getControlDarkshadow();
            Color whiteInnerLeftArc = Scheme.active().getControlHighlight();
            Color whiteOuterRightArc = Scheme.active().getControlHighlight();
            Color interiorColor = background;
            if (!model.isEnabled()) {
                whiteInnerLeftArc = whiteOuterRightArc = background;
                darkCircle = dotColor = shadow;
            } else if (model.isPressed() && model.isArmed()) {
                whiteInnerLeftArc = interiorColor = shadow;
            }
            g.translate(x, y);
            if (c.isOpaque()) {
                g.setColor(interiorColor);
                g.fillRect(2, 2, 9, 9);
            }
            g.setColor(Scheme.active().getToggleButtonBorderColor());
            g.drawOval(0, 0, 11, 11);
            if (drawDot) {
                g.setColor(dotColor);
                g.fillOval(2, 2, 7, 7);
            }
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 13;
        }

        @Override
        public int getIconHeight() {
            return 13;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            ButtonModel model = ((JCheckBox)c).getModel();
            int controlSize = this.getControlSize();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    g.setColor(Scheme.active().getToggleButtonBorderColor());
                    g.fillRect(x, y, controlSize, controlSize);
                    g.drawRect(x, y, controlSize, controlSize);
                } else {
                    g.setColor(Scheme.active().getToggleButtonBorderColor());
                    g.drawRect(x, y, controlSize, controlSize);
                }
            } else {
                g.setColor(Scheme.active().getControlShadow());
                g.drawRect(x, y, controlSize - 2, controlSize - 2);
            }
            if (model.isSelected()) {
                g.setColor(Scheme.active().getControlText());
                this.drawCheck(c, g, x, y);
            }
        }

        protected void drawCheck(Component c, Graphics g, int x, int y) {
            int controlSize = this.getControlSize();
            int csx = controlSize - 3;
            int csy1 = controlSize - 6;
            int csy2 = controlSize - 4;
            int csy3 = controlSize - 3;
            int[] xPoints = new int[]{3, 5, 5, csx, csx, 5, 5, 3};
            int[] yPoints = new int[]{5, 5, csy1, 2, 4, csy2, csy3, csy3};
            g.translate(x, y);
            g.fillPolygon(xPoints, yPoints, 8);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.getControlSize();
        }

        @Override
        public int getIconHeight() {
            return this.getControlSize();
        }
    }
}

