/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractGotoPopup;
import editor.FileTreeUtil;
import editor.LabFrame;
import editor.TypeCellRenderer;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import gw.fs.IFile;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.util.PathUtil;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.swing.JRootPane;
import javax.swing.text.JTextComponent;

public class GotoTypePopup
extends AbstractGotoPopup<String> {
    private static final int DEFAULT_WAIT_TIME = 0;
    private static final int ROW_COUNT = 10;

    public static void display() {
        GotoTypePopup valuePopup = new GotoTypePopup("");
        valuePopup.addNodeChangeListener(e -> {
            String strQualifedType = (String)e.getSource();
            GotoTypePopup.doGoTo(strQualifedType);
        });
        JRootPane host = LabFrame.instance().getRootPane();
        valuePopup.show(host, 0, 0);
    }

    public static void display(JTextComponent host, Consumer<String> consumer) {
        GotoTypePopup valuePopup = new GotoTypePopup("");
        valuePopup.addNodeChangeListener(e -> {
            String strQualifedType = (String)e.getSource();
            consumer.accept(strQualifedType);
        });
        valuePopup.show(EditorUtilities.rootPaneForComponent(host), 0, 0);
    }

    public static void doGoTo(String strQualifedType) {
        EditorUtilities.showWaitCursor(true);
        try {
            IType type = TypeSystem.getByFullNameIfValid((String)strQualifedType);
            if (type == null) {
                return;
            }
            IFile[] sourceFiles = type.getSourceFiles();
            if (sourceFiles != null && sourceFiles.length > 0) {
                IFile sourceFile = sourceFiles[0];
                LabFrame.instance().openFile(PathUtil.create((URI)sourceFile.toURI()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            EditorUtilities.showWaitCursor(false);
        }
    }

    public GotoTypePopup(String strPrefix) {
        super(0, 10, "Enter type name", strPrefix, true, true, true);
    }

    protected GotoTypePopup(String title, String strPrefix) {
        super(0, 10, title, strPrefix, true, true, true);
    }

    @Override
    protected List<String> initializeData() {
        Set<String> allTypes = !this.isExternalTypes() ? FileTreeUtil.getAllExperimentTypes() : LabFrame.instance().getGosuPanel().getTypeNamesCache().getAllTypeNames(null);
        Experiment experiment = LabFrame.instance().getGosuPanel().getExperimentView().getExperiment();
        allTypes = this.filterTypes(allTypes, experiment);
        ArrayList<String> sortedList = new ArrayList<String>(allTypes);
        sortedList.sort((o1, o2) -> GotoTypePopup.getRelativeTypeName(o1).compareToIgnoreCase(GotoTypePopup.getRelativeTypeName(o2)));
        return sortedList;
    }

    protected Set<String> filterTypes(Set<String> allGosuTypes, Experiment experiment) {
        return this.filterGosuClassFromExperimentsInResources(allGosuTypes, experiment);
    }

    private Set<String> filterGosuClassFromExperimentsInResources(Set<String> allGosuTypes, Experiment experiment) {
        String experimentPath = PathUtil.getAbsolutePathName((Path)experiment.getExperimentDir());
        List relativeSrcPaths = experiment.getSourcePath().stream().map(srcPath -> (srcPath.startsWith(experimentPath) ? srcPath.substring(experimentPath.length() + 1) : srcPath).replace(File.separatorChar, '.')).collect(Collectors.toList());
        return allGosuTypes.stream().filter(fqn -> relativeSrcPaths.stream().noneMatch(fqn::contains)).filter(fqn -> !fqn.startsWith("gw.internal")).collect(Collectors.toSet());
    }

    @Override
    protected AbstractGotoPopup.AbstractPopupListModel<String> reconstructModel(String strPrefix) {
        return new TypeModel(GotoTypePopup.filterStrings(this.getInitializedAllData(), strPrefix));
    }

    private static String getRelativeTypeName(String strType) {
        int iIndex = strType.lastIndexOf(46);
        if (iIndex > 0) {
            return strType.substring(iIndex + 1);
        }
        return strType;
    }

    @Override
    protected TypeCellRenderer constructCellRenderer() {
        return new TypeCellRenderer(this._list);
    }

    @Override
    protected void handleEdit() {
        this.filterDisplay(this.escape(this._nameField.getText()), true);
    }

    private String escape(String text) {
        text = text.replace('.', '~');
        return text;
    }

    public static List<String> filterStrings(Collection<? extends CharSequence> collection, String filter) {
        Set<String> set = GotoTypePopup._filterStrings(collection, filter, false);
        set.addAll(GotoTypePopup._filterStrings(collection, filter, true));
        return new ArrayList<String>(set);
    }

    private static Set<String> _filterStrings(Collection<? extends CharSequence> collection, String filter, boolean forceLower) {
        int iDotIndex;
        if (filter == null) {
            filter = "";
        }
        if ((iDotIndex = filter.lastIndexOf(46)) >= 0) {
            filter = filter.substring(iDotIndex + 1);
        }
        TreeSet<String> filteredTypes = new TreeSet<String>();
        if (filter.length() > 0) {
            int iFlags = 0;
            if (!forceLower && filter.length() > 0 && filter.indexOf(42) < 0 && Character.isUpperCase(filter.charAt(0))) {
                filter = GotoTypePopup.camelCasePrefix(filter);
            } else {
                iFlags = 66;
            }
            filter = filter.replaceAll("\\*", "\\.\\*");
            filter = filter.replaceAll("\\#", "\\*");
            boolean bHasDot = filter.indexOf(126) >= 0;
            filter = filter.replaceAll("~", "(\\\\.|\u2024)");
            boolean exactMatch = filter.endsWith(" ");
            filter = filter.trim();
            try {
                Pattern pattern = Pattern.compile("^" + filter + (exactMatch ? "" : (filter.startsWith(".*") ? "" : ".*")), iFlags);
                for (CharSequence charSequence : collection) {
                    String strType = charSequence.toString();
                    String strName = bHasDot ? strType : GotoTypePopup.getRelativeTypeName(strType);
                    boolean shouldAdd = exactMatch ? pattern.matcher(strName).matches() : pattern.matcher(strName).find();
                    if (!shouldAdd) continue;
                    filteredTypes.add(strType);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return filteredTypes;
    }

    private static String camelCasePrefix(String strPrefix) {
        StringBuilder sb = new StringBuilder();
        for (int i = strPrefix.length() - 1; i >= 0; --i) {
            char c = strPrefix.charAt(i);
            sb.insert(0, c);
            if (i == 0 || !Character.isUpperCase(c)) continue;
            sb.insert(0, "[^A-Z]#");
        }
        return sb.toString();
    }

    static class TypeModel
    extends AbstractGotoPopup.AbstractPopupListModel<String> {
        private List<String> _allTypes;

        public TypeModel(List<String> allTypes) {
            this._allTypes = allTypes;
        }

        @Override
        public int getSize() {
            return this._allTypes.size();
        }

        @Override
        public String getElementAt(int i) {
            return this._allTypes.get(i);
        }
    }
}

