/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

public class HTMLEscapeUtil {
    public static final String NBSP = "&nbsp;";
    public static final String URL_PARAMETER_SEPARATOR = "&";

    private HTMLEscapeUtil() {
    }

    public static String escape(String string) {
        return HTMLEscapeUtil.escape(string, true);
    }

    public static String escape(String string, boolean escapeNewLine) {
        return HTMLEscapeUtil.escape(string, escapeNewLine, false);
    }

    public static String escapeForTextArea(String string) {
        return HTMLEscapeUtil.escape(string, false, true);
    }

    private static String escape(String string, boolean escapeNewLine, boolean isTextArea) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuilder resultBuffer = null;
        int last = 0;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            String entity = null;
            char ch = string.charAt(i);
            switch (ch) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case ' ': {
                    if (last != 32 || isTextArea) break;
                    entity = NBSP;
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '\n': {
                    if (!escapeNewLine) break;
                    entity = "<br>";
                    break;
                }
            }
            if (entity != null) {
                if (resultBuffer == null) {
                    resultBuffer = new StringBuilder(string);
                    resultBuffer.setLength(i);
                }
                resultBuffer.append(entity);
            } else if (resultBuffer != null) {
                resultBuffer.append(ch);
            }
            last = ch;
        }
        return resultBuffer != null ? resultBuffer.toString() : string;
    }

    public static String escapeAttribute(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuilder resultBuffer = null;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            String entity = null;
            char ch = string.charAt(i);
            switch (ch) {
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
            }
            if (entity != null) {
                if (resultBuffer == null) {
                    resultBuffer = new StringBuilder(string);
                    resultBuffer.setLength(i);
                }
                resultBuffer.append(entity);
                continue;
            }
            if (resultBuffer == null) continue;
            resultBuffer.append(ch);
        }
        return resultBuffer != null ? resultBuffer.toString() : string;
    }
}

