/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.Scheme;
import editor.util.LabButton;
import editor.util.LabProgressBarUI;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class ProgressPanel
extends JPanel {
    private JProgressBar _progress;
    private JLabel _labelProgress;
    private ActionListener _abortListener;

    public ProgressPanel(int iLength, String strNotice, ActionListener abortListener) {
        this(iLength, strNotice, abortListener, false);
    }

    public ProgressPanel(int iLength, String strNotice, ActionListener abortListener, boolean bProLife) {
        this._abortListener = abortListener;
        this.configUI(strNotice, iLength, bProLife);
    }

    public void setLength(int iLength) {
        this._progress.setValue(0);
        this._progress.setMaximum(iLength < 0 ? 0 : iLength);
        this._progress.setIndeterminate(iLength < 0);
    }

    public int getLength() {
        return this._progress.getMaximum();
    }

    protected void configUI(String strNotice, int iLength, boolean bProLife) {
        CompoundBorder border = BorderFactory.createCompoundBorder(UIManager.getBorder("PopupMenu.border"), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setBorder(border);
        this.setLayout(new BorderLayout());
        this.setBackground(Scheme.active().getWindow());
        JPanel panelCenter = new JPanel(new BorderLayout());
        panelCenter.setBackground(Scheme.active().getWindow());
        panelCenter.setForeground(UIManager.getColor("windowText"));
        panelCenter.setBorder(new EmptyBorder(10, 10, 10, 10));
        panelCenter.setOpaque(true);
        JLabel labelNotice = new JLabel(strNotice);
        labelNotice.setFont(labelNotice.getFont().deriveFont(1));
        labelNotice.setBorder(new EmptyBorder(0, 0, 7, 0));
        labelNotice.setBackground(Scheme.active().getWindow());
        labelNotice.setForeground(UIManager.getColor("windowText"));
        labelNotice.setOpaque(true);
        panelCenter.add("North", labelNotice);
        this.add("North", panelCenter);
        final LabButton btnAbort = new LabButton("Abort");
        btnAbort.setMnemonic('A');
        btnAbort.setFocusable(false);
        btnAbort.setCursor(Cursor.getPredefinedCursor(0));
        JPanel panelCtrl = new JPanel(new BorderLayout());
        this._progress = new JProgressBar(0, iLength < 0 ? 0 : iLength);
        this._progress.setBorder(BorderFactory.createEmptyBorder());
        this._progress.setUI(new LabProgressBarUI());
        if (iLength < 0) {
            this._progress.setIndeterminate(true);
        }
        this._progress.setBackground(Scheme.active().getWindow());
        JPanel progressPanel = new JPanel(new BorderLayout());
        progressPanel.add("Center", this._progress);
        progressPanel.setBackground(Scheme.active().getWindow());
        progressPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 15, 10));
        this._labelProgress = new JLabel();
        this._labelProgress.setBackground(Scheme.active().getWindow());
        this._labelProgress.setForeground(UIManager.getColor("windowText"));
        this._labelProgress.setOpaque(true);
        progressPanel.add("South", this._labelProgress);
        panelCtrl.add("North", progressPanel);
        JPanel panelButtons = new JPanel(new FlowLayout());
        panelButtons.setBackground(Scheme.active().getWindow());
        panelButtons.add(btnAbort);
        panelCtrl.add("South", panelButtons);
        this.add("South", panelCtrl);
        btnAbort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressPanel.this._abortListener.actionPerformed(e);
                btnAbort.setEnabled(false);
                btnAbort.setText("Aborting...");
            }
        });
        if (bProLife) {
            ((JComponent)btnAbort).setVisible(false);
        }
    }

    public void updateProgress(int iProgress, String strProgress) {
        this._progress.setValue(iProgress);
        this.updateProgress(strProgress);
    }

    public void updateProgress(String strProgress) {
        this._labelProgress.setText(strProgress);
        this.revalidate();
    }

    public int getProgess() {
        return this._progress.getValue();
    }
}

