/*
 * Decompiled with CFR 0.152.
 */
package editor.util.transform.java.visitor;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExportsTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.OpensTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ProvidesTree;
import com.sun.source.tree.RequiresTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.UsesTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.DocTrees;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Convert;
import editor.util.transform.java.visitor.DummyBlock;
import editor.util.transform.java.visitor.SymbolTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;

public class GosuVisitor
implements TreeVisitor<String, Object> {
    private DocTrees _docTrees;
    private CompilationUnitTree _compilationUnit;
    StringBuilder _output;
    private int _ident = 0;
    private int _tabSize;
    private String _tab;
    private SymbolTable _symTable;
    private String _currentEnumIdent;
    private List<String> _currentResourcesIdents;
    private Mode _mode;
    private boolean _isEnum;
    private boolean _isInterface;
    boolean _skipBlockScope;
    private boolean _skipSymConversion;
    private ClassTree _topLevelClass;

    public GosuVisitor(int tabSize, DocTrees docTrees) {
        this._tabSize = tabSize;
        this._docTrees = docTrees;
        this._tab = this.genTabSpaces(this._tabSize);
        this._mode = Mode.NORMAL;
        this._symTable = new SymbolTable();
        this._output = new StringBuilder();
        this._skipBlockScope = false;
        this._skipSymConversion = false;
    }

    public StringBuilder getOutput() {
        return this._output;
    }

    @Override
    public String visitImport(ImportTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        out.append("uses ");
        Object fqn = node.getQualifiedIdentifier().accept(this, v);
        if (node.isStatic()) {
            int dot = ((String)fqn).lastIndexOf(".");
            fqn = ((String)fqn).substring(0, dot) + "#" + ((String)fqn).substring(dot + 1);
        }
        out.append((String)fqn);
        out.append("\n");
        return out.toString();
    }

    @Override
    public String visitCompilationUnit(CompilationUnitTree node, Object v) {
        this._ident = 0;
        this._compilationUnit = node;
        if (!node.getPackageAnnotations().isEmpty()) {
            throw new AssertionError((Object)"Annotations on packages not supported");
        }
        ExpressionTree packageName = node.getPackageName();
        this.appendComment(node, this._output);
        if (packageName != null) {
            this._output.append("package ");
            this._output.append(packageName);
            this._output.append("\n\n");
        }
        List<? extends ImportTree> imports = node.getImports();
        for (ImportTree importTree : imports) {
            this._output.append(importTree.accept(this, v));
        }
        this._output.append("\n");
        List<? extends Tree> typeDecls = node.getTypeDecls();
        for (Tree tree : typeDecls) {
            if (tree instanceof ClassTree) {
                this._topLevelClass = (ClassTree)tree;
            }
            this._output.append(tree.accept(this, v));
        }
        return this._output.toString();
    }

    private void appendComment(Tree node, StringBuilder out) {
        if (this._docTrees == null) {
            return;
        }
        TreePath path = this._docTrees.getPath(this._compilationUnit, node);
        if (path != null) {
            DocCommentTree docTree = this._docTrees.getDocCommentTree(path);
            String docComment = this._docTrees.getDocComment(path);
            if (docComment != null) {
                out.append("/**\n");
                for (String line : docComment.split("\\r?\\n")) {
                    this.appendIndent(out);
                    out.append(" *");
                    out.append(line);
                    out.append("\n");
                }
                this.appendIndent(out);
                out.append(" */\n");
                this.appendIndent(out);
            }
        }
    }

    @Override
    public String visitClass(ClassTree node, Object v) {
        List<? extends Tree> implementsClause;
        String declType;
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        this._mode = Mode.NORMAL;
        Name name = node.getSimpleName();
        List<? extends TypeParameterTree> typeParameters = node.getTypeParameters();
        Tree.Kind kind = node.getKind();
        this._isEnum = false;
        this._isInterface = false;
        switch (kind) {
            case CLASS: {
                declType = "class";
                break;
            }
            case ENUM: {
                declType = "enum";
                this._isEnum = true;
                this._currentEnumIdent = name.toString();
                break;
            }
            case INTERFACE: {
                declType = "interface";
                this._isInterface = true;
                break;
            }
            case ANNOTATION_TYPE: {
                declType = "annotation";
                break;
            }
            default: {
                declType = "???";
            }
        }
        ModifiersTree modifiers = node.getModifiers();
        out.append(modifiers.accept(this, Modifier.PUBLIC));
        out.append(declType);
        out.append(" ");
        out.append(name);
        if (!typeParameters.isEmpty()) {
            out.append("<");
            boolean first = true;
            for (Tree tree : typeParameters) {
                if (!first) {
                    out.append(", ");
                }
                first = false;
                out.append(tree.accept(this, v));
            }
            out.append(">");
        }
        out.append(" ");
        Tree extendsClause = node.getExtendsClause();
        if (extendsClause != null) {
            out.append("extends ");
            out.append(extendsClause.accept(this, v));
            out.append(" ");
        }
        if (!(implementsClause = node.getImplementsClause()).isEmpty()) {
            if (this._isInterface) {
                out.append("extends ");
            } else {
                out.append("implements ");
            }
            boolean bl = true;
            for (Tree tree : implementsClause) {
                boolean bl2;
                if (bl2) {
                    out.append(tree.accept(this, v));
                    bl2 = false;
                    continue;
                }
                out.append(", ");
                out.append(tree.accept(this, v));
            }
        }
        out.append(" {\n");
        this.pushIndent();
        this._symTable.pushGlobalScope(name.toString());
        List<? extends Tree> list = node.getMembers();
        this.addGlobalVariables(list);
        boolean firstEnum = true;
        int n = out.length();
        for (Tree tree : list) {
            if (this._isEnum && this.isAEnumConstant(tree)) {
                if (!firstEnum) {
                    out.append(",\n");
                }
                firstEnum = false;
                this.appendIndent(out);
                String enumConst = tree.accept(this, v);
                out.append(enumConst);
                continue;
            }
            if (!firstEnum) {
                out.append("\n\n");
                firstEnum = true;
            }
            if (!(tree instanceof VariableTree)) continue;
            this.appendIndent(out);
            Mode old = this._mode;
            this._mode = Mode.CLASS_VAR;
            out.append(tree.accept(this, v));
            this._mode = old;
            out.append("\n");
        }
        if (n != out.length()) {
            out.append("\n");
        }
        for (Tree tree : list) {
            if (this._isEnum && this.isAEnumConstant(tree) || tree instanceof VariableTree) continue;
            this.appendIndent(out);
            if (tree instanceof BlockTree && !((BlockTree)tree).isStatic()) {
                this.appendAsInlineComment(out, "FIX ME: initializer blocks not allowed in Gosu");
            }
            out.append(tree.accept(this, v));
            out.append("\n");
        }
        if (this._isEnum) {
            out.append("\n");
            this._isEnum = false;
        }
        if (this._isInterface) {
            this._isInterface = false;
        }
        this._mode = Mode.NORMAL;
        this._symTable.popGlobalScope();
        this.popIndent();
        this.appendIndent(out);
        out.append("}\n");
        return out.toString();
    }

    private void addGlobalVariables(List<? extends Tree> members) {
        for (Tree tree : members) {
            if (!(tree instanceof VariableTree)) continue;
            String ident = ((VariableTree)tree).getName().toString();
            this._symTable.addGlobally(ident);
        }
    }

    @Override
    public String visitReturn(ReturnTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        ExpressionTree expression = node.getExpression();
        out.append("return");
        if (expression != null) {
            out.append(" ");
            out.append(expression.accept(this, v));
        }
        return out.toString();
    }

    @Override
    public String visitTry(TryTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        List<? extends Tree> resources = node.getResources();
        BlockTree block = node.getBlock();
        List<? extends CatchTree> catches = node.getCatches();
        BlockTree finallyBlock = node.getFinallyBlock();
        ArrayList<String> resIdents = new ArrayList<String>();
        if (catches.isEmpty() && !resources.isEmpty()) {
            out.append("using (");
            boolean first = true;
            Mode mode = this._mode;
            this._mode = Mode.USING_NO_MODIFIERS;
            for (Tree tree : resources) {
                if (!first) {
                    out.append(", ");
                }
                first = false;
                out.append(tree.accept(this, v));
            }
            this._mode = mode;
            out.append(")");
            out.append(block.accept(this, v));
            if (finallyBlock != null) {
                this.appendIndent(out);
                out.append("finally ");
                out.append(finallyBlock.accept(this, v));
            }
            return out.toString();
        }
        if (!resources.isEmpty()) {
            for (Tree tree : resources) {
                out.append("\n");
                this.appendIndent(out);
                out.append(tree.accept(this, v));
                String ident = ((JCTree.JCVariableDecl)tree).getName().toString();
                resIdents.add(ident);
            }
        }
        out.append("\n");
        this.appendIndent(out);
        out.append("try");
        out.append(block.accept(this, v));
        if (!catches.isEmpty()) {
            for (CatchTree catchTree : catches) {
                out.append(catchTree.accept(this, v));
            }
        }
        if (finallyBlock != null || !resIdents.isEmpty()) {
            Mode oldMode = this._mode;
            this._mode = Mode.ADD_RESOURCES_FINALLY_BLOCK;
            this._currentResourcesIdents = resIdents;
            this.appendIndent(out);
            out.append("finally ");
            if (finallyBlock == null) {
                finallyBlock = new DummyBlock();
            }
            out.append(finallyBlock.accept(this, v));
            this._mode = oldMode;
        }
        return out.toString();
    }

    @Override
    public String visitCatch(CatchTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        VariableTree parameter = node.getParameter();
        BlockTree block = node.getBlock();
        Tree type = parameter.getType();
        if (type instanceof JCTree.JCTypeUnion) {
            String name = parameter.getName().toString();
            for (JCTree.JCExpression expr : ((JCTree.JCTypeUnion)type).getTypeAlternatives()) {
                this.appendIndent(out);
                out.append("catch (");
                this._skipBlockScope = true;
                this._symTable.pushLocalScope();
                String newName = this._symTable.addLocally(name);
                out.append(newName).append(": ");
                out.append(expr.accept(this, v));
                out.append(")");
                out.append(block.accept(this, v));
                this._symTable.popLocalScope();
            }
        } else {
            this.appendIndent(out);
            out.append("catch (");
            this._skipBlockScope = true;
            Mode oldMode = this._mode;
            this._mode = Mode.CATCH_PARAM;
            this._symTable.pushLocalScope();
            out.append(parameter.accept(this, v));
            this._mode = oldMode;
            out.append(")");
            out.append(block.accept(this, v));
            this._symTable.popLocalScope();
        }
        return out.toString();
    }

    @Override
    public String visitLabeledStatement(LabeledStatementTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        StatementTree stmt = node.getStatement();
        String label = node.getLabel().toString() + ":\n";
        this.appendAsInlineComment(out, "FIX ME: labeled statements not allowed in Gosu");
        out.append(label);
        this.appendIndent(out);
        out.append(stmt.accept(this, v));
        return out.toString();
    }

    @Override
    public String visitBlock(BlockTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        if (node.isStatic()) {
            this.appendAsInlineComment(out, "FIX ME: initializer blocks not allowed in Gosu");
        }
        out.append(" {\n");
        this.pushIndent();
        boolean skipPopScope = false;
        if (!this._skipBlockScope) {
            this._symTable.pushLocalScope();
        } else {
            this._skipBlockScope = false;
            skipPopScope = true;
        }
        if (this._mode == Mode.ADD_RESOURCES_FINALLY_BLOCK) {
            for (int i = this._currentResourcesIdents.size() - 1; i >= 0; --i) {
                String id = this._currentResourcesIdents.get(i);
                this.appendIndent(out);
                String string = this._symTable.convertLocalSymbol(id);
                out.append("if (").append(string).append(" != null) ").append(string).append(".close()\n");
            }
        }
        List<? extends StatementTree> statements = node.getStatements();
        for (StatementTree statementTree : statements) {
            this.appendIndent(out);
            out.append(statementTree.accept(this, v));
            out.append("\n");
        }
        if (!skipPopScope) {
            this._symTable.popLocalScope();
        }
        this.popIndent();
        this.appendIndent(out);
        out.append("}\n");
        return out.toString();
    }

    @Override
    public String visitSwitch(SwitchTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        List<? extends CaseTree> cases = node.getCases();
        ExpressionTree expression = node.getExpression();
        out.append("switch ");
        out.append(expression.accept(this, v));
        out.append(" {\n");
        this.pushIndent();
        this._symTable.pushLocalScope();
        for (CaseTree caseTree : cases) {
            out.append(caseTree.accept(this, v));
            out.append("\n");
        }
        this._symTable.popLocalScope();
        this.popIndent();
        this.appendIndent(out);
        out.append("}\n");
        return out.toString();
    }

    @Override
    public String visitCase(CaseTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        ExpressionTree expr = node.getExpression();
        List<? extends StatementTree> statements = node.getStatements();
        this.appendIndent(out);
        if (expr != null) {
            out.append("case ");
            out.append(expr.accept(this, v));
        } else {
            out.append("default");
        }
        out.append(":\n");
        this.pushIndent();
        for (StatementTree statementTree : statements) {
            this.appendIndent(out);
            out.append(statementTree.accept(this, v));
            out.append("\n");
        }
        this.popIndent();
        this.appendIndent(out);
        return out.toString();
    }

    @Override
    public String visitEnhancedForLoop(EnhancedForLoopTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        String variablename = node.getVariable().getName().toString();
        ExpressionTree expr = node.getExpression();
        StatementTree stmt = node.getStatement();
        this._skipBlockScope = true;
        this._symTable.pushLocalScope();
        out.append("for (");
        String newName = this._symTable.addLocally(variablename);
        out.append(newName);
        out.append(" in ");
        out.append(expr.accept(this, v));
        out.append(")");
        if (stmt instanceof BlockTree) {
            out.append(stmt.accept(this, v));
        } else {
            out.append(" {\n");
            this.pushIndent();
            this.appendIndent(out);
            out.append(stmt.accept(this, v));
            this.popIndent();
            out.append("\n");
            this.appendIndent(out);
            out.append("}\n");
        }
        this._symTable.popLocalScope();
        return out.toString();
    }

    @Override
    public String visitEmptyStatement(EmptyStatementTree node, Object v) {
        return "";
    }

    @Override
    public String visitExpressionStatement(ExpressionStatementTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        out.append(node.getExpression().accept(this, v));
        return out.toString();
    }

    @Override
    public String visitArrayAccess(ArrayAccessTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        ExpressionTree expr = node.getExpression();
        ExpressionTree index = node.getIndex();
        out.append(expr.accept(this, v));
        out.append("[");
        out.append(index.accept(this, v));
        out.append("]");
        return out.toString();
    }

    @Override
    public String visitArrayType(ArrayTypeTree node, Object v) {
        return node.getType().accept(this, v) + "[]";
    }

    @Override
    public String visitThrow(ThrowTree node, Object v) {
        return "throw " + node.getExpression().accept(this, v);
    }

    @Override
    public String visitVariable(VariableTree node, Object v) {
        String infer;
        boolean appedVar;
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        String name = node.getName().toString();
        ExpressionTree initializer = node.getInitializer();
        if (this._mode != Mode.CLASS_VAR && !this.isAEnumConstant(node)) {
            name = this._symTable.addLocally(name);
        }
        if (this._isEnum && this.isAEnumConstant(node)) {
            out.append(name);
            if (initializer != null) {
                out.append(initializer.accept(this, v));
            }
            return out.toString();
        }
        if (this._mode != Mode.CATCH_PARAM && this._mode != Mode.USING_NO_MODIFIERS) {
            ModifiersTree modifiers = node.getModifiers();
            out.append(modifiers.accept(this, Modifier.PRIVATE));
        }
        Tree type = node.getType();
        boolean bl = appedVar = this._mode != Mode.METHOD_PARAM && this._mode != Mode.CATCH_PARAM && this._mode != Mode.LAMBDA_PARAM;
        if (appedVar) {
            out.append("var ");
        }
        out.append(name);
        this._skipSymConversion = true;
        String initializerValue = initializer != null ? initializer.accept(this, v) : null;
        Tree saveType = type;
        type = initializer != null && this._mode != Mode.CLASS_VAR && type.getKind() != Tree.Kind.PARAMETERIZED_TYPE && !initializerValue.equals("null") ? null : type;
        String typeName = saveType != null ? saveType.accept(this, v) : null;
        String varType = type == null ? "" : typeName;
        this._skipSymConversion = false;
        Object iniz = null;
        String genType = null;
        if (initializer != null && ((String)(iniz = " = " + initializerValue)).contains("<>")) {
            genType = this.extractGenericType(varType);
            iniz = ((String)iniz).replaceAll("<>", genType);
        }
        if (appedVar && initializer != null && this._mode != Mode.CLASS_VAR && (infer = this.typeInference(initializer, typeName, genType, (String)iniz)) != null) {
            out.append(infer);
            return out.toString();
        }
        if (type != null) {
            out.append(": ");
            out.append(varType);
        }
        if (iniz != null) {
            out.append((String)iniz);
        }
        return out.toString();
    }

    private String extractGenericType(String varType) {
        String out = varType;
        int b = varType.indexOf("<");
        int e = varType.lastIndexOf(">");
        if (b != -1 && e != -1) {
            out = varType.substring(b, e + 1);
        }
        return out;
    }

    private String typeInference(ExpressionTree initializer, String varType, String genType, String iniz) {
        String initType = null;
        boolean literal = false;
        if (initializer instanceof NewArrayTree) {
            Tree arrayType = ((NewArrayTree)initializer).getType();
            if (arrayType != null) {
                initType = arrayType.accept(this, null);
                initType = initType.replaceAll("\\[\\]", "");
                varType = varType.replaceAll("\\[\\]", "");
            }
        } else if (initializer instanceof NewClassTree) {
            initType = ((NewClassTree)initializer).getIdentifier().accept(this, null);
            if (genType != null) {
                initType = initType.replaceAll("<>", genType);
            }
        } else if (initializer instanceof LiteralTree && initializer.getKind() != Tree.Kind.NULL_LITERAL && !varType.equals("Object")) {
            literal = true;
            if (varType.equals("byte")) {
                iniz = (String)iniz + "b";
            } else if (varType.equals("short")) {
                iniz = (String)iniz + " as short";
            } else if (varType.equals("float") && initializer.getKind() == Tree.Kind.INT_LITERAL) {
                iniz = (String)iniz + "f";
            } else if (varType.equals("double") && initializer.getKind() == Tree.Kind.INT_LITERAL) {
                iniz = (String)iniz + ".0";
            } else if (varType.equals("long") && initializer.getKind() == Tree.Kind.INT_LITERAL) {
                iniz = (String)iniz + "L";
            }
        }
        if (initType != null && varType.equals(initType) || literal) {
            return iniz;
        }
        return null;
    }

    private boolean isAEnumConstant(Tree node) {
        return ((JCTree)node).getTag() == JCTree.Tag.VARDEF && (((JCTree.JCVariableDecl)node).mods.flags & 0x4000L) != 0L;
    }

    @Override
    public String visitParameterizedType(ParameterizedTypeTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        Tree type = node.getType();
        List<? extends Tree> typeArguments = node.getTypeArguments();
        out.append(type.accept(this, v));
        if (typeArguments.size() > 0) {
            out.append("<");
            boolean first = true;
            for (Tree tree : typeArguments) {
                if (!first) {
                    out.append(", ");
                }
                first = false;
                out.append(tree.accept(this, v));
            }
            out.append(">");
        }
        return out.toString();
    }

    @Override
    public String visitMemberSelect(MemberSelectTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        String expr = node.getExpression().accept(this, v);
        String id = node.getIdentifier().toString();
        if (expr.endsWith(".this")) {
            int e = expr.indexOf(".this");
            int dot = expr.substring(0, e).lastIndexOf(".");
            int s = dot != -1 ? dot + 1 : 0;
            String clazz = expr.substring(s, e);
            int level = this._symTable.getClassLevelFromCurrent(clazz);
            if (level == 0) {
                return id;
            }
            out.append("outer");
            --level;
            while (level > 0) {
                out.append(".outer");
                --level;
            }
        } else {
            out.append(expr);
        }
        if (!"class".equals(id)) {
            out.append(".");
            out.append(id);
        }
        return out.toString();
    }

    @Override
    public String visitMemberReference(MemberReferenceTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        out.append(node.getQualifierExpression().accept(this, v));
        out.append("#");
        if (node.getMode() == MemberReferenceTree.ReferenceMode.NEW) {
            out.append("construct");
        } else {
            out.append(node.getName());
        }
        out.append("(");
        List<? extends ExpressionTree> typeArguments = node.getTypeArguments();
        if (typeArguments != null) {
            boolean first = true;
            for (ExpressionTree expressionTree : typeArguments) {
                if (!first) {
                    out.append(", ");
                }
                first = false;
                out.append(expressionTree.accept(this, v));
            }
        }
        out.append(").toBlock()");
        return out.toString();
    }

    @Override
    public String visitWildcard(WildcardTree node, Object v) {
        Tree.Kind kind;
        Tree bound = node.getBound();
        String boundStr = "";
        if (bound != null) {
            boundStr = bound.accept(this, v);
        }
        String out = (kind = node.getKind()) == Tree.Kind.EXTENDS_WILDCARD ? boundStr : (kind == Tree.Kind.SUPER_WILDCARD ? "Object" : "Object");
        return out;
    }

    @Override
    public String visitModule(ModuleTree node, Object o) {
        return null;
    }

    @Override
    public String visitExports(ExportsTree node, Object o) {
        return null;
    }

    @Override
    public String visitOpens(OpensTree node, Object o) {
        return null;
    }

    @Override
    public String visitProvides(ProvidesTree node, Object o) {
        return null;
    }

    @Override
    public String visitRequires(RequiresTree node, Object o) {
        return null;
    }

    @Override
    public String visitUses(UsesTree node, Object o) {
        return null;
    }

    @Override
    public String visitBinary(BinaryTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        ExpressionTree lOp = node.getLeftOperand();
        ExpressionTree rOp = node.getRightOperand();
        JCTree.Tag operator = ((JCTree.JCBinary)node).getTag();
        out.append(lOp.accept(this, v));
        out.append(" ").append(this.operatorName(operator)).append(" ");
        out.append(rOp.accept(this, v));
        return out.toString();
    }

    @Override
    public String visitParenthesized(ParenthesizedTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        out.append("(");
        out.append(node.getExpression().accept(this, v));
        if (this._mode == Mode.USING_CAST) {
            out.append(" as IMonitorLock");
        }
        out.append(")");
        return out.toString();
    }

    @Override
    public String visitNewArray(NewArrayTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        List<? extends ExpressionTree> dim = node.getDimensions();
        List<? extends ExpressionTree> inits = node.getInitializers();
        Tree type = node.getType();
        if (type != null) {
            out.append("new ");
            this._skipSymConversion = true;
            out.append(type.accept(this, v));
            this._skipSymConversion = false;
        }
        if (!dim.isEmpty()) {
            if (type != null && type instanceof JCTree.JCArrayTypeTree) {
                int end = out.length();
                out.delete(end - 2, end);
            }
            for (ExpressionTree expressionTree : dim) {
                out.append("[");
                out.append(expressionTree.accept(this, v));
                out.append("]");
            }
            if (type != null && type instanceof JCTree.JCArrayTypeTree) {
                out.append("[]");
            }
        } else if (type != null) {
            out.append("[]");
        }
        if (inits != null) {
            boolean first = true;
            out.append("{");
            for (ExpressionTree expressionTree : inits) {
                if (!first) {
                    out.append(", ");
                }
                first = false;
                out.append(expressionTree.accept(this, v));
            }
            out.append("}");
        }
        return out.toString();
    }

    @Override
    public String visitOther(Tree node, Object v) {
        return "OTHER";
    }

    @Override
    public String visitErroneous(ErroneousTree node, Object v) {
        throw new AssertionError((Object)"We don't support erroneous Java files");
    }

    @Override
    public String visitSynchronized(SynchronizedTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        ExpressionTree expr = node.getExpression();
        BlockTree block = node.getBlock();
        out.append("using ");
        Mode oldMode = this._mode;
        this._mode = Mode.USING_CAST;
        out.append(expr.accept(this, v));
        this._mode = oldMode;
        out.append(block.accept(this, v));
        return out.toString();
    }

    @Override
    public String visitBreak(BreakTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        out.append("break");
        Name label = node.getLabel();
        if (label != null) {
            out.append(" ").append(label);
        }
        return out.toString();
    }

    @Override
    public String visitContinue(ContinueTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        out.append("continue");
        Name label = node.getLabel();
        if (label != null) {
            out.append(" ").append(label);
        }
        return out.toString();
    }

    @Override
    public String visitDoWhileLoop(DoWhileLoopTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        ExpressionTree condition = node.getCondition();
        StatementTree statement = node.getStatement();
        out.append("do");
        if (statement instanceof BlockTree) {
            out.append(statement.accept(this, v));
        } else {
            out.append(" {\n");
            this.pushIndent();
            this._symTable.pushLocalScope();
            this.appendIndent(out);
            out.append(statement.accept(this, v));
            this._symTable.popLocalScope();
            this.popIndent();
            out.append("\n");
            this.appendIndent(out);
            out.append("}\n");
        }
        this.appendIndent(out);
        out.append("while ");
        out.append(condition.accept(this, v));
        return out.toString();
    }

    @Override
    public String visitWhileLoop(WhileLoopTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        ExpressionTree condition = node.getCondition();
        StatementTree statement = node.getStatement();
        out.append("while ");
        out.append(condition.accept(this, v));
        if (statement instanceof BlockTree) {
            out.append(statement.accept(this, v));
        } else {
            out.append(" {\n");
            this.pushIndent();
            this._symTable.pushLocalScope();
            this.appendIndent(out);
            out.append(statement.accept(this, v));
            this._symTable.popLocalScope();
            this.popIndent();
            out.append("\n");
            this.appendIndent(out);
            out.append("}\n");
        }
        return out.toString();
    }

    @Override
    public String visitIf(IfTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        ExpressionTree cond = node.getCondition();
        StatementTree thenStm = node.getThenStatement();
        StatementTree elseStm = node.getElseStatement();
        out.append("if ");
        out.append(cond.accept(this, v));
        if (thenStm instanceof BlockTree) {
            out.append(thenStm.accept(this, v));
            out.deleteCharAt(out.length() - 1);
        } else {
            out.append(" {\n");
            this.pushIndent();
            this._symTable.pushLocalScope();
            this.appendIndent(out);
            out.append(thenStm.accept(this, v));
            this._symTable.popLocalScope();
            this.popIndent();
            out.append("\n");
            this.appendIndent(out);
            out.append("}");
        }
        if (elseStm != null) {
            out.append("\n");
            this.appendIndent(out);
            out.append("else");
            if (elseStm instanceof BlockTree || elseStm instanceof IfTree) {
                if (elseStm instanceof IfTree) {
                    out.append(" ");
                }
                out.append(elseStm.accept(this, v));
                if (elseStm instanceof BlockTree) {
                    out.deleteCharAt(out.length() - 1);
                }
            } else {
                out.append(" {\n");
                this.pushIndent();
                this._symTable.pushLocalScope();
                this.appendIndent(out);
                out.append(elseStm.accept(this, v));
                this._symTable.popLocalScope();
                this.popIndent();
                out.append("\n");
                this.appendIndent(out);
                out.append("}");
            }
        }
        return out.toString();
    }

    @Override
    public String visitInstanceOf(InstanceOfTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        ExpressionTree expr = node.getExpression();
        Tree type = node.getType();
        out.append(expr.accept(this, v));
        out.append(" typeis ");
        out.append(type.accept(this, v));
        return out.toString();
    }

    @Override
    public String visitUnary(UnaryTree node, Object v) {
        JCTree.Tag op = ((JCTree.JCUnary)node).getTag();
        String opName = this.operatorName(op);
        String expr = node.getExpression().accept(this, v);
        if (op == JCTree.Tag.PREDEC || op == JCTree.Tag.PREINC || op == JCTree.Tag.POSTDEC || op == JCTree.Tag.POSTINC) {
            return expr + opName;
        }
        return opName + expr;
    }

    @Override
    public String visitAssert(AssertTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        ExpressionTree condition = node.getCondition();
        ExpressionTree detail = node.getDetail();
        out.append("assert ");
        out.append(condition.accept(this, v));
        if (detail != null) {
            out.append(" : ");
            out.append(detail.accept(this, v));
        }
        return out.toString();
    }

    @Override
    public String visitForLoop(ForLoopTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        List<? extends StatementTree> initializer = node.getInitializer();
        ExpressionTree condition = node.getCondition();
        StatementTree statement = node.getStatement();
        List<? extends ExpressionStatementTree> update = node.getUpdate();
        String gosuForLoop = this.maybeTranfromToGosuFor(node, v);
        if (gosuForLoop != null) {
            return gosuForLoop;
        }
        if (!initializer.isEmpty()) {
            for (StatementTree statementTree : initializer) {
                out.append(statementTree.accept(this, v));
                out.append("\n");
                this.appendIndent(out);
            }
        }
        out.append("while (");
        if (condition == null) {
            out.append("true");
        } else {
            out.append(condition.accept(this, v));
        }
        out.append(") {\n");
        this.pushIndent();
        this._symTable.pushLocalScope();
        if (statement instanceof BlockTree) {
            List<? extends StatementTree> statements = ((BlockTree)statement).getStatements();
            for (StatementTree statementTree : statements) {
                this.appendIndent(out);
                out.append(statementTree.accept(this, v));
                out.append("\n");
            }
        } else {
            this.appendIndent(out);
            out.append(statement.accept(this, v));
            out.append("\n");
        }
        if (!update.isEmpty()) {
            for (ExpressionStatementTree expressionStatementTree : update) {
                this.appendIndent(out);
                out.append(expressionStatementTree.accept(this, v));
                out.append("\n");
            }
        }
        this._symTable.popLocalScope();
        this.popIndent();
        this.appendIndent(out);
        out.append("}\n");
        return out.toString();
    }

    private String maybeTranfromToGosuFor(ForLoopTree node, Object v) {
        StringBuilder out = new StringBuilder();
        List<? extends StatementTree> initializer = node.getInitializer();
        ExpressionTree condition = node.getCondition();
        StatementTree statement = node.getStatement();
        List<? extends ExpressionStatementTree> update = node.getUpdate();
        if (initializer.size() == 1 && update.size() == 1 && condition instanceof JCTree.JCBinary) {
            StatementTree inizST = initializer.get(0);
            ExpressionTree expression = update.get(0).getExpression();
            JCTree.JCBinary cond = (JCTree.JCBinary)condition;
            if (cond.getTag() == JCTree.Tag.LT && inizST instanceof JCTree.JCVariableDecl && expression instanceof JCTree.JCUnary) {
                JCTree.JCVariableDecl iniz = (JCTree.JCVariableDecl)inizST;
                JCTree.JCUnary up = (JCTree.JCUnary)expression;
                String var = cond.getLeftOperand().accept(this, v);
                if (var.equals(up.getExpression().accept(this, v)) && var.equals(iniz.getName().toString()) && (up.getTag() == JCTree.Tag.PREINC || up.getTag() == JCTree.Tag.POSTINC) && "0".equals(iniz.getInitializer().accept(this, v))) {
                    JCTree.JCExpression condRight = cond.getRightOperand();
                    boolean validLimit = false;
                    String condR = condRight.accept(this, v);
                    if (condRight instanceof JCTree.JCLiteral) {
                        try {
                            Integer val = Integer.valueOf(condR);
                            if (val >= 0) {
                                validLimit = true;
                            }
                        }
                        catch (NumberFormatException val) {}
                    } else if (condR.endsWith(".size()") || condR.endsWith(".length()") || condR.endsWith(".length")) {
                        validLimit = true;
                    }
                    if (validLimit) {
                        this._skipBlockScope = true;
                        this._symTable.pushLocalScope();
                        String newName = this._symTable.addLocally(var);
                        out.append("for (");
                        out.append(newName);
                        out.append(" in 0..|");
                        out.append(condR);
                        out.append(")");
                        if (statement instanceof BlockTree) {
                            out.append(statement.accept(this, v));
                        } else {
                            out.append(" {\n");
                            this.pushIndent();
                            this.appendIndent(out);
                            out.append(statement.accept(this, v));
                            this.popIndent();
                            out.append("\n");
                            this.appendIndent(out);
                            out.append("}\n");
                        }
                        this._symTable.popLocalScope();
                        return out.toString();
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String visitConditionalExpression(ConditionalExpressionTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        ExpressionTree cond = node.getCondition();
        ExpressionTree falseExp = node.getFalseExpression();
        ExpressionTree trueEx = node.getTrueExpression();
        out.append(cond.accept(this, v));
        out.append(" ? ");
        out.append(trueEx.accept(this, v));
        out.append(" : ");
        out.append(falseExp.accept(this, v));
        return out.toString();
    }

    private boolean isMethodInvocationPropertyAssignment(MethodInvocationTree node, Object v) {
        List<? extends ExpressionTree> arguments = node.getArguments();
        ExpressionTree methodSelect = node.getMethodSelect();
        boolean propAssign = false;
        if (methodSelect instanceof IdentifierTree) {
            this._skipSymConversion = true;
            String methodName = methodSelect.accept(this, v);
            String propertyName = this.getPropertyName(methodName, arguments.size());
            if (propertyName != null) {
                propAssign = methodName.startsWith("set");
            }
        } else {
            String ms = methodSelect.accept(this, v);
            int iDot = ms.lastIndexOf(46);
            String methodName = iDot >= 0 ? ms.substring(iDot + 1) : ms;
            String propertyName = this.getPropertyName(methodName, arguments.size());
            if (propertyName != null) {
                propAssign = methodName.startsWith("set");
            }
        }
        return propAssign;
    }

    @Override
    public String visitMethodInvocation(MethodInvocationTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        List<? extends ExpressionTree> arguments = node.getArguments();
        ExpressionTree methodSelect = node.getMethodSelect();
        boolean propAssign = false;
        boolean propAccess = false;
        if (methodSelect instanceof IdentifierTree) {
            this._skipSymConversion = true;
            String methodName = methodSelect.accept(this, v);
            String propertyName = this.getPropertyName(methodName, arguments.size());
            if (propertyName != null) {
                propAssign = methodName.startsWith("set");
                propAccess = !propAssign;
                methodName = propertyName;
            }
            out.append(methodName);
            this._skipSymConversion = false;
        } else {
            Object ms = methodSelect.accept(this, v);
            int iDot = ((String)ms).lastIndexOf(46);
            Object methodName = iDot >= 0 ? ((String)ms).substring(iDot + 1) : ms;
            String string = this.getPropertyName((String)methodName, arguments.size());
            if (string != null) {
                propAssign = ((String)methodName).startsWith("set");
                propAccess = !propAssign;
                methodName = string;
            }
            ms = iDot >= 0 ? ((String)ms).substring(0, iDot + 1) + (String)methodName : ms;
            int i = ((String)ms).indexOf(".super.");
            if (methodSelect instanceof JCTree.JCFieldAccess && i > 0) {
                String beforeSuper = ((String)ms).substring(0, i);
                String afterSuper = ((String)ms).substring(i + 6);
                ms = "super[" + beforeSuper + "]" + afterSuper;
            }
            out.append((String)ms);
        }
        List<? extends Tree> typeArguments = node.getTypeArguments();
        if (!typeArguments.isEmpty()) {
            out.append("<");
            boolean first = true;
            for (Tree tree : typeArguments) {
                if (!first) {
                    out.append(", ");
                }
                first = false;
                out.append(tree.accept(this, v));
            }
            out.append(">");
        }
        if (propAssign) {
            out.append(" = ");
            out.append(arguments.get(0).accept(this, v));
        } else if (!propAccess) {
            int iNewLine;
            out.append("(");
            if (!arguments.isEmpty()) {
                boolean first = true;
                for (ExpressionTree expressionTree : arguments) {
                    if (!first) {
                        out.append(", ");
                    }
                    first = false;
                    out.append(expressionTree.accept(this, v));
                }
            }
            if ((iNewLine = out.lastIndexOf("\n", out.length() - 1)) >= 0 && out.substring(iNewLine).trim().isEmpty()) {
                String removeNewLine = out.substring(0, iNewLine).trim();
                if (removeNewLine.endsWith("}")) {
                    out = new StringBuilder(removeNewLine);
                } else {
                    this.appendIndent(out);
                }
            }
            out.append(")");
        }
        return out.toString();
    }

    private String getPropertyName(String methodName, int argCount) {
        for (String prefix : Arrays.asList("get", "is", "set")) {
            String propertyName;
            char first;
            if (methodName.length() < prefix.length() + 1 || !methodName.startsWith(prefix) || (!prefix.equals("set") || argCount != 1) && (prefix.equals("set") || argCount != 0) || !Character.isJavaIdentifierStart(first = (propertyName = methodName.substring(prefix.length())).charAt(0)) || !String.valueOf(first).equals(String.valueOf(first).toUpperCase())) continue;
            return propertyName;
        }
        return null;
    }

    @Override
    public String visitNewClass(NewClassTree node, Object v) {
        boolean isEnumConst;
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        ExpressionTree identifier = node.getIdentifier();
        List<? extends ExpressionTree> arguments = node.getArguments();
        ClassTree classBody = node.getClassBody();
        ExpressionTree enclosingExpression = node.getEnclosingExpression();
        if (enclosingExpression != null) {
            out.append(enclosingExpression.accept(this, v));
            out.append(".");
        }
        this._skipSymConversion = true;
        String identOut = identifier.accept(this, v);
        this._skipSymConversion = false;
        boolean bl = isEnumConst = this._isEnum && this._currentEnumIdent.equals(identOut);
        if (!isEnumConst) {
            out.append("new ");
            out.append(identOut);
        }
        if (!isEnumConst || !arguments.isEmpty()) {
            out.append("(");
        }
        if (!arguments.isEmpty()) {
            boolean first = true;
            for (ExpressionTree expressionTree : arguments) {
                if (!first) {
                    out.append(", ");
                }
                first = false;
                out.append(expressionTree.accept(this, v));
            }
        }
        if (!isEnumConst || !arguments.isEmpty()) {
            out.append(")");
        }
        if (classBody != null) {
            out.append(" {\n");
            this.pushIndent();
            this._symTable.pushGlobalScope(identOut);
            List<? extends Tree> members = classBody.getMembers();
            this.addGlobalVariables(members);
            for (Tree tree : members) {
                out.append("\n");
                this.appendIndent(out);
                if (tree instanceof VariableTree) {
                    Mode old = this._mode;
                    this._mode = Mode.CLASS_VAR;
                    out.append(tree.accept(this, v));
                    this._mode = old;
                    continue;
                }
                out.append(tree.accept(this, v));
            }
            this._symTable.popGlobalScope();
            this.popIndent();
            out.append("\n");
            this.appendIndent(out);
            out.append("}\n");
        }
        return out.toString();
    }

    @Override
    public String visitLambdaExpression(LambdaExpressionTree node, Object v) {
        boolean bAssignment;
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        out.append("\\ ");
        List<? extends VariableTree> param = node.getParameters();
        Mode oldMode = this._mode;
        this._mode = Mode.LAMBDA_PARAM;
        if (!param.isEmpty()) {
            boolean first = true;
            for (VariableTree variableTree : param) {
                if (!first) {
                    out.append(", ");
                }
                first = false;
                out.append(variableTree.accept(this, v));
            }
            out.append(" ");
        }
        this._mode = oldMode;
        out.append("-> ");
        Tree body = node.getBody();
        boolean bl = bAssignment = body instanceof AssignmentTree || body instanceof MethodInvocationTree && this.isMethodInvocationPropertyAssignment((MethodInvocationTree)body, v);
        if (bAssignment) {
            out.append("{");
        }
        out.append(body.accept(this, v));
        if (bAssignment) {
            out.append("}");
        }
        return out.toString();
    }

    @Override
    public String visitPackage(PackageTree node, Object o) {
        return null;
    }

    @Override
    public String visitPrimitiveType(PrimitiveTypeTree node, Object v) {
        return node.toString();
    }

    @Override
    public String visitMethod(MethodTree node, Object v) {
        boolean first;
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        BlockTree body = node.getBody();
        ModifiersTree modifiers = node.getModifiers();
        String name = node.getName().toString();
        List<? extends VariableTree> parameters = node.getParameters();
        Tree returnType = node.getReturnType();
        List<? extends TypeParameterTree> typeParameters = node.getTypeParameters();
        HashMap<String, String> constructorTypes = null;
        String retType = returnType == null ? null : returnType.accept(this, v);
        out.append(modifiers.accept(this, Modifier.PUBLIC));
        if (name.equals("<init>")) {
            if (this._isEnum && !modifiers.getFlags().contains((Object)Modifier.PRIVATE)) {
                out.append("private ");
            }
            out.append("construct");
            if (!typeParameters.isEmpty()) {
                constructorTypes = this.computeConstructorTypes(typeParameters);
            }
        } else {
            String propertyName = this.getPropertyName(name, parameters.size());
            if (propertyName != null && retType != null && (name.startsWith("set") && retType.equals("void") || (name.startsWith("get") || name.startsWith("is")) && !retType.equals("void"))) {
                out.append("property ");
                if (name.startsWith("set")) {
                    out.append("set ");
                } else {
                    out.append("get ");
                }
                out.append(propertyName);
            } else {
                out.append("function ");
                out.append(name);
            }
            if (!typeParameters.isEmpty()) {
                out.append("<");
                first = true;
                for (Tree tree : typeParameters) {
                    if (!first) {
                        out.append(", ");
                    }
                    first = false;
                    out.append(tree.accept(this, v));
                }
                out.append(">");
            }
        }
        Mode oldMode = this._mode;
        this._mode = Mode.METHOD_PARAM;
        out.append("(");
        this._symTable.pushLocalScope();
        first = true;
        for (VariableTree variableTree : parameters) {
            if (!first) {
                out.append(", ");
            }
            first = false;
            out.append(variableTree.accept(this, v));
        }
        out.append(")");
        if (constructorTypes != null) {
            this.replaceTypes(out, constructorTypes);
        }
        this._mode = oldMode;
        if (retType != null && !retType.equals("void")) {
            out.append(" : ").append(retType);
        }
        if (body != null) {
            boolean bSynchronized = modifiers.getFlags().contains((Object)Modifier.SYNCHRONIZED);
            if (bSynchronized) {
                out.append("{\n");
                this.pushIndent();
                this.appendIndent(out);
                String string = modifiers.getFlags().contains((Object)Modifier.STATIC) ? this._topLevelClass.getSimpleName().toString() : "this";
                out.append("using(").append(string).append(" as IMonitorLock)");
            }
            this._skipBlockScope = true;
            out.append(body.accept(this, v));
            if (bSynchronized) {
                this.popIndent();
                this.appendIndent(out);
                out.append("}\n");
            }
        } else {
            Tree defaultValue = node.getDefaultValue();
            if (defaultValue != null) {
                out.append(" = ");
                out.append(defaultValue.accept(this, v));
            }
        }
        this._symTable.popLocalScope();
        return out.toString();
    }

    private void replaceTypes(StringBuilder out, HashMap<String, String> types) {
        for (int i = 0; i < out.length(); ++i) {
            if (out.charAt(i) != ':') continue;
            ++i;
            while (out.charAt(i) == ' ') {
                ++i;
            }
            int j = i;
            while (out.charAt(i) != ',' && out.charAt(i) != ')' && out.charAt(i) != ' ') {
                ++i;
            }
            String type = out.subSequence(j, i).toString();
            String sub = types.get(type);
            if (sub == null) continue;
            out.replace(j, i, sub);
            i = j + sub.length();
        }
    }

    private HashMap<String, String> computeConstructorTypes(List<? extends TypeParameterTree> typeParameters) {
        HashMap<String, String> constructorTypes = new HashMap<String, String>();
        for (TypeParameterTree typeParameterTree : typeParameters) {
            String value;
            String key = typeParameterTree.getName().toString();
            List<? extends Tree> bounds = typeParameterTree.getBounds();
            if (bounds.isEmpty()) {
                value = "Object";
            } else {
                StringBuilder out = new StringBuilder();
                if (!bounds.isEmpty()) {
                    boolean first = true;
                    for (Tree tree : bounds) {
                        if (!first) {
                            out.append(" & ");
                        }
                        first = false;
                        out.append(tree.accept(this, null));
                    }
                }
                value = out.toString();
            }
            constructorTypes.put(key, value);
        }
        return constructorTypes;
    }

    @Override
    public String visitModifiers(ModifiersTree node, Object defaultModifier) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        boolean isOverridden = false;
        for (AnnotationTree annotationTree : node.getAnnotations()) {
            String ann = annotationTree.accept(this, null);
            if ("override".equals(ann)) {
                isOverridden = true;
                continue;
            }
            out.append(ann);
            out.append("\n");
        }
        if (!node.getAnnotations().isEmpty() && !isOverridden) {
            this.appendIndent(out);
        }
        if (isOverridden) {
            if (node.getAnnotations().size() > 1) {
                this.appendIndent(out);
            }
            out.append("override ");
        }
        for (Modifier modifier : node.getFlags()) {
            String mod;
            if (modifier == defaultModifier || "default".equals(mod = modifier.toString()) || "synchronized".equals(mod)) continue;
            out.append(mod);
            out.append(" ");
        }
        String modifiers = out.toString();
        if (!(this._mode != Mode.CLASS_VAR || this._isInterface || node.getFlags().contains(defaultModifier) || modifiers.contains("public") || modifiers.contains("protected") || modifiers.contains("private"))) {
            out.append("internal ");
        }
        return out.toString();
    }

    @Override
    public String visitTypeParameter(TypeParameterTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        Name name = node.getName();
        List<? extends Tree> bounds = node.getBounds();
        out.append(name);
        if (!bounds.isEmpty()) {
            out.append(" extends ");
            boolean first = true;
            for (Tree tree : bounds) {
                if (!first) {
                    out.append(" & ");
                }
                first = false;
                out.append(tree.accept(this, v));
            }
        }
        return out.toString();
    }

    @Override
    public String visitIdentifier(IdentifierTree node, Object v) {
        String ident = node.getName().toString();
        if (!this._skipSymConversion) {
            ident = this._symTable.convertLocalSymbol(ident);
        }
        return ident;
    }

    @Override
    public String visitLiteral(LiteralTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        Object value = node.getValue();
        switch (node.getKind()) {
            case INT_LITERAL: {
                out.append(value);
                break;
            }
            case LONG_LITERAL: {
                out.append(value);
                out.append("L");
                break;
            }
            case FLOAT_LITERAL: {
                out.append(value);
                out.append("f");
                break;
            }
            case DOUBLE_LITERAL: {
                out.append(value);
                break;
            }
            case BOOLEAN_LITERAL: 
            case NULL_LITERAL: {
                out.append(value);
                break;
            }
            case CHAR_LITERAL: {
                out.append("'").append(Convert.quote(String.valueOf(value))).append("'");
                break;
            }
            case STRING_LITERAL: {
                out.append("\"").append(Convert.quote(value.toString())).append("\"");
            }
        }
        return out.toString();
    }

    @Override
    public String visitTypeCast(TypeCastTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        out.append(node.getExpression().accept(this, v));
        out.append(" as ");
        out.append(node.getType().accept(this, v));
        return out.toString();
    }

    @Override
    public String visitAssignment(AssignmentTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        ExpressionTree variable = node.getVariable();
        ExpressionTree expression = node.getExpression();
        out.append(variable.accept(this, v));
        out.append(" = ");
        out.append(expression.accept(this, v));
        return out.toString();
    }

    @Override
    public String visitCompoundAssignment(CompoundAssignmentTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        ExpressionTree variable = node.getVariable();
        ExpressionTree expression = node.getExpression();
        JCTree.Tag operator = ((JCTree.JCAssignOp)node).getTag();
        out.append(variable.accept(this, v));
        out.append(" ").append(this.operatorName(operator)).append(" ");
        out.append(expression.accept(this, v));
        return out.toString();
    }

    @Override
    public String visitAnnotatedType(AnnotatedTypeTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        this.appendAsInlineComment(out, node.getAnnotations().toString());
        out.append(node.getUnderlyingType().accept(this, v));
        return out.toString();
    }

    @Override
    public String visitAnnotation(AnnotationTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        Tree type = node.getAnnotationType();
        String typeStr = type.accept(this, v);
        if ("Override".equals(typeStr)) {
            return "override";
        }
        out.append("@");
        out.append(typeStr);
        List<? extends ExpressionTree> arguments = node.getArguments();
        if (!arguments.isEmpty()) {
            out.append("(");
            boolean first = true;
            for (ExpressionTree expressionTree : arguments) {
                if (!first) {
                    out.append(", ");
                }
                first = false;
                if (expressionTree instanceof AssignmentTree) {
                    out.append(":");
                }
                out.append(expressionTree.accept(this, v));
            }
            out.append(")");
        }
        return out.toString();
    }

    @Override
    public String visitUnionType(UnionTypeTree node, Object v) {
        return null;
    }

    @Override
    public String visitIntersectionType(IntersectionTypeTree node, Object v) {
        StringBuilder out = new StringBuilder();
        this.appendComment(node, out);
        out.append(node.toString());
        return out.toString();
    }

    private void pushIndent() {
        this._ident += this._tabSize;
    }

    private void popIndent() {
        this._ident -= this._tabSize;
    }

    private void appendIndent(StringBuilder out) {
        for (int i = 0; i < this._ident; i += this._tabSize) {
            out.append(this._tab);
        }
    }

    private void appendAsComment(StringBuilder out, String code) {
        out.append("/**\n");
        this.pushIndent();
        for (String line : code.split("\\r?\\n")) {
            this.appendIndent(out);
            out.append(line);
            out.append("\n");
        }
        this.popIndent();
        this.appendIndent(out);
        out.append("*/\n");
    }

    private void appendAsInlineComment(StringBuilder out, String code) {
        out.append("/* ");
        out.append(code);
        out.append(" */");
    }

    private String genTabSpaces(int x) {
        StringBuilder tab = new StringBuilder();
        while (x > 0) {
            tab.append(" ");
            --x;
        }
        return tab.toString();
    }

    private String operatorName(JCTree.Tag tag) {
        switch (tag) {
            case POS: {
                return "+";
            }
            case NEG: {
                return "-";
            }
            case NOT: {
                return "!";
            }
            case COMPL: {
                return "~";
            }
            case PREINC: {
                return "++";
            }
            case PREDEC: {
                return "--";
            }
            case POSTINC: {
                return "++";
            }
            case POSTDEC: {
                return "--";
            }
            case NULLCHK: {
                return "<*nullchk*>";
            }
            case OR: {
                return "||";
            }
            case AND: {
                return "&&";
            }
            case BITOR: {
                return "|";
            }
            case BITXOR: {
                return "^";
            }
            case BITAND: {
                return "&";
            }
            case EQ: {
                return "==";
            }
            case NE: {
                return "!=";
            }
            case LT: {
                return "<";
            }
            case GT: {
                return ">";
            }
            case LE: {
                return "<=";
            }
            case GE: {
                return ">=";
            }
            case SL: {
                return "<<";
            }
            case SR: {
                return ">>";
            }
            case USR: {
                return ">>>";
            }
            case PLUS: {
                return "+";
            }
            case MINUS: {
                return "-";
            }
            case MUL: {
                return "*";
            }
            case DIV: {
                return "/";
            }
            case MOD: {
                return "%";
            }
            case BITOR_ASG: {
                return "|=";
            }
            case BITXOR_ASG: {
                return "^=";
            }
            case BITAND_ASG: {
                return "&=";
            }
            case SL_ASG: {
                return "<<=";
            }
            case SR_ASG: {
                return ">>=";
            }
            case USR_ASG: {
                return ">>>=";
            }
            case PLUS_ASG: {
                return "+=";
            }
            case MINUS_ASG: {
                return "-=";
            }
            case MUL_ASG: {
                return "*=";
            }
            case DIV_ASG: {
                return "/=";
            }
            case MOD_ASG: {
                return "%=";
            }
        }
        throw new Error();
    }

    private static enum Mode {
        NORMAL,
        USING_NO_MODIFIERS,
        CATCH_PARAM,
        USING_CAST,
        METHOD_PARAM,
        ADD_RESOURCES_FINALLY_BLOCK,
        LAMBDA_PARAM,
        CLASS_VAR;

    }
}

