/*
 * Decompiled with CFR 0.152.
 */
package org.gosulang.plexus.compiler.gosu;

import gw.lang.gosuc.GosucUtil;
import gw.lang.gosuc.simple.ICompilerDriver;
import gw.lang.gosuc.simple.SoutCompilerDriver;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;

public class GosuCompiler
extends AbstractCompiler {
    public GosuCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, "", ".class", null);
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return new String[0];
    }

    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        String[] sourceFiles;
        if (config.isFork()) {
            throw new CompilerException("This compiler does not support forked compilation.");
        }
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = GosuCompiler.getSourceFiles((CompilerConfiguration)config)) == null || sourceFiles.length == 0) {
            return new CompilerResult().success(true);
        }
        if (this.getLogger() != null && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Compiling " + sourceFiles.length + " source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        }
        CompilerResult result = this.compileInProcess(config);
        return result;
    }

    CompilerResult compileInProcess(CompilerConfiguration config) throws CompilerException {
        return this.compileInProcess(new String[0], config);
    }

    CompilerResult compileInProcess(String[] args, CompilerConfiguration config) throws CompilerException {
        SoutCompilerDriver driver = new SoutCompilerDriver();
        gw.lang.gosuc.simple.GosuCompiler gosuc = new gw.lang.gosuc.simple.GosuCompiler();
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.addAll(config.getClasspathEntries());
        classpath.addAll(GosucUtil.getJreJars());
        classpath.addAll(this.getGosuJars());
        gosuc.initializeGosu(config.getSourceLocations(), classpath, config.getOutputLocation());
        for (File file : config.getSourceFiles()) {
            try {
                gosuc.compile(file, (ICompilerDriver)driver);
            }
            catch (Exception e) {
                this.getLogger().error(e.getMessage());
            }
        }
        gosuc.unitializeGosu();
        boolean success = true;
        ArrayList<CompilerMessage> errorMessages = new ArrayList<CompilerMessage>();
        for (String warningMsg : driver.getWarnings()) {
            errorMessages.add(new CompilerMessage(warningMsg, CompilerMessage.Kind.WARNING));
        }
        if (driver.hasErrors()) {
            success = false;
            for (String errorMsg : driver.getErrors()) {
                errorMessages.add(new CompilerMessage(errorMsg, CompilerMessage.Kind.ERROR));
            }
        }
        return new CompilerResult(success, errorMessages);
    }

    private List<String> getGosuJars() throws CompilerException {
        this.getLogger().info("Adding Gosu JARs to compiler classpath");
        return Arrays.asList(this.getClassLocation("gw.internal.gosu.parser.MetaType"), this.getClassLocation("gw.lang.Gosu"));
    }

    private String getClassLocation(String className) throws CompilerException {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new CompilerException("Cannot find the requested className <" + className + "> in classpath.  Please add Gosu as a project dependency.");
        }
        ProtectionDomain pDomain = clazz.getProtectionDomain();
        CodeSource cSource = pDomain.getCodeSource();
        if (cSource != null) {
            File file;
            URL loc = cSource.getLocation();
            try {
                file = new File(URLDecoder.decode(loc.getPath(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                this.getLogger().warn("Unsupported Encoding for URL: " + loc, (Throwable)e);
                file = new File(loc.getPath());
            }
            this.getLogger().debug("Found location <" + file.getPath() + "> for className <" + className + ">");
            return file.getPath();
        }
        throw new CompilerException("Cannot find the location of the requested className <" + className + "> in classpath.  Please add Gosu as a project dependency.");
    }
}

