/*
 * Decompiled with CFR 0.152.
 */
package org.gosulang.plexus.compiler.gosu;

import gw.lang.gosuc.GosucUtil;
import gw.lang.gosuc.cli.CommandLineCompiler;
import gw.lang.gosuc.simple.ICompilerDriver;
import gw.lang.gosuc.simple.SoutCompilerDriver;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GosuCompiler
extends AbstractCompiler {
    public GosuCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, "", ".class", null);
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return new String[0];
    }

    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        CompilerResult result;
        String[] sourceFiles;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = GosuCompiler.getSourceFiles((CompilerConfiguration)config)) == null || sourceFiles.length == 0) {
            return new CompilerResult();
        }
        if (this.getLogger() != null && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Compiling " + sourceFiles.length + " source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        }
        if (config.isFork()) {
            String executable = config.getExecutable();
            if (StringUtils.isEmpty((String)executable)) {
                try {
                    executable = this.getJavaExecutable();
                }
                catch (IOException e) {
                    this.getLogger().warn("Unable to autodetect 'java' path, using 'java' from the environment.");
                    executable = "java";
                }
            }
            config.setExecutable(executable);
            result = this.compileOutOfProcess(config);
        } else {
            result = this.compileInProcess(config);
        }
        return result;
    }

    CompilerResult compileInProcess(CompilerConfiguration config) throws CompilerException {
        return this.compileInProcess(new String[0], config);
    }

    CompilerResult compileInProcess(String[] args, CompilerConfiguration config) throws CompilerException {
        SoutCompilerDriver driver = new SoutCompilerDriver();
        gw.lang.gosuc.simple.GosuCompiler gosuc = new gw.lang.gosuc.simple.GosuCompiler();
        ArrayList classpath = new ArrayList();
        classpath.addAll(config.getClasspathEntries());
        classpath.addAll(GosucUtil.getJreJars());
        try {
            this.getLogger().info("Adding Gosu JARs to compiler classpath");
            classpath.addAll(GosucUtil.getGosuBootstrapJars());
        }
        catch (ClassNotFoundException cnfe) {
            throw new CompilerException("Unable to locate Gosu libraries in classpath.  Please add Gosu as a project dependency.", (Throwable)cnfe);
        }
        gosuc.initializeGosu(config.getSourceLocations(), classpath, config.getOutputLocation());
        for (File file : config.getSourceFiles()) {
            try {
                gosuc.compile(file, (ICompilerDriver)driver);
            }
            catch (Exception e) {
                this.getLogger().error(e.getMessage());
            }
        }
        gosuc.unitializeGosu();
        boolean success = true;
        ArrayList<CompilerMessage> errorMessages = new ArrayList<CompilerMessage>();
        for (String warningMsg : driver.getWarnings()) {
            errorMessages.add(new CompilerMessage(warningMsg, CompilerMessage.Kind.WARNING));
        }
        if (driver.hasErrors()) {
            success = false;
            for (String errorMsg : driver.getErrors()) {
                errorMessages.add(new CompilerMessage(errorMsg, CompilerMessage.Kind.ERROR));
            }
        }
        return new CompilerResult(success, errorMessages);
    }

    CompilerResult compileOutOfProcess(CompilerConfiguration config) throws CompilerException {
        int exitCode;
        Set compilerArgs;
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(config.getWorkingDirectory().getAbsolutePath());
        cli.setExecutable(config.getExecutable());
        String JAVA_OPTS = System.getenv("JAVA_OPTS");
        if (JAVA_OPTS != null) {
            cli.addArguments(new String[]{JAVA_OPTS});
        }
        if (!StringUtils.isEmpty((String)config.getMeminitial())) {
            cli.addArguments(new String[]{"-Xms".concat(config.getMeminitial())});
        }
        if (!StringUtils.isEmpty((String)config.getMaxmem())) {
            cli.addArguments(new String[]{"-Xmx".concat(config.getMaxmem())});
        }
        if ((compilerArgs = config.getCustomCompilerArgumentsAsMap().keySet()).size() > 0) {
            cli.addArguments(compilerArgs.toArray(new String[compilerArgs.size()]));
        }
        if (Os.isFamily((String)"mac")) {
            cli.addArguments(new String[]{"-Xdock:name=Gosuc"});
        }
        try {
            this.getLogger().info("Initializing gosuc compiler");
            cli.addArguments(new String[]{"-classpath", String.join((CharSequence)File.pathSeparator, GosucUtil.getGosuBootstrapJars())});
        }
        catch (ClassNotFoundException cnfe) {
            throw new CompilerException("Unable to locate Gosu libraries in classpath.  Please add Gosu as a project dependency.", (Throwable)cnfe);
        }
        cli.addArguments(new String[]{"gw.lang.gosuc.cli.CommandLineCompiler"});
        try {
            File argFile = this.createArgFile(config);
            cli.addArguments(new String[]{"@" + argFile.getCanonicalPath().replace(File.separatorChar, '/')});
        }
        catch (IOException e) {
            throw new CompilerException("Error creating argfile with gosuc arguments", (Throwable)e);
        }
        CommandLineUtils.StringStreamConsumer sysout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer syserr = new CommandLineUtils.StringStreamConsumer();
        try {
            if (config.isVerbose()) {
                this.getLogger().info("Executing gosuc in external process with command: " + cli.toString());
            }
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)sysout, (StreamConsumer)syserr);
        }
        catch (CommandLineException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        List<CompilerMessage> messages = this.parseMessages(exitCode, sysout.getOutput());
        int warningCt = 0;
        int errorCt = 0;
        for (CompilerMessage message : messages) {
            switch (message.getKind()) {
                case WARNING: {
                    ++warningCt;
                    break;
                }
                case ERROR: {
                    ++errorCt;
                }
            }
        }
        if (config.isShowWarnings()) {
            this.getLogger().info(String.format("gosuc completed with %d warnings and %d errors.", warningCt, errorCt));
        } else {
            this.getLogger().info(String.format("gosuc completed with %d errors. Warnings were disabled.", errorCt));
        }
        return new CompilerResult(exitCode == 0, messages);
    }

    private File createArgFile(CompilerConfiguration config) throws IOException {
        File tempFile;
        if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
            tempFile = File.createTempFile(CommandLineCompiler.class.getName(), "arguments", new File(config.getOutputLocation()));
        } else {
            tempFile = File.createTempFile(CommandLineCompiler.class.getName(), "arguments");
            tempFile.deleteOnExit();
        }
        ArrayList<String> fileOutput = new ArrayList<String>();
        fileOutput.add("-classpath");
        fileOutput.add(String.join((CharSequence)File.pathSeparator, config.getClasspathEntries()));
        fileOutput.add("-d");
        fileOutput.add(config.getOutputLocation());
        fileOutput.add("-sourcepath");
        fileOutput.add(String.join((CharSequence)File.pathSeparator, config.getSourceLocations()));
        if (!config.isShowWarnings()) {
            fileOutput.add("-nowarn");
        }
        if (config.isVerbose()) {
            fileOutput.add("-verbose");
        }
        for (File sourceFile : config.getSourceFiles()) {
            fileOutput.add(sourceFile.getPath());
        }
        Files.write(tempFile.toPath(), fileOutput, StandardCharsets.UTF_8, new OpenOption[0]);
        return tempFile;
    }

    private List<CompilerMessage> parseMessages(int exitCode, String sysout) {
        ArrayList<CompilerMessage> messages = new ArrayList<CompilerMessage>();
        String soutPattern = "^.*:\\[\\d+,\\d+\\]\\s(warning|error):(?:.*\\n)?.*\\[line:\\d+\\scol:\\d+\\]\\sin$\\n(?:^line\\s+\\d+:.*\\n){1,3}";
        Pattern regex = Pattern.compile("^.*:\\[\\d+,\\d+\\]\\s(warning|error):(?:.*\\n)?.*\\[line:\\d+\\scol:\\d+\\]\\sin$\\n(?:^line\\s+\\d+:.*\\n){1,3}", 8);
        Matcher regexMatcher = regex.matcher(sysout);
        while (regexMatcher.find()) {
            CompilerMessage.Kind kind = regexMatcher.group(1).equals("warning") ? CompilerMessage.Kind.WARNING : CompilerMessage.Kind.ERROR;
            messages.add(new CompilerMessage(regexMatcher.group(), kind));
        }
        return messages;
    }

    private String getJavaExecutable() throws IOException {
        String javaCommand = "java" + (Os.isFamily((String)"windows") ? ".exe" : "");
        String javaHome = System.getProperty("java.home");
        File javaExe = Os.isName((String)"AIX") ? new File(javaHome + File.separator + ".." + File.separator + "sh", javaCommand) : (Os.isName((String)"Mac OS X") ? new File(javaHome + File.separator + "bin", javaCommand) : new File(javaHome + File.separator + ".." + File.separator + "bin", javaCommand));
        if (!javaExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).isDirectory()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            javaExe = new File(env.getProperty("JAVA_HOME") + File.separator + "bin", javaCommand);
        }
        if (!javaExe.isFile()) {
            throw new IOException("The java executable '" + javaExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return javaExe.getAbsolutePath();
    }
}

