/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import gw.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class ShellProcess {
    private Process _javaProcess;
    private PrintWriter _stdin;

    ShellProcess(Process javaProcess) {
        this._javaProcess = javaProcess;
        this._stdin = new PrintWriter(StreamUtil.getOutputStreamWriter((OutputStream)this._javaProcess.getOutputStream()));
    }

    public String readLine() {
        return this.readUntil(System.getProperty("line.separator"), false);
    }

    public String readUntil(String character, boolean includeDeliminator) {
        return this.readStreamUntil(this._javaProcess.getInputStream(), includeDeliminator, character.toCharArray());
    }

    public String readChar() {
        try {
            int value = this._javaProcess.getInputStream().read();
            return value == -1 ? "" : String.valueOf((char)value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String readStderrLine() {
        return this.readStderrUntil('\n', false);
    }

    public String readStderrUntil(char character, boolean includeDeliminator) {
        return this.readStreamUntil(this._javaProcess.getErrorStream(), includeDeliminator, character);
    }

    public void write(String text) {
        this._stdin.write(text);
        this._stdin.flush();
    }

    public void closeStdout() {
        try {
            this._javaProcess.getInputStream().close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void closeStderr() {
        try {
            this._javaProcess.getErrorStream().close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void closeStdin() {
        try {
            this._javaProcess.getOutputStream().close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int waitFor() throws InterruptedException {
        return this._javaProcess.waitFor();
    }

    public int exitValue() {
        return this._javaProcess.exitValue();
    }

    public boolean getIsDone() {
        try {
            this.exitValue();
            return true;
        }
        catch (IllegalThreadStateException ex) {
            return false;
        }
    }

    public void destroy() {
        this._javaProcess.destroy();
    }

    private String readStreamUntil(InputStream stream, boolean includeDelim, char ... character) {
        int bufPos = 0;
        try {
            int val;
            StringBuilder sb = new StringBuilder();
            while ((val = stream.read()) != -1) {
                char ch = (char)val;
                bufPos = ch == character[bufPos] ? ++bufPos : 0;
                sb.append(ch);
                if (bufPos < character.length) continue;
                if (includeDelim) break;
                sb.setLength(sb.length() - character.length);
                break;
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

