/*
 * Decompiled with CFR 0.152.
 */
package gw.util.process;

import gw.util.OSPlatform;
import gw.util.StreamUtil;
import gw.util.process.ChainedOutputHandler;
import gw.util.process.EchoOutputEmitter;
import gw.util.process.Gobbler;
import gw.util.process.OutputBuffer;
import gw.util.process.OutputHandler;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessRunner {
    private final List<String> _rawCmd = new ArrayList<String>();
    private OutputBuffer _buffer = null;
    private Integer _exitCode = null;
    private boolean _withCMD;
    private File _workingDirectory;
    private Map<String, String> _env = new HashMap<String, String>();
    private boolean _echo;
    private String _input;
    private boolean _bufferStdOut;
    private boolean _bufferStdErr;
    private List<OutputHandler> _stdOutHandlers = new ArrayList<OutputHandler>();
    private List<OutputHandler> _stdErrHandlers = new ArrayList<OutputHandler>();
    private String _charset = "UTF-8";

    public static String execWithCharset(String charset, String ... command) {
        return new ProcessRunner(command).withStdOutBuffered().withCharset(charset).withCMD().exec().getBuffer();
    }

    public static String exec(String ... command) {
        return new ProcessRunner(command).withStdOutBuffered().withCMD().exec().getBuffer();
    }

    public ProcessRunner(String ... command) {
        this(Arrays.asList(command));
    }

    public ProcessRunner(List<String> command) {
        for (String elt : command) {
            this._rawCmd.add(elt);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProcessRunner exec() {
        ArrayList<String> command = new ArrayList<String>();
        if (OSPlatform.isWindows() && this._withCMD) {
            command.add("CMD.EXE");
            command.add("/C");
        }
        command.addAll(this._rawCmd);
        ProcessBuilder pb = new ProcessBuilder(command);
        if (this._workingDirectory != null) {
            pb.directory(this._workingDirectory);
        }
        for (Map.Entry<String, String> entry : this._env.entrySet()) {
            if (entry.getValue() != null) {
                pb.environment().put(entry.getKey(), entry.getValue());
                continue;
            }
            pb.environment().remove(entry.getKey());
        }
        ChainedOutputHandler stdOut = new ChainedOutputHandler();
        ChainedOutputHandler stdErr = new ChainedOutputHandler();
        if (this._bufferStdOut || this._bufferStdErr) {
            this._buffer = new OutputBuffer();
            if (this._bufferStdOut) {
                stdOut.add(this._buffer);
            }
            if (this._bufferStdErr) {
                stdErr.add(this._buffer);
            }
        }
        EchoOutputEmitter echo = null;
        if (this._echo) {
            echo = new EchoOutputEmitter(this.getRawCmdStr(), System.out, System.err);
            stdOut.add(echo.getStdOutHandler());
            stdErr.add(echo.getStdErrHandler());
        }
        for (OutputHandler handler : this._stdOutHandlers) {
            stdOut.add(handler);
        }
        for (OutputHandler handler : this._stdErrHandlers) {
            stdErr.add(handler);
        }
        try {
            Process process = pb.start();
            ProcessRunner.feedInput(process, this._input, this._charset);
            if (echo != null) {
                echo.processStarted();
            }
            this._exitCode = ProcessRunner.nomNomNom(process, stdOut.maybeReduce(), stdErr.maybeReduce(), this._charset);
            if (echo != null) {
                echo.processFinished();
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                try {
                    StreamUtil.close((Closeable[])new Closeable[]{stdOut, stdErr});
                    throw throwable;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            StreamUtil.close((Closeable[])new Closeable[]{stdOut, stdErr});
            return this;
        }
        catch (IOException e) {
            e.printStackTrace();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void feedInput(Process process, String input, String charset) throws IOException {
        OutputStreamWriter inputEmitter;
        block6: {
            inputEmitter = null;
            try {
                if (input == null) break block6;
                inputEmitter = new OutputStreamWriter(process.getOutputStream(), charset);
                inputEmitter.write(input);
            }
            catch (Throwable throwable) {
                try {
                    StreamUtil.close((Closeable[])new Closeable[]{inputEmitter});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            StreamUtil.close((Closeable[])new Closeable[]{inputEmitter});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Integer nomNomNom(Process process, OutputHandler stdOut, OutputHandler stdErr, String charset) {
        Gobbler outputGobbler = new Gobbler(process.getInputStream(), stdOut, charset);
        Gobbler errorGobbler = new Gobbler(process.getErrorStream(), stdErr, charset);
        errorGobbler.start();
        outputGobbler.start();
        int exitCode2333333332 = process.waitFor();
        errorGobbler.join();
        outputGobbler.join();
        Integer n = exitCode2333333332;
        try {
            StreamUtil.close((Closeable[])new Closeable[]{process.getErrorStream(), process.getInputStream()});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return n;
        catch (InterruptedException exitCode2333333332) {
            try {
                StreamUtil.close((Closeable[])new Closeable[]{process.getErrorStream(), process.getInputStream()});
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                try {
                    StreamUtil.close((Closeable[])new Closeable[]{process.getErrorStream(), process.getInputStream()});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
        return null;
    }

    public String getRawCmdStr() {
        StringBuilder rawCmdStr = new StringBuilder();
        for (String item : this._rawCmd) {
            if (rawCmdStr.length() > 0) {
                rawCmdStr.append(' ');
            }
            if (item.contains(" ")) {
                rawCmdStr.append('\"').append(item).append('\"');
                continue;
            }
            rawCmdStr.append(item);
        }
        return rawCmdStr.toString();
    }

    public String getBuffer() {
        return this._buffer == null ? null : this._buffer.toString();
    }

    public Integer getExitCode() {
        return this._exitCode;
    }

    public ProcessRunner withWorkingDirectory(File dir) {
        this._workingDirectory = dir;
        return this;
    }

    public ProcessRunner withArg(String arg) {
        this._rawCmd.add(arg);
        return this;
    }

    public ProcessRunner withEnvironmentVariable(String name, String value) {
        this._env.put(name, value);
        return this;
    }

    public ProcessRunner withCharset(String cs) {
        this._charset = cs;
        return this;
    }

    public ProcessRunner withStdOutBuffered() {
        this._bufferStdOut = true;
        return this;
    }

    public ProcessRunner withStdErrBuffered() {
        this._bufferStdErr = true;
        return this;
    }

    public ProcessRunner withEcho() {
        this._echo = true;
        return this;
    }

    public ProcessRunner input(String input) {
        this._input = input;
        return this;
    }

    public ProcessRunner withCMD() {
        this._withCMD = true;
        return this;
    }

    public ProcessRunner withStdErrHandler(OutputHandler stdErrHandler) {
        this._stdErrHandlers.add(stdErrHandler);
        return this;
    }

    public ProcessRunner withStdOutHandler(OutputHandler stdOutHandler) {
        this._stdOutHandlers.add(stdOutHandler);
        return this;
    }
}

