/*
 * Decompiled with CFR 0.152.
 */
package gw.test;

import gw.lang.UnstableAPI;
import gw.util.GosuStringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@UnstableAPI
public class ClassPathUtil {
    public static List<File> constructClasspathFromSystemClasspath() {
        String systemClasspath = System.getProperty("java.class.path");
        String[] pathComponents = GosuStringUtil.split((String)systemClasspath, (char)File.pathSeparatorChar);
        ArrayList<File> classpathComponents = new ArrayList<File>();
        for (String pathComponent : pathComponents) {
            File f = new File(pathComponent);
            if (ClassPathUtil.isChildOf(f, "jre", "lib") || ClassPathUtil.isChildOf(f, "jre", "lib", "ext")) continue;
            classpathComponents.add(f);
        }
        return classpathComponents;
    }

    private static boolean isChildOf(File f, String ... parentDirs) {
        File parent = f.getParentFile();
        for (int i = parentDirs.length - 1; i >= 0; --i) {
            if (parent == null) {
                return false;
            }
            if (!parent.getName().equals(parentDirs[i])) {
                return false;
            }
            parent = parent.getParentFile();
        }
        return true;
    }
}

