/*
 * Decompiled with CFR 0.152.
 */
package gw.test;

import gw.internal.ext.org.objectweb.asm.ClassReader;
import gw.internal.ext.org.objectweb.asm.ClassVisitor;
import gw.internal.ext.org.objectweb.asm.tree.AbstractInsnNode;
import gw.internal.ext.org.objectweb.asm.tree.ClassNode;
import gw.internal.ext.org.objectweb.asm.tree.LineNumberNode;
import gw.internal.ext.org.objectweb.asm.tree.MethodNode;
import gw.util.StreamUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestClassHelper {
    private static final Map<Class<?>, List<MethodNode>> cache = new ConcurrentHashMap();

    public static <T extends TestCase> List<MethodNode> getMethodsSorted(Class<T> clazz) {
        List<MethodNode> allMethods = cache.get(clazz);
        if (allMethods != null) {
            return allMethods;
        }
        ClassNode javaClass = TestClassHelper.parseClass(clazz);
        if (javaClass == null) {
            return Collections.emptyList();
        }
        List currentClassMethods = javaClass.methods;
        Collections.sort(currentClassMethods, new Comparator<MethodNode>(){

            @Override
            public int compare(MethodNode o1, MethodNode o2) {
                return TestClassHelper.getLineNumber(o1) - TestClassHelper.getLineNumber(o2);
            }
        });
        allMethods = new ArrayList<MethodNode>();
        Class<T> superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.getClass().equals(TestCase.class)) {
            allMethods.addAll(TestClassHelper.getMethodsSorted(superclass));
        }
        allMethods.addAll(currentClassMethods);
        cache.put(clazz, Collections.unmodifiableList(new ArrayList<MethodNode>(allMethods)));
        return allMethods;
    }

    private static int getLineNumber(MethodNode o2) {
        for (AbstractInsnNode next : o2.instructions) {
            if (!(next instanceof LineNumberNode)) continue;
            return ((LineNumberNode)next).line;
        }
        return -1;
    }

    private static ClassNode parseClass(Class<?> clazz) {
        String pathToClassFile = "/" + clazz.getName().replace('.', '/') + ".class";
        InputStream resourceAsStream = clazz.getResourceAsStream(pathToClassFile);
        if (resourceAsStream == null) {
            return null;
        }
        try {
            ClassNode jclass = new ClassNode(327680);
            ClassReader cr = new ClassReader(resourceAsStream);
            cr.accept((ClassVisitor)jclass, 0);
            ClassNode classNode = jclass;
            return classNode;
        }
        catch (IOException e) {
            throw new RuntimeException("Error during analyzing byte code of the class " + clazz.getName(), e);
        }
        finally {
            StreamUtil.closeNoThrow((Closeable)resourceAsStream);
        }
    }

    public static <T extends TestCase> Test createTestSuite(Class<T> clazz, Iterable<String> methodNames) {
        try {
            Constructor<T> constructor = TestClassHelper.getConstructor(clazz);
            TestSuite newSuite = new TestSuite();
            for (String name : methodNames) {
                TestCase test;
                if (constructor.getParameterTypes().length == 0) {
                    test = (TestCase)constructor.newInstance(new Object[0]);
                    test.setName(name);
                } else {
                    test = (TestCase)constructor.newInstance(name);
                }
                newSuite.addTest((Test)test);
            }
            return newSuite;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot instantiate test class " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(clazz.getName() + " constructor is not accessible", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(clazz.getName() + "(String name) constructor threw an exception", e);
        }
    }

    private static <T extends TestCase> Constructor<T> getConstructor(Class<T> clazz) {
        Constructor<T> constructor;
        try {
            constructor = clazz.getConstructor(String.class);
            if (Modifier.isPublic(constructor.getModifiers())) {
                return constructor;
            }
        }
        catch (NoSuchMethodException constructor2) {
            // empty catch block
        }
        try {
            constructor = clazz.getConstructor(new Class[0]);
            if (Modifier.isPublic(constructor.getModifiers())) {
                return constructor;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new RuntimeException("Did not find public " + clazz.getName() + "(String name) or " + clazz.getName() + "() constructor");
    }
}

