/*
 * Decompiled with CFR 0.152.
 */
package gw.test;

import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.test.BaseRemoteTestClass;
import gw.test.IForwardingTestEnvironment;
import gw.test.IRemoteTestClassIDEExecutionWrapper;
import gw.test.TestClass;
import gw.test.TestEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public class TestExecutionManager {
    private TestEnvironment _environment;
    private boolean _beforeTestSuiteRun = false;
    private boolean _typeSystemInitialized = false;
    private Throwable _beforeTestSuiteFailed;
    private Map<String, Throwable> _beforeTestClassFailed = new HashMap<String, Throwable>();
    private final Map<String, TestInfo> _testInfos = new HashMap<String, TestInfo>();
    private List<TestSuite> _testWrappers;
    private long _suiteStartTime = 0L;
    private long _suiteTimeoutInMillis = 0L;
    private boolean _suiteHasTimedOut = false;
    private boolean _assertionsMustBeEnabled = true;
    private long _testClassStartTime = 0L;
    private long _suiteStartTimeNs = 0L;
    private static boolean INCLUDE_TEST_TIMING_INFO = Boolean.getBoolean("gw.test.timing.info");

    public void setEnvironment(TestEnvironment environment) {
        this._environment = environment;
    }

    public void setTestsFromSuite(List<TestSuite> testWrappers) {
        for (TestSuite suite : testWrappers) {
            this._testInfos.put(suite.getName(), new TestInfo(suite.countTestCases()));
        }
        this._testWrappers = new ArrayList<TestSuite>(testWrappers);
    }

    public void setSuiteTimeoutInMillis(long suiteTimeoutInMillis) {
        this._suiteTimeoutInMillis = suiteTimeoutInMillis;
    }

    public boolean assertionsMustBeEnabled() {
        return this._assertionsMustBeEnabled;
    }

    public void setAssertionsMustBeEnabled(boolean assertionsMustBeEnabled) {
        this._assertionsMustBeEnabled = assertionsMustBeEnabled;
    }

    public TestEnvironment getEnvironment() {
        return this._environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTestClass(TestClass testClass, TestResult result) {
        if (this._suiteStartTime == 0L) {
            this._suiteStartTime = System.currentTimeMillis();
        }
        if (this._suiteStartTimeNs == 0L) {
            this._suiteStartTimeNs = System.nanoTime();
        }
        if (this._environment.isRemoteExecutionEnvironment() && !(testClass instanceof BaseRemoteTestClass)) {
            TestInfo testInfo = this._testInfos.get(testClass.getTypeName());
            if (testInfo == null) {
                testInfo = new TestInfo(TestClass.getNumberOfInstancesOfTestClassCreated(testClass.getTypeName()));
                this._testInfos.put(testClass.getTypeName(), testInfo);
            }
            testClass = ((IForwardingTestEnvironment)((Object)this._environment)).makeRemoteTestClassIDEExecutionWrapper(testClass.getTypeName(), testClass.getName(), testInfo._testCount, this, testClass);
        }
        try {
            this.maybeInitTypeSystem();
            long testStartTimeNs = -1L;
            try {
                try {
                    this.maybeCallBeforeTestSuite();
                }
                catch (Throwable e) {
                    result.startTest((Test)this.maybeUnwrapTestClass(testClass));
                    if (this._beforeTestSuiteFailed != null) {
                        this._beforeTestSuiteFailed = e;
                    }
                    result.addError((Test)testClass, e);
                    result.endTest((Test)testClass);
                    throw e;
                }
                try {
                    this.maybeCallBeforeTestClass(testClass);
                }
                catch (Throwable e) {
                    result.startTest((Test)this.maybeUnwrapTestClass(testClass));
                    if (!this._beforeTestClassFailed.containsKey(testClass.getTypeName())) {
                        this._beforeTestClassFailed.put(testClass.getTypeName(), e);
                    }
                    result.addError((Test)testClass, e);
                    result.endTest((Test)testClass);
                    throw e;
                }
                testStartTimeNs = System.nanoTime();
                testClass.reallyRun(result);
            }
            finally {
                if (testStartTimeNs != -1L) {
                    this.printTestRunTime("Method " + testClass.getTypeName() + " " + testClass.getName(), System.nanoTime() - testStartTimeNs);
                }
                try {
                    this.maybeCallAfterTestClass(testClass);
                }
                finally {
                    this.maybeCallAfterTestSuite(testClass);
                }
            }
        }
        catch (AssertionFailedError e) {
            result.addFailure((Test)this.maybeUnwrapTestClass(testClass), e);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            result.addError((Test)this.maybeUnwrapTestClass(testClass), e);
        }
    }

    protected TestClass maybeUnwrapTestClass(TestClass testClass) {
        if (testClass instanceof IRemoteTestClassIDEExecutionWrapper) {
            return ((IRemoteTestClassIDEExecutionWrapper)((Object)testClass)).getWrapped();
        }
        return testClass;
    }

    protected void runTestClassBare(TestClass testClass) throws Throwable {
        this.callBeforeTestMethod(testClass);
        try {
            testClass.reallyRunBare();
        }
        catch (Throwable e) {
            this.callAfterTestMethod(testClass, e);
            throw e;
        }
        this.callAfterTestMethod(testClass, null);
    }

    public void maybeInitTypeSystem() {
        if (!this._typeSystemInitialized) {
            this._typeSystemInitialized = true;
            this._environment.initializeTypeSystem();
        }
    }

    private void callAfterTestMethod(TestClass testClass, Throwable e) {
        testClass.afterTestMethod(e);
        this._environment.afterTestMethod();
    }

    private void callBeforeTestMethod(TestClass testClass) {
        this._environment.beforeTestMethod();
        testClass.beforeTestMethod();
    }

    private void maybeCallBeforeTestSuite() {
        if (this._beforeTestSuiteFailed != null) {
            throw new RuntimeException("beforeTestSuite() failed on a previous test", this._beforeTestSuiteFailed);
        }
        if (!this._beforeTestSuiteRun) {
            this._beforeTestSuiteRun = true;
            this._environment.beforeTestSuite();
        }
    }

    public final boolean runViaStaticSuiteMethod() {
        IType iType = TypeSystem.getTypeFromObject((Object)this);
        IMethodInfo method = iType.getTypeInfo().getMethod((CharSequence)"suite", new IType[0]);
        Test test = (Test)method.getCallHandler().handleCall(null, new Object[0]);
        return this.runImpl(test).wasSuccessful();
    }

    private Result runImpl(Test test) {
        JUnitCore runner = new JUnitCore();
        TextListener txtListener = new TextListener(System.out);
        runner.addListener((RunListener)txtListener);
        return runner.run(test);
    }

    private void maybeCallBeforeTestClass(TestClass testClass) {
        if (this._beforeTestClassFailed.containsKey(testClass.getTypeName())) {
            throw new RuntimeException("beforeTestClass() failed on a previous test of test class " + testClass.getTypeName(), this._beforeTestClassFailed.get(testClass.getTypeName()));
        }
        TestInfo testInfo = this._testInfos.get(testClass.getTypeName());
        if (testInfo == null) {
            Integer testsCount = TestClass.getNumberOfInstancesOfTestClassCreated(testClass.getTypeName());
            testInfo = new TestInfo(testsCount);
            this._testInfos.put(testClass.getTypeName(), testInfo);
        }
        if (testInfo._testsRun == 0) {
            this._testClassStartTime = System.nanoTime();
            this._environment.beforeTestClass();
            testClass.beforeTestClass();
        }
        ++testInfo._testsRun;
    }

    private void maybeCallAfterTestClass(TestClass testClass) {
        TestInfo testInfo = this._testInfos.get(testClass.getTypeName());
        if (testInfo != null && testInfo.isAtLastTest()) {
            testClass.afterTestClass();
            this._environment.afterTestClass();
            this.printTestRunTime("Class " + testClass.getTypeName(), System.nanoTime() - this._testClassStartTime);
        }
    }

    private void maybeCallAfterTestSuite(TestClass test) {
        TestInfo testInfo = this._testInfos.get(test.getTypeName());
        if (testInfo != null && testInfo.isAtLastTest() && this.isLastTestInSuite(test)) {
            this._environment.afterTestSuite();
            this.printTestRunTime("Suite", System.nanoTime() - this._suiteStartTimeNs);
        }
    }

    private void printTestRunTime(String msg, long nanoTime) {
        if (INCLUDE_TEST_TIMING_INFO) {
            System.out.println("***** TestRunTime [" + msg + "] " + nanoTime + " *****");
        }
    }

    private boolean isLastTestInSuite(TestClass test) {
        boolean isLastTestInSuite = false;
        if (this._testWrappers == null) {
            isLastTestInSuite = true;
        } else if (this._testWrappers.size() > 0) {
            String testTypeName = test.getTypeName();
            String testClassName = test.getClass().getName();
            String testWrapperName = this._testWrappers.get(this._testWrappers.size() - 1).getName();
            isLastTestInSuite = testTypeName.equals(testWrapperName) || testClassName.equals(testWrapperName);
        }
        return isLastTestInSuite;
    }

    public final boolean hasTimeOut() {
        return this._suiteTimeoutInMillis != 0L;
    }

    public final long getTimeoutForCurrentTest() {
        long timeSoFar = System.currentTimeMillis() - this._suiteStartTime;
        return Math.max(1L, this._suiteTimeoutInMillis - timeSoFar);
    }

    final void markTimedOut() {
        this._suiteHasTimedOut = true;
    }

    public final boolean hasTimedOut() {
        return this._suiteHasTimedOut;
    }

    public static class TestInfo {
        public int _testsRun;
        private int _testCount;

        public TestInfo(int testCount) {
            this._testCount = testCount;
        }

        public boolean isAtLastTest() {
            return this._testsRun == this._testCount;
        }
    }
}

