/*
 * Decompiled with CFR 0.152.
 */
package gw.test;

import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.test.ITestMetadata;
import gw.testharness.DoNotRunTest;
import gw.util.GosuObjectUtil;
import gw.xml.simple.SimpleXmlNode;
import java.util.HashMap;
import java.util.Map;

public class TestMetadata
implements ITestMetadata {
    private String _name;
    private HashMap<String, String> _attributes = new HashMap();
    private boolean _doNotRunTest;

    public TestMetadata(IAnnotationInfo testAnnotation) {
        IType annotationType = testAnnotation.getType();
        for (IAnnotationInfo metaAnnotation : annotationType.getTypeInfo().getAnnotations()) {
            if (!metaAnnotation.getType().getName().equals(DoNotRunTest.class.getName())) continue;
            this._doNotRunTest = true;
        }
        for (IMethodInfo method : ((IRelativeTypeInfo)annotationType.getTypeInfo()).getDeclaredMethods()) {
            this.addAttribute(method.getDisplayName(), GosuObjectUtil.toString((Object)testAnnotation.getFieldValue(method.getDisplayName())));
        }
        this._name = annotationType.getName();
    }

    private TestMetadata() {
    }

    @Override
    public String getName() {
        return this._name;
    }

    public boolean equals(Object obj) {
        return obj instanceof TestMetadata && this._name.equals(((TestMetadata)obj).getName());
    }

    public void addAttribute(String name, String value) {
        this._attributes.put(name, value);
    }

    public HashMap<String, String> getAttributes() {
        return this._attributes;
    }

    @Override
    public boolean shouldNotRunTest() {
        return this._doNotRunTest;
    }

    public SimpleXmlNode serializeToXml() {
        SimpleXmlNode root = new SimpleXmlNode("TestMetadata");
        root.getAttributes().put("name", this._name);
        root.getAttributes().put("doNotRunTest", "" + this._doNotRunTest);
        for (Map.Entry<String, String> entry : this._attributes.entrySet()) {
            SimpleXmlNode child = new SimpleXmlNode("Attribute");
            child.getAttributes().put("key", entry.getKey());
            child.getAttributes().put("value", entry.getValue());
            root.getChildren().add(child);
        }
        return root;
    }

    public static TestMetadata deserializeXml(SimpleXmlNode xml) {
        TestMetadata testMD = new TestMetadata();
        testMD._name = (String)xml.getAttributes().get("name");
        testMD._doNotRunTest = Boolean.valueOf((String)xml.getAttributes().get("doNotRunTest"));
        for (SimpleXmlNode child : xml.getChildren()) {
            testMD._attributes.put((String)child.getAttributes().get("key"), (String)child.getAttributes().get("value"));
        }
        return testMD;
    }
}

