/*
 * Decompiled with CFR 0.152.
 */
package gw.testharness;

import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.testharness.IEnvironmentalCondition;
import gw.testharness.KnownBreakCondition;
import gw.util.Predicate;

public class KnownBreakConditionPredicate
implements Predicate<IAnnotationInfo> {
    public boolean evaluate(IAnnotationInfo o) {
        return KnownBreakConditionPredicate.isKnownBreakCondition(o);
    }

    public static boolean isKnownBreakCondition(KnownBreakCondition kbCond) {
        for (Class<? extends IEnvironmentalCondition> conditionClass : kbCond.value()) {
            IEnvironmentalCondition condition;
            try {
                condition = conditionClass.newInstance();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!condition.isConditionMet()) continue;
            return true;
        }
        return false;
    }

    public static boolean isKnownBreakCondition(IAnnotationInfo kbCond) {
        Object[] values = kbCond.getFieldValue("value");
        if (!(values instanceof Object[])) {
            values = new Object[]{values};
        }
        for (Object conditionClass : (Object[])values) {
            IType type = conditionClass instanceof Class ? TypeSystem.get((Class)((Class)conditionClass)) : (IType)conditionClass;
            IEnvironmentalCondition condition = (IEnvironmentalCondition)type.getTypeInfo().getConstructor(new IType[0]).getConstructor().newInstance(new Object[0]);
            if (!condition.isConditionMet()) continue;
            return true;
        }
        return false;
    }
}

