/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import gw.lang.GosuShop;
import gw.lang.parser.ExternalSymbolMapSymbolTableWrapper;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.IExpression;
import gw.lang.parser.IGosuParser;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ParserOptions;
import gw.lang.parser.ScriptabilityModifiers;
import gw.lang.parser.StandardSymbolTable;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.expressions.IProgram;
import gw.lang.parser.resources.ResourceKey;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuProgram;
import gw.test.TestClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.junit.Assert;

public class GosuTestUtil {
    private static final Object[] EMPTY_OBJECT_ARR = new Object[0];

    public static Object eval(String script) {
        try {
            return GosuTestUtil.evalGosu(script);
        }
        catch (ParseResultsException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object eval(String script, String name1, Object val1) {
        try {
            return GosuTestUtil.evalGosu(script, name1, val1);
        }
        catch (ParseResultsException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object evalGosu(String script) throws ParseResultsException {
        return GosuTestUtil.evalGosu(script, EMPTY_OBJECT_ARR);
    }

    public static Object evalGosu(String script, String name1, Object val1) throws ParseResultsException {
        return GosuTestUtil.evalGosu(script, new Object[]{name1, val1});
    }

    public static Object evalGosu(String script, String name1, Object val1, String name2, Object val2) throws ParseResultsException {
        return GosuTestUtil.evalGosu(script, new Object[]{name1, val1, name2, val2});
    }

    public static Object evalGosu(String script, String name1, Object val1, String name2, Object val2, String name3, Object val3) throws ParseResultsException {
        return GosuTestUtil.evalGosu(script, new Object[]{name1, val1, name2, val2, name3, val3});
    }

    public static Object evalGosu(String script, String name1, Object val1, String name2, Object val2, String name3, Object val3, String name4, Object val4) throws ParseResultsException {
        return GosuTestUtil.evalGosu(script, new Object[]{name1, val1, name2, val2, name3, val3, name4, val4});
    }

    public static Object evalGosu(String script, String name1, Object val1, String name2, Object val2, String name3, Object val3, String name4, Object val4, String name5, Object val5) throws ParseResultsException {
        return GosuTestUtil.evalGosu(script, new Object[]{name1, val1, name2, val2, name3, val3, name4, val4, name5, val5});
    }

    public static Object evalGosu(String script, Object[] args) throws ParseResultsException {
        StandardSymbolTable table = new StandardSymbolTable(true);
        assert (args.length % 2 == 0) : "You must pass in an array of matchign name/value pairs";
        for (int i = 0; i < args.length; i += 2) {
            String name = (String)args[i];
            Object arg = args[i + 1];
            assert (arg != null) : "Argument " + name + " is null, so we cannot determine the type for it.  If you wish to actually pass a null value in, construct an ISybmolTable with the null value properly typed and pass it in directly";
            table.putSymbol(GosuShop.createSymbol((CharSequence)name, (IType)TypeSystem.getFromObject((Object)arg), (Object)arg));
        }
        return GosuTestUtil.evalGosu(script, (ISymbolTable)table);
    }

    public static Object evalGosu(String script, ISymbolTable table) throws ParseResultsException {
        IGosuProgram gosuProgram = GosuParserFactory.createProgramParser().parseExpressionOrProgram(script, table, new ParserOptions()).getProgram();
        return gosuProgram.evaluate((IExternalSymbolMap)new ExternalSymbolMapSymbolTableWrapper(table));
    }

    public static IExpression compileExpression(String script) throws ParseResultsException {
        return GosuTestUtil.compileExpression(script, (ISymbolTable)new StandardSymbolTable(true));
    }

    public static IExpression compileExpression(String script, String varName, IType varType) throws ParseResultsException {
        StandardSymbolTable symbolTable = new StandardSymbolTable(true);
        symbolTable.putSymbol(GosuShop.createSymbol((CharSequence)varName, (IType)varType, null));
        return GosuTestUtil.compileExpression(script, (ISymbolTable)symbolTable);
    }

    public static IExpression compileExpression(String script, String varName, IType varType, String varName2, IType varType2) throws ParseResultsException {
        StandardSymbolTable symbolTable = new StandardSymbolTable(true);
        symbolTable.putSymbol(GosuShop.createSymbol((CharSequence)varName, (IType)varType, null));
        symbolTable.putSymbol(GosuShop.createSymbol((CharSequence)varName2, (IType)varType2, null));
        return GosuTestUtil.compileExpression(script, (ISymbolTable)symbolTable);
    }

    public static IExpression compileExpression(String script, ISymbolTable table) throws ParseResultsException {
        IGosuParser parser = GosuParserFactory.createParser((String)script, (ISymbolTable)table, (IScriptabilityModifier)ScriptabilityModifiers.SCRIPTABLE);
        parser.setThrowParseExceptionForWarnings(false);
        return parser.parseExpOrProgram(null);
    }

    public static IExpression compileExpression(String script, ISymbolTable table, boolean bThrowOnWarning) throws ParseResultsException {
        IGosuParser parser = GosuParserFactory.createParser((String)script, (ISymbolTable)table, (IScriptabilityModifier)ScriptabilityModifiers.SCRIPTABLE);
        parser.setThrowParseExceptionForWarnings(bThrowOnWarning);
        return parser.parseExpOrProgram(null);
    }

    public static IExpression compileExpression(String script, boolean bThrowOnWarning) throws ParseResultsException {
        IGosuParser parser = GosuParserFactory.createParser((String)script, (ISymbolTable)new StandardSymbolTable(true), (IScriptabilityModifier)ScriptabilityModifiers.SCRIPTABLE);
        parser.setThrowParseExceptionForWarnings(bThrowOnWarning);
        return parser.parseExpOrProgram(null);
    }

    public static IProgram compileProgram(String script, ISymbolTable table) throws ParseResultsException {
        IGosuParser parser = GosuParserFactory.createParser((String)script, (ISymbolTable)table, (IScriptabilityModifier)ScriptabilityModifiers.SCRIPTABLE);
        parser.setEditorParser(true);
        return parser.parseProgram(null);
    }

    public static void assertHasErrors(String strClass, ResourceKey ... expected) throws ClassNotFoundException {
        GosuTestUtil.assertHasErrors(GosuTestUtil.loadClass(strClass), expected);
    }

    private static IGosuClass loadClass(String strClass) {
        return (IGosuClass)TypeSystem.getByFullName((String)strClass);
    }

    public static void assertHasErrors(IGosuClass gsClass, ResourceKey ... expected) throws ClassNotFoundException {
        Comparator<ResourceKey> resourceKeyComparator = new Comparator<ResourceKey>(){

            @Override
            public int compare(ResourceKey o1, ResourceKey o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        };
        Assert.assertFalse((boolean)gsClass.isValid());
        ArrayList<ResourceKey> actual = new ArrayList<ResourceKey>(expected.length);
        for (IParseIssue parseException : gsClass.getParseResultsException().getParseExceptions()) {
            actual.add(parseException.getMessageKey());
        }
        Arrays.sort(expected, resourceKeyComparator);
        Collections.sort(actual, resourceKeyComparator);
        TestClass.assertCollectionEquals(Arrays.asList(expected), actual);
    }

    public static void assertOneError(String strClass, ResourceKey errorKey) throws ClassNotFoundException {
        GosuTestUtil.assertOneError(GosuTestUtil.loadClass(strClass), errorKey);
    }

    public static void assertOneError(IGosuClass gsClass, ResourceKey errorKey) {
        Assert.assertFalse((boolean)gsClass.isValid());
        Assert.assertEquals((long)1L, (long)gsClass.getParseResultsException().getParseExceptions().size());
        Assert.assertEquals((Object)errorKey, (Object)((IParseIssue)gsClass.getParseResultsException().getParseExceptions().get(0)).getMessageKey());
    }

    public static void assertOneWarning(String strClass, ResourceKey warningKey) throws ClassNotFoundException {
        GosuTestUtil.assertOneWarning(GosuTestUtil.loadClass(strClass), warningKey);
    }

    public static void assertOneWarning(IGosuClass gsClass, ResourceKey warningKey) {
        Assert.assertTrue((boolean)gsClass.isValid());
        Assert.assertEquals((long)1L, (long)gsClass.getParseResultsException().getParseWarnings().size());
        Assert.assertEquals((Object)warningKey, (Object)((IParseIssue)gsClass.getParseResultsException().getParseWarnings().get(0)).getMessageKey());
    }

    public static ParseResultsException getParseResultsException(String script) {
        try {
            GosuTestUtil.compileExpression(script, (ISymbolTable)new StandardSymbolTable(true), true);
            throw new IllegalArgumentException("The script \n\n\"" + script + "\"\n\ndid not cause a parse exception.");
        }
        catch (ParseResultsException e) {
            return e;
        }
    }

    public static void assertCausesPRE(String script, ResourceKey ... keys) {
        try {
            GosuTestUtil.eval(script);
            junit.framework.Assert.fail((String)"Should not have compiled");
        }
        catch (RuntimeException e) {
            junit.framework.Assert.assertTrue((boolean)(e.getCause() instanceof ParseResultsException));
            block2: for (ResourceKey k : keys) {
                for (IParseIssue pi : ((ParseResultsException)e.getCause()).getParseIssues()) {
                    if (!pi.getMessageKey().equals(k)) continue;
                    continue block2;
                }
                junit.framework.Assert.fail((String)("Should have found a parse issue with key " + k));
            }
        }
    }
}

