/*
 * Decompiled with CFR 0.152.
 */
package gw.test;

import gw.test.ITestWithMetadata;
import gw.test.TestClass;
import gw.util.Array;
import gw.util.GosuObjectUtil;
import gw.util.GosuStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public abstract class AssertUtil
extends TestCase
implements ITestWithMetadata {
    public static void assertArrayEquals(Object[] expected, Object[] got) {
        AssertUtil.assertArrayEquals(expected, got, new TestClass.EqualityTester(){

            @Override
            public boolean equals(Object expected, Object got) {
                if (expected != null && got != null && expected.getClass().isArray() && got.getClass().isArray() && Array.getLength((Object)expected) == Array.getLength((Object)got)) {
                    int length = Array.getLength((Object)expected);
                    for (int i = 0; i < length; ++i) {
                        if (this.equals(Array.get((Object)expected, (int)i), Array.get((Object)got, (int)i))) continue;
                        return false;
                    }
                    return true;
                }
                return GosuObjectUtil.equals((Object)expected, (Object)got);
            }
        });
    }

    public static void assertArrayEquals(Object[] expected, Object[] got, TestClass.EqualityTester tester) {
        if (expected == null) {
            if (got == null) {
                return;
            }
            AssertUtil.fail((String)"Expected null, got non-null");
        } else if (got == null) {
            AssertUtil.fail((String)"Expected non-null, got null");
        }
        boolean[] expectedFound = AssertUtil.makeFoundArray(expected.length);
        boolean[] gotFound = AssertUtil.makeFoundArray(got.length);
        block0: for (int i = 0; i < expected.length; ++i) {
            Object expectedObject = expected[i];
            for (int j = 0; j < got.length; ++j) {
                if (!tester.equals(expectedObject, got[j]) || gotFound[j]) continue;
                expectedFound[i] = true;
                gotFound[j] = true;
                continue block0;
            }
        }
        if (!AssertUtil.allTrue(expectedFound) || !AssertUtil.allTrue(gotFound)) {
            StringBuffer sb = new StringBuffer();
            sb.append("\nExpected:\n");
            AssertUtil.appendFoundStatus(sb, expected, expectedFound);
            sb.append("\nGot:\n");
            AssertUtil.appendFoundStatus(sb, got, gotFound);
            AssertUtil.fail((String)sb.toString());
        }
    }

    private static void appendFoundStatus(StringBuffer sb, Object[] expected, boolean[] expectedFound) {
        sb.append("[\n");
        for (int i = 0; i < expected.length; ++i) {
            Object o = expected[i];
            sb.append(expectedFound[i] ? "  " : "! ");
            sb.append(o);
            sb.append("\n");
        }
        sb.append("]\n");
    }

    private static boolean[] makeFoundArray(int length) {
        boolean[] found = new boolean[length];
        for (int i = 0; i < found.length; ++i) {
            found[i] = false;
        }
        return found;
    }

    private static boolean allTrue(boolean[] booleans) {
        for (boolean b : booleans) {
            if (b) continue;
            return false;
        }
        return true;
    }

    public static void assertArrayEquals(String message, Object[] o1, Object[] o2) {
        boolean equals = false;
        if (o1.length == o2.length) {
            equals = true;
            for (int i = 0; i < o1.length; ++i) {
                if (GosuObjectUtil.equals((Object)o1[i], (Object)o2[i])) continue;
                equals = false;
                break;
            }
        }
        AssertUtil.assertTrue((String)(message + " Arrays were not equal. Expected \n[" + GosuStringUtil.join((Object[])o1, (String)",") + "] but found \n[" + GosuStringUtil.join((Object[])o2, (String)",") + "]"), (boolean)equals);
    }

    public static void assertSetsEqual(Set o1, Set o2) {
        boolean equals = GosuObjectUtil.equals((Object)o1, (Object)o2);
        AssertUtil.assertTrue((String)("Sets were not equal.  Expected \n[" + GosuStringUtil.join((Collection)o1, (String)",") + "] but found \n[" + GosuStringUtil.join((Collection)o2, (String)",") + "]"), (boolean)equals);
    }

    public static void assertCollectionEquals(Collection o1, Collection o2) {
        AssertUtil.assertIterableEqualsIgnoreOrder(o1, o2);
    }

    public static void assertListEquals(List o1, List o2) {
        AssertUtil.assertIterableEquals((Iterable)o1, (Iterable)o2, "Lists");
    }

    public static void assertIterableEquals(Iterable o1, Iterable o2) {
        AssertUtil.assertIterableEquals((Iterable)AssertUtil.makeList(o1), (Iterable)AssertUtil.makeList(o2), "Iterables");
    }

    public static void assertCollectionEquals(Collection o1, Collection o2, Comparator c) {
        AssertUtil.assertIterableEquals(o1, o2, c, "Collections");
    }

    public static void assertListEquals(List o1, List o2, Comparator c) {
        AssertUtil.assertIterableEquals(o1, o2, c, "Lists");
    }

    public static void assertIterableEquals(Iterable o1, Iterable o2, Comparator c) {
        AssertUtil.assertIterableEquals(AssertUtil.makeList(o1), AssertUtil.makeList(o2), c, "Iterables");
    }

    public static void assertIterableEqualsIgnoreOrder(Iterable i1, Iterable i2) {
        Map count2;
        Map count1 = AssertUtil.makeHistogram(i1);
        if (!count1.equals(count2 = AssertUtil.makeHistogram(i2))) {
            AssertUtil.assertTrue((String)("Iterators were not equal ignoring order.  Expected [" + GosuStringUtil.join(i1.iterator(), (String)",") + "] but found [" + GosuStringUtil.join(i2.iterator(), (String)",") + "]"), (boolean)false);
        }
    }

    public static void assertZero(int i) {
        AssertUtil.assertTrue((String)("Should be zero, but found " + i), (i == 0 ? 1 : 0) != 0);
    }

    public static void assertZero(long i) {
        AssertUtil.assertTrue((String)("Should be zero, but found " + i), (i == 0L ? 1 : 0) != 0);
    }

    public static void assertMatchRegex(String message, String pattern, String result) {
        AssertUtil.assertTrue((String)(message + ": " + pattern + " does not match " + result), (boolean)result.matches(pattern));
    }

    private static Map makeHistogram(Iterable o1) {
        HashMap hist = new HashMap();
        if (o1 != null) {
            for (Object o : o1) {
                Integer integer = (Integer)hist.get(o);
                if (integer == null) {
                    hist.put(o, 0);
                    continue;
                }
                integer = integer + 1;
                hist.put(o, integer);
            }
        }
        return hist;
    }

    private static void assertIterableEquals(Iterable i1, Iterable i2, String s) {
        boolean equals = true;
        if (i1 == i2) {
            return;
        }
        Iterator e1 = i1.iterator();
        Iterator e2 = i2.iterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (o1 == null) {
                if (o2 == null) continue;
                equals = false;
                break;
            }
            if (o1.equals(o2)) continue;
            equals = false;
            break;
        }
        if (equals) {
            equals = !e1.hasNext() && !e2.hasNext();
        }
        AssertUtil.assertTrue((String)(s + " were not equal.  Expected \n[" + GosuStringUtil.join(i1.iterator(), (String)",") + "] but found \n[" + GosuStringUtil.join(i2.iterator(), (String)",") + "]"), (boolean)equals);
    }

    private static void assertIterableEquals(Iterable i1, Iterable i2, Comparator c, String s) {
        boolean equals = true;
        if (i1 == i2) {
            return;
        }
        Iterator e1 = i1.iterator();
        Iterator e2 = i2.iterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (o1 == null) {
                if (o2 == null) continue;
                equals = false;
                break;
            }
            if (c.compare(o1, o2) == 0) continue;
            equals = false;
            break;
        }
        if (equals) {
            equals = !e1.hasNext() && !e2.hasNext();
        }
        AssertUtil.assertTrue((String)(s + " were not equal.  Expected \n[" + GosuStringUtil.join(i1.iterator(), (String)",") + "] but found \n[" + GosuStringUtil.join(i2.iterator(), (String)",") + "]"), (boolean)equals);
    }

    private static List makeList(Iterable o1) {
        ArrayList lst = new ArrayList();
        for (Object o : o1) {
            lst.add(o);
        }
        return lst;
    }

    public static void assertCausesException(Runnable r, Class<? extends Throwable> c) {
        try {
            r.run();
        }
        catch (Throwable t) {
            if (c.isAssignableFrom(t.getClass())) {
                return;
            }
            AssertUtil.fail((String)("Expecting exception of type " + c + ", but got exception of type " + t.getClass()));
        }
        AssertUtil.fail((String)("No exception was thrown when executing " + r + ".  Expected exception of type " + c));
    }
}

