/*
 * Decompiled with CFR 0.152.
 */
package gw.test.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestTimingData {
    private Map<String, ClassTimingData> _classTimingData = new HashMap<String, ClassTimingData>();
    private List<ClassTimingData> _orderedClasses = new ArrayList<ClassTimingData>();
    private List<MethodTimingData> _allMethods = new ArrayList<MethodTimingData>();
    private long _totalSuiteTime;

    public static void main(String[] args) {
        TestTimingData timingData = TestTimingData.readDataFromFile(new File(args[0]));
        timingData.printStatistics();
    }

    public static TestTimingData readDataFromFile(File f) {
        TestTimingData timingData = new TestTimingData();
        timingData.populateFromFile(f);
        return timingData;
    }

    private TestTimingData() {
    }

    public void printStatistics() {
        int i;
        long totalClassRunningTime = 0L;
        for (ClassTimingData ctd : this._orderedClasses) {
            totalClassRunningTime += ctd._time;
        }
        System.out.println("Total suite time:                " + this.formatNanoTime(this._totalSuiteTime));
        System.out.println("Total suite startup/teardown:    " + this.formatNanoTime(this._totalSuiteTime - totalClassRunningTime));
        System.out.println("Num test classes:                " + this._orderedClasses.size());
        System.out.println("Total test class time:           " + this.formatNanoTime(totalClassRunningTime));
        System.out.println("Average test class time:         " + this.formatNanoTime(totalClassRunningTime / (long)this._orderedClasses.size()));
        List<ClassTimingData> classesOrderedByTime = this.sortClassesByTime();
        int medianClassIndex = classesOrderedByTime.size() / 2;
        int percentileClassIndex = (int)(0.05 * (double)classesOrderedByTime.size());
        long percentileClassRunningTime = 0L;
        for (int i2 = 0; i2 <= percentileClassIndex; ++i2) {
            percentileClassRunningTime += classesOrderedByTime.get(i2).getTime();
        }
        System.out.println("Median test class time:          " + this.formatNanoTime(classesOrderedByTime.get(medianClassIndex).getTime()));
        System.out.println("95th percentile test class time: " + this.formatNanoTime(classesOrderedByTime.get(percentileClassIndex).getTime()));
        System.out.println("Time taken by slowest 5%:        " + this.formatNanoTime(percentileClassRunningTime));
        System.out.println("Percentage taken by slowest 5%:  " + this.formatPercentage((double)percentileClassRunningTime / (double)totalClassRunningTime));
        List<MethodTimingData> methodsOrderedByTime = this.sortMethodsByTime();
        int medianMethodIndex = methodsOrderedByTime.size() / 2;
        int percentileMethodIndex = (int)(0.05 * (double)methodsOrderedByTime.size());
        System.out.println("Median method time:              " + this.formatNanoTime(methodsOrderedByTime.get(medianMethodIndex).getTime()));
        System.out.println("95th percentile method time:     " + this.formatNanoTime(methodsOrderedByTime.get(percentileMethodIndex).getTime()));
        System.out.println("");
        System.out.println("Slowest 5% of test classes:");
        for (i = 0; i <= percentileClassIndex; ++i) {
            ClassTimingData ctd = classesOrderedByTime.get(i);
            System.out.println(this.formatNanoTime(ctd._time) + "   " + ctd._className);
        }
        System.out.println("");
        System.out.println("Slowest 5% of test methods:");
        for (i = 0; i <= percentileMethodIndex; ++i) {
            MethodTimingData mtd = methodsOrderedByTime.get(i);
            System.out.println(this.formatNanoTime(mtd.getTime()) + "   " + mtd.getClassName() + " " + mtd.getMethodName());
        }
        System.out.println("");
        System.out.println("All test classes:");
        for (ClassTimingData ctd : classesOrderedByTime) {
            System.out.println(this.formatNanoTime(ctd._time) + "   " + ctd._className);
        }
    }

    private List<ClassTimingData> sortClassesByTime() {
        ArrayList<ClassTimingData> classesOrderedByTime = new ArrayList<ClassTimingData>(this._orderedClasses);
        Collections.sort(classesOrderedByTime, new Comparator<ClassTimingData>(){

            @Override
            public int compare(ClassTimingData o1, ClassTimingData o2) {
                if (o1._time > o2._time) {
                    return -1;
                }
                if (o1._time == o2._time) {
                    return 0;
                }
                return 1;
            }
        });
        return classesOrderedByTime;
    }

    private List<MethodTimingData> sortMethodsByTime() {
        ArrayList<MethodTimingData> methodsOrderedByTime = new ArrayList<MethodTimingData>(this._allMethods);
        Collections.sort(methodsOrderedByTime, new Comparator<MethodTimingData>(){

            @Override
            public int compare(MethodTimingData o1, MethodTimingData o2) {
                if (o1._time > o2._time) {
                    return -1;
                }
                if (o1._time == o2._time) {
                    return 0;
                }
                return 1;
            }
        });
        return methodsOrderedByTime;
    }

    private String formatNanoTime(long ns) {
        return ns / 1000000L + " ms";
    }

    private String formatPercentage(double d) {
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMinimumFractionDigits(2);
        return format.format(d);
    }

    private void populateFromFile(File f) {
        try {
            List<String> fileLines = this.readLines(f);
            for (String line : fileLines) {
                if (!line.startsWith("***** TestRunTime")) continue;
                String message = line.substring(line.indexOf(91) + 1, line.indexOf(93));
                String time = line.substring(line.indexOf(93) + 2, line.lastIndexOf("*****") - 1);
                this.processTestLine(message, time);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void processTestLine(String message, String timeStr) {
        long time = Long.parseLong(timeStr);
        if (message.startsWith("Method ")) {
            String className = message.substring(message.indexOf(32) + 1, message.lastIndexOf(32));
            String methodName = message.substring(message.lastIndexOf(32) + 1, message.length());
            MethodTimingData mtd = new MethodTimingData(methodName, className, time);
            this._allMethods.add(mtd);
            this.getOrCreateClassTimingData(className).addMethod(mtd);
        } else if (message.startsWith("Class ")) {
            String className = message.substring(message.lastIndexOf(32) + 1, message.length());
            this.getOrCreateClassTimingData(className).setTime(time);
        } else if (message.startsWith("Suite")) {
            this._totalSuiteTime = time;
        } else {
            throw new IllegalArgumentException("Unrecognized timing message " + message);
        }
    }

    private ClassTimingData getOrCreateClassTimingData(String className) {
        ClassTimingData classTimingData = this._classTimingData.get(className);
        if (classTimingData == null) {
            classTimingData = new ClassTimingData(className);
            this._orderedClasses.add(classTimingData);
            this._classTimingData.put(className, classTimingData);
        }
        return classTimingData;
    }

    private List<String> readLines(File f) throws IOException {
        ArrayList<String> fileLines = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(f));
        String line = bufferedReader.readLine();
        while (line != null) {
            fileLines.add(line);
            line = bufferedReader.readLine();
        }
        return fileLines;
    }

    private static class MethodTimingData {
        private String _methodName;
        private String _className;
        private long _time;

        private MethodTimingData(String methodName, String className, long time) {
            this._methodName = methodName;
            this._className = className;
            this._time = time;
        }

        public String getMethodName() {
            return this._methodName;
        }

        public String getClassName() {
            return this._className;
        }

        public long getTime() {
            return this._time;
        }
    }

    private static class ClassTimingData {
        private String _className;
        private long _time;
        private List<MethodTimingData> _methods = new ArrayList<MethodTimingData>();

        private ClassTimingData(String className) {
            this._className = className;
        }

        public void setTime(long time) {
            this._time = time;
        }

        public void addMethod(MethodTimingData method) {
            this._methods.add(method);
        }

        public String getClassName() {
            return this._className;
        }

        public long getTime() {
            return this._time;
        }

        public List<MethodTimingData> getMethods() {
            return this._methods;
        }
    }
}

