/*
 * Decompiled with CFR 0.152.
 */
package gw.test;

import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.lang.init.ClasspathToGosuPathEntryUtil;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.test.ClassPathUtil;
import gw.test.IForwardingTestEnvironment;
import gw.test.TestClass;
import gw.test.TestClassFinder;
import gw.test.TestClassWrapper;
import gw.test.TestEnvironment;
import gw.test.TestExecutionManager;
import gw.test.TestSpec;
import gw.util.ILogger;
import gw.util.Predicate;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public class Suite<T extends Suite>
extends TestSuite {
    private boolean _testClassWrappersCreated;
    private boolean _suiteHasBeenSetUp;
    private final List<Predicate<IType>> _typeFilters = new ArrayList<Predicate<IType>>();
    private final List<Predicate<IFile>> _iFileFilters = new ArrayList<Predicate<IFile>>();
    private final List<Predicate<String>> _packageFilters = new ArrayList<Predicate<String>>();
    private final List<String> _withPackages = new ArrayList<String>();
    private final TreeSet<TestSpec> _testSpecs = new TreeSet();
    private final List<IDirectory> _gosuClassSearchPath = new ArrayList<IDirectory>();
    private final List<IDirectory> _javaClassSearchPath = new ArrayList<IDirectory>();
    private final List<String> _modules = new ArrayList<String>();
    private boolean _logErrorInfo = false;
    private int _splitNum = 1;
    private int _splitPartition = 0;
    private TestExecutionManager _executionManager;
    private TestEnvironment _testEnvironment;
    public static final String GOSU_SUITE_INCLUDE_TYPES = "gs.suite.tests";
    public static final String SPLIT_PARTITION = "split.partition";

    public Suite() {
        System.setProperty("checkedArithmetic", "true");
        Integer splitPartition = this.readIntegerSystemProperty(SPLIT_PARTITION);
        if (splitPartition != null && splitPartition > 1) {
            throw new UnsupportedOperationException("V3 tests doesn't support more than one split");
        }
        this._testEnvironment = new TestEnvironment();
        this._executionManager = new TestExecutionManager();
        this._executionManager.setEnvironment(this._testEnvironment);
    }

    public TestEnvironment getTestEnvironment() {
        return this._testEnvironment;
    }

    public final T javaAssertionsNotEnabled() {
        this._executionManager.setAssertionsMustBeEnabled(false);
        return this.thisAsT();
    }

    public final T withTest(IType type, String ... methods) {
        this.verifyNoFilters();
        this._testSpecs.add(new TestSpec(type.getName(), methods));
        return this.thisAsT();
    }

    public final T withTest(String type, String ... methods) {
        this.verifyNoFilters();
        this._testSpecs.add(new TestSpec(type, methods));
        return this.thisAsT();
    }

    public final T withTest(Class type, String ... methods) {
        this.verifyNoFilters();
        this._testSpecs.add(new TestSpec(type.getName(), methods));
        return this.thisAsT();
    }

    private void verifyNoFilters() {
        if (!(this._packageFilters.isEmpty() && this._iFileFilters.isEmpty() && this._typeFilters.isEmpty() && this._withPackages.isEmpty())) {
            throw new IllegalStateException("You cannot combine filters with explicitly specified tests");
        }
    }

    public final T withTestTypeFilter(Predicate<IType> filter) {
        if (!this._testSpecs.isEmpty()) {
            throw new IllegalStateException("You should add a test filter before any tests are added to the suite.");
        }
        this._typeFilters.add(filter);
        return this.thisAsT();
    }

    public final T withIFileFilter(Predicate<IFile> fileFilter) {
        this.ensureNoExplictlyAddedTests();
        this._iFileFilters.add(fileFilter);
        return this.thisAsT();
    }

    public final T withPackages(String ... packagePrefixes) {
        this.ensureNoExplictlyAddedTests();
        this._withPackages.addAll(Arrays.asList(packagePrefixes));
        return this.thisAsT();
    }

    private void ensureNoExplictlyAddedTests() {
        if (!this._testSpecs.isEmpty()) {
            throw new IllegalStateException("You cannot add filters to suites with explicitly added tests");
        }
    }

    public final T withPackageFilter(Predicate<String> fileFilter) {
        this.ensureNoExplictlyAddedTests();
        this._packageFilters.add(fileFilter);
        return this.thisAsT();
    }

    public final T withTimeout(long seconds) {
        this._executionManager.setSuiteTimeoutInMillis(seconds * 1000L);
        return this.thisAsT();
    }

    public T withTestEnvironment(TestEnvironment testEnvironment) {
        if (this._testEnvironment.isRemoteExecutionEnvironment()) {
            throw new IllegalStateException("For now, withTestEnvironment must be called BEFORE withRemoteServer is called");
        }
        this._testEnvironment = testEnvironment;
        this._executionManager.setEnvironment(this._testEnvironment);
        return this.thisAsT();
    }

    public final T logErrors() {
        this._logErrorInfo = true;
        return this.thisAsT();
    }

    public final T withModules(String ... moduleNames) {
        this._modules.addAll(Arrays.asList(moduleNames));
        return this.thisAsT();
    }

    public T withClasspathEntry(File srcDir) {
        this._gosuClassSearchPath.add(CommonServices.getFileSystem().getIDirectory(srcDir));
        this._javaClassSearchPath.add(CommonServices.getFileSystem().getIDirectory(srcDir));
        return this.thisAsT();
    }

    public final int countTestCases() {
        this.maybeCreateTestClassWrappers();
        return this._testSpecs.size();
    }

    public final Test testAt(int index) {
        this.maybeCreateTestClassWrappers();
        return super.testAt(index);
    }

    public final int testCount() {
        this.maybeCreateTestClassWrappers();
        return super.testCount();
    }

    public final Enumeration<Test> tests() {
        this.maybeCreateTestClassWrappers();
        return super.tests();
    }

    private void maybeCreateTestClassWrappers() {
        this.maybeInitSuite();
        if (!this._testClassWrappersCreated) {
            long start = System.currentTimeMillis();
            if (this._testSpecs.isEmpty()) {
                TestClassFinder finder = new TestClassFinder(this._iFileFilters, this._packageFilters, this._withPackages, this._typeFilters);
                this._testSpecs.addAll(finder.findTests(this._gosuClassSearchPath, this._javaClassSearchPath));
            }
            this.restrictTestSpecsToSpecifiedNames();
            for (TestSpec spec : this._testSpecs) {
                if (this._testEnvironment.isRemoteExecutionEnvironment()) {
                    String[] methods = spec.runAllMethods() ? null : spec.getMethods();
                    Test remoteWrapper = ((IForwardingTestEnvironment)((Object)this._testEnvironment)).makeRemoteTestClassWrapper(this._executionManager, spec.getTestTypeName(), methods);
                    this.addTest(remoteWrapper);
                    continue;
                }
                IType type = spec.getTestType();
                this.addTest((Test)new TestClassWrapper(this._executionManager, type, spec.getMethods()));
            }
            this._testClassWrappersCreated = true;
            long end = System.currentTimeMillis();
            System.out.println("Test wrappers created in " + (end - start) + "ms");
            if (this._testEnvironment.isDynamicallyDeterminedEnvironment()) {
                this._testEnvironment = this.determineTestEnvironmentBasedOnTestDefaults();
                System.out.println("Dynamically determined the test environment to be " + this._testEnvironment.getClass());
                if (this._testEnvironment instanceof IForwardingTestEnvironment) {
                    this._testEnvironment.initializeTypeSystem();
                }
                this._executionManager.setEnvironment(this._testEnvironment);
            }
        }
    }

    private TestEnvironment determineTestEnvironmentBasedOnTestDefaults() {
        TestEnvironment defaultEnv = null;
        TestClass defaultEnvTest = null;
        for (Test t : this.testsAsList()) {
            if (t instanceof TestClassWrapper) {
                if (((TestClassWrapper)t).testCount() > 0) {
                    Test firstTest = (Test)((TestClassWrapper)t).tests().nextElement();
                    if (firstTest instanceof TestClass) {
                        TestEnvironment env = ((TestClass)firstTest).createDefaultEnvironment();
                        if (defaultEnv == null) {
                            defaultEnv = env;
                            defaultEnvTest = (TestClass)firstTest;
                            continue;
                        }
                        if (defaultEnv.getClass().equals(env.getClass())) continue;
                        throw new IllegalStateException("The test " + defaultEnvTest.getClassName() + " requires the " + defaultEnv.getClass() + " environment, while the " + ((TestClass)firstTest).getClassName() + " test requires the " + env.getClass() + " environment.  Automatic resolution of the appropriate test environment will only work if all tests in the suite use the exact same default test environment.");
                    }
                    throw new IllegalStateException("Found a test that was a " + firstTest.getClass() + " instead of a TestClass");
                }
                throw new IllegalStateException("Found a test class " + ((TestClassWrapper)t).getBackingType().getName() + " that has no tests.");
            }
            throw new IllegalStateException("Found a test that was a " + t.getClass() + " instead of a TestClassWrapper");
        }
        return defaultEnv;
    }

    private void maybeInitSuite() {
        if (!this._suiteHasBeenSetUp) {
            this.initTypeSystem();
            if (this._gosuClassSearchPath.isEmpty() && this._javaClassSearchPath.isEmpty() && this._testSpecs.isEmpty()) {
                this._gosuClassSearchPath.addAll(this.createDefaultGosuClassSearchPath());
                this._javaClassSearchPath.addAll(this.createDefaultJavaClassSearchPath());
            }
            this._suiteHasBeenSetUp = true;
        }
    }

    protected List<IDirectory> createDefaultGosuClassSearchPath() {
        ArrayList<IDirectory> gosuClassSearchPath = new ArrayList<IDirectory>();
        List sourceEntries = TypeSystem.getCurrentModule().getSourcePath();
        for (IDirectory dir : sourceEntries) {
            if (this._modules.isEmpty()) {
                gosuClassSearchPath.add(dir);
                continue;
            }
            IDirectory moduleRoot = ClasspathToGosuPathEntryUtil.findModuleRootFromSourceEntry((IDirectory)dir);
            if (!this._modules.contains(moduleRoot.getName())) continue;
            gosuClassSearchPath.add(dir);
        }
        return gosuClassSearchPath;
    }

    protected List<IDirectory> createDefaultJavaClassSearchPath() {
        ArrayList<IDirectory> javaClassSearchPath = new ArrayList<IDirectory>();
        List<IDirectory> classPathParts = ClassPathUtil.constructClasspathFromSystemClasspath();
        for (IDirectory dir : classPathParts) {
            javaClassSearchPath.add(dir);
        }
        return javaClassSearchPath;
    }

    private void initTypeSystem() {
        this._executionManager.maybeInitTypeSystem();
    }

    public void logError(String o) {
        if (this._logErrorInfo) {
            ILogger logger = CommonServices.getEntityAccess().getLogger();
            logger.warn((Object)o);
        }
    }

    public void run(TestResult result) {
        this.maybeCreateTestClassWrappers();
        this._executionManager.setTestsFromSuite(this.testsAsListOfSuites());
        this.beforeSuite();
        super.run(result);
    }

    protected void beforeSuite() {
    }

    public final boolean runViaStaticSuiteMethod() {
        IType iType = TypeSystem.getTypeFromObject((Object)((Object)this));
        IMethodInfo method = iType.getTypeInfo().getMethod((CharSequence)"suite", new IType[0]);
        Test test = (Test)method.getCallHandler().handleCall(null, new Object[0]);
        return this.runImpl(test).wasSuccessful();
    }

    private Result runImpl(Test test) {
        JUnitCore runner = new JUnitCore();
        TextListener txtListener = new TextListener(System.out);
        runner.addListener((RunListener)txtListener);
        return runner.run(test);
    }

    public final Result run() {
        return this.runImpl((Test)this);
    }

    public List<Test> testsAsList() {
        Enumeration<Test> testEnumeration = this.tests();
        ArrayList<Test> testArrayList = new ArrayList<Test>();
        while (testEnumeration.hasMoreElements()) {
            Test test = testEnumeration.nextElement();
            testArrayList.add(test);
        }
        return testArrayList;
    }

    public List<TestSuite> testsAsListOfSuites() {
        Enumeration<Test> testEnumeration = this.tests();
        ArrayList<TestSuite> testArrayList = new ArrayList<TestSuite>();
        while (testEnumeration.hasMoreElements()) {
            Test test = testEnumeration.nextElement();
            testArrayList.add((TestSuite)test);
        }
        return testArrayList;
    }

    public boolean isLoggingErrors() {
        return this._logErrorInfo;
    }

    private T thisAsT() {
        return (T)((Object)this);
    }

    private Integer readIntegerSystemProperty(String name) {
        String splitString = System.getProperty(name);
        if (splitString != null) {
            try {
                return Integer.valueOf(splitString);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid System Property value for '" + name + "': \"" + splitString + "\". " + e.getMessage());
            }
        }
        return null;
    }

    private void restrictTestSpecsToSpecifiedPartition() {
        int splitStart = 0;
        int splitEnd = this._testSpecs.size();
        if (this._splitNum > 1) {
            float splitSize = (float)this._testSpecs.size() / (float)this._splitNum;
            splitStart = Math.round(splitSize * (float)this._splitPartition);
            if (this._splitPartition != this._splitNum - 1) {
                splitEnd = Math.round(splitSize * (float)(this._splitPartition + 1)) - 1;
            }
        }
        System.out.println("Number of classes = " + this._testSpecs.size());
        System.out.println("Number of splits  = " + (this._splitNum <= 0 ? 1 : this._splitNum));
        int i = 0;
        Iterator<TestSpec> it = this._testSpecs.iterator();
        while (it.hasNext()) {
            TestSpec spec = it.next();
            if (i < splitStart || i >= splitEnd) {
                it.remove();
            }
            ++i;
        }
    }

    private void restrictTestSpecsToSpecifiedNames() {
        String includedTests = System.getProperty(GOSU_SUITE_INCLUDE_TYPES);
        if (includedTests != null) {
            System.out.println("System property gs.suite.tests used, so only running tests specified:");
            System.out.println(includedTests);
            String[] includedTestsArray = includedTests.replace(" ", "").split(",");
            HashSet<String> includedTestSet = new HashSet<String>(Arrays.asList(includedTestsArray));
            Iterator<TestSpec> it = this._testSpecs.iterator();
            while (it.hasNext()) {
                TestSpec spec = it.next();
                if (includedTestSet.contains(spec.getTestType().getName())) continue;
                it.remove();
            }
        }
    }
}

