/*
 * Decompiled with CFR 0.152.
 */
package gw.test;

import gw.lang.GosuShop;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IHasJavaClass;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.test.ITestWithMetadata;
import gw.test.TestClassHelper;
import gw.test.TestEnvironment;
import gw.test.TestExecutionManager;
import gw.test.TestMetadata;
import gw.test.TestSpec;
import gw.testharness.IncludeInTestResults;
import gw.testharness.KnownBreak;
import gw.testharness.KnownBreakQualifier;
import gw.util.Array;
import gw.util.GosuExceptionUtil;
import gw.util.GosuObjectUtil;
import gw.util.GosuStringUtil;
import gw.util.Predicate;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public abstract class TestClass
extends TestCase
implements ITestWithMetadata {
    private String _pkgName;
    private String _className;
    private TestExecutionManager _executionManager;
    private static final ThreadLocal<TestExecutionManager> THREAD_LOCAL_EXECUTION_MANAGER = new ThreadLocal();
    private List<TestMetadata> _metadata = new ArrayList<TestMetadata>();
    private boolean _doNotRun;
    private boolean _knownBreak;
    private static final Map<String, Integer> _numberOfInstancesCreatedByTypeName = new HashMap<String, Integer>();
    private boolean _isGosuTest;
    private static Boolean _skipKnownBreakTests = null;

    protected TestClass() {
        this.initInternalData();
    }

    protected TestClass(String s) {
        super(s);
        this.initInternalData();
    }

    protected TestClass(boolean shouldInit) {
        if (shouldInit) {
            this.initInternalData();
        }
    }

    protected TestClass(String s, boolean shouldInit) {
        super(s);
        if (shouldInit) {
            this.initInternalData();
        }
    }

    public boolean isGosuTest() {
        return this._isGosuTest;
    }

    public void setGosuTest(boolean gosuTest) {
        this._isGosuTest = gosuTest;
    }

    protected void initInternalData() {
        String fullName = this.getFullClassNameInternal();
        int lastDot = fullName.lastIndexOf(".");
        this._pkgName = fullName.substring(0, lastDot).replace("_proxy_.", "");
        this._className = fullName.substring(lastDot + 1, fullName.length()).replace('$', '.');
        Integer numberOfInstances = _numberOfInstancesCreatedByTypeName.get(this.getTypeName());
        if (numberOfInstances == null) {
            _numberOfInstancesCreatedByTypeName.put(this.getTypeName(), 1);
        } else {
            _numberOfInstancesCreatedByTypeName.put(this.getTypeName(), numberOfInstances + 1);
        }
    }

    protected String getFullClassNameInternal() {
        return this.getClass().getName();
    }

    public static Integer getNumberOfInstancesOfTestClassCreated(String typeName) {
        return _numberOfInstancesCreatedByTypeName.get(typeName);
    }

    protected final void setUp() throws Exception {
        super.setUp();
        if (!this.getType().getName().endsWith("Test")) {
            throw new IllegalStateException("All subclasses of TestClass must have a name that ends with \"Test\"");
        }
        if (this._executionManager == null || this._executionManager.assertionsMustBeEnabled()) {
            try {
                assert (false);
                throw new IllegalStateException("Assertions must be enabled for tests to be run properly.");
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
        }
    }

    public void setExecutionManager(TestExecutionManager executionManager) {
        this._executionManager = executionManager;
    }

    protected final void tearDown() throws Exception {
        super.tearDown();
    }

    public void beforeTestClass() {
    }

    public void beforeTestMethod() {
    }

    public void afterTestMethod(Throwable possibleException) {
    }

    public void afterTestClass() {
    }

    public void run(TestResult result) {
        this.getExecutionManager().runTestClass(this, result);
    }

    public void reallyRun(TestResult result) {
        super.run(result);
    }

    public void runBare() throws Throwable {
        this.getExecutionManager().runTestClassBare(this);
    }

    public void reallyRunBare() throws Throwable {
        this.initMetadata(this.getName());
        super.runBare();
    }

    public String toString() {
        return this.getName() + "(" + this.getTypeName() + ")";
    }

    public void setName(String name) {
        super.setName(name);
    }

    public String getName() {
        return super.getName();
    }

    protected TestExecutionManager getExecutionManager() {
        if (this._executionManager == null) {
            return this.getThreadLocalExecutionManager();
        }
        return this._executionManager;
    }

    private TestExecutionManager getThreadLocalExecutionManager() {
        TestExecutionManager executionManager = THREAD_LOCAL_EXECUTION_MANAGER.get();
        if (executionManager == null) {
            executionManager = new TestExecutionManager();
            executionManager.setEnvironment(this.createDefaultEnvironment());
            THREAD_LOCAL_EXECUTION_MANAGER.set(executionManager);
        }
        return executionManager;
    }

    public TestEnvironment createDefaultEnvironment() {
        return new TestEnvironment();
    }

    protected final void runTest() throws Throwable {
        if (this._knownBreak) {
            System.out.println("**** Test method " + this.getName() + " is marked as a known break.  Run tests with -Dgw.tests.skip.knownbreak=true to skip known breaks.");
        }
        if (this._doNotRun) {
            System.out.println("*** Skipping test method " + this.getName() + ", as it's marked @Disabled, @ManualTest, or @InProgress");
        } else if (this._knownBreak && TestClass.skipKnownBreakTests()) {
            System.out.println("*** Skipping test method " + this.getName() + ", as it's marked @KnownBreak and the gw.tests.skip.knownbreak system parameter is set to true.");
        } else {
            this.doRunTest(this.getName());
        }
    }

    private static boolean skipKnownBreakTests() {
        if (_skipKnownBreakTests == null) {
            String propValue = System.getProperty("gw.tests.skip.knownbreak");
            _skipKnownBreakTests = propValue != null ? Boolean.valueOf(propValue) : Boolean.valueOf(false);
        }
        return _skipKnownBreakTests;
    }

    protected void doRunTest(String name) throws Throwable {
        Method runMethod;
        IType type = this.getType();
        if (type instanceof IJavaType && ((IHasJavaClass)this.getType()).getBackingClass() == null) {
            ClassLoader cl = type.getTypeLoader().getModule().getModuleTypeLoader().getDefaultTypeLoader().getGosuClassLoader().getActualLoader();
            Class<?> testClass = Class.forName(type.getName(), true, cl);
            runMethod = testClass.getMethod(name, new Class[0]);
        } else {
            runMethod = ((IHasJavaClass)this.getType()).getBackingClass().getMethod(name, new Class[0]);
        }
        if (runMethod == null) {
            TestClass.fail((String)("Method \"" + name + "\" not found"));
        }
        if (!Modifier.isPublic((int)runMethod.getModifiers())) {
            TestClass.fail((String)("Method \"" + name + "\" should be public"));
        }
        try {
            runMethod.invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e.getTargetException());
        }
    }

    public IType getType() {
        return TypeSystem.getFromObject((Object)this);
    }

    public String getTypeName() {
        return this._pkgName + "." + this._className;
    }

    public String getClassName() {
        return this._className;
    }

    public String getPackageName() {
        return this._pkgName;
    }

    public static void assertArrayEquals(Object[] expected, Object[] got) {
        TestClass.assertArrayEquals(expected, got, new EqualityTester(){

            @Override
            public boolean equals(Object expected, Object got) {
                if (expected != null && got != null && expected.getClass().isArray() && got.getClass().isArray() && Array.getLength((Object)expected) == Array.getLength((Object)got)) {
                    int length = Array.getLength((Object)expected);
                    for (int i = 0; i < length; ++i) {
                        if (this.equals(Array.get((Object)expected, (int)i), Array.get((Object)got, (int)i))) continue;
                        return false;
                    }
                    return true;
                }
                return GosuObjectUtil.equals((Object)expected, (Object)got);
            }
        });
    }

    public static void assertArrayEquals(String message, byte[] expected, byte[] actual) {
        if (expected.length != actual.length) {
            TestClass.fail((String)(message + " - expected array length of " + expected.length + " but got " + actual.length));
            for (int i = 0; i < expected.length; ++i) {
                TestClass.assertEquals((String)message, (byte)expected[i], (byte)actual[i]);
            }
        }
    }

    public static void assertArrayEquals(Object[] expected, Object[] got, EqualityTester tester) {
        if (expected == null) {
            if (got == null) {
                return;
            }
            TestClass.fail((String)"Expected null, got non-null");
        } else if (got == null) {
            TestClass.fail((String)"Expected non-null, got null");
        }
        boolean[] expectedFound = TestClass.makeFoundArray(expected.length);
        boolean[] gotFound = TestClass.makeFoundArray(got.length);
        block0: for (int i = 0; i < expected.length; ++i) {
            Object expectedObject = expected[i];
            for (int j = 0; j < got.length; ++j) {
                if (!tester.equals(expectedObject, got[j]) || gotFound[j]) continue;
                expectedFound[i] = true;
                gotFound[j] = true;
                continue block0;
            }
        }
        if (!TestClass.allTrue(expectedFound) || !TestClass.allTrue(gotFound)) {
            StringBuffer sb = new StringBuffer();
            sb.append("\nExpected:\n");
            TestClass.appendFoundStatus(sb, expected, expectedFound);
            sb.append("\nGot:\n");
            TestClass.appendFoundStatus(sb, got, gotFound);
            TestClass.fail((String)sb.toString());
        }
    }

    private static void appendFoundStatus(StringBuffer sb, Object[] expected, boolean[] expectedFound) {
        sb.append("[\n");
        for (int i = 0; i < expected.length; ++i) {
            Object o = expected[i];
            sb.append(expectedFound[i] ? "  " : "! ");
            sb.append(o);
            sb.append("\n");
        }
        sb.append("]\n");
    }

    private static boolean[] makeFoundArray(int length) {
        boolean[] found = new boolean[length];
        for (int i = 0; i < found.length; ++i) {
            found[i] = false;
        }
        return found;
    }

    private static boolean allTrue(boolean[] booleans) {
        for (boolean b : booleans) {
            if (b) continue;
            return false;
        }
        return true;
    }

    public static void assertArrayEquals(String message, Object[] o1, Object[] o2) {
        boolean equals = false;
        if (o1.length == o2.length) {
            equals = true;
            for (int i = 0; i < o1.length; ++i) {
                if (GosuObjectUtil.equals((Object)o1[i], (Object)o2[i])) continue;
                equals = false;
                break;
            }
        }
        TestClass.assertTrue((String)(message + " Arrays were not equal. Expected \n[" + GosuStringUtil.join((Object[])o1, (String)",") + "] but found \n[" + GosuStringUtil.join((Object[])o2, (String)",") + "]"), (boolean)equals);
    }

    public static void assertSetsEqual(Set o1, Set o2) {
        boolean equals = GosuObjectUtil.equals((Object)o1, (Object)o2);
        TestClass.assertTrue((String)("Sets were not equal.  Expected \n[" + GosuStringUtil.join((Collection)o1, (String)",") + "] but found \n[" + GosuStringUtil.join((Collection)o2, (String)",") + "]"), (boolean)equals);
    }

    public static void assertCollectionEquals(Collection o1, Collection o2) {
        TestClass.assertIterableEqualsIgnoreOrder(o1, o2);
    }

    public static void assertListEquals(List o1, List o2) {
        TestClass.assertIterableEquals((Iterable)o1, (Iterable)o2, "Lists");
    }

    public static void assertIterableEquals(Iterable o1, Iterable o2) {
        TestClass.assertIterableEquals((Iterable)TestClass.makeList(o1), (Iterable)TestClass.makeList(o2), "Iterables");
    }

    public static void assertCollectionEquals(Collection o1, Collection o2, Comparator c) {
        TestClass.assertIterableEquals(o1, o2, c, "Collections");
    }

    public static void assertListEquals(List o1, List o2, Comparator c) {
        TestClass.assertIterableEquals(o1, o2, c, "Lists");
    }

    public static void assertIterableEquals(Iterable o1, Iterable o2, Comparator c) {
        TestClass.assertIterableEquals(TestClass.makeList(o1), TestClass.makeList(o2), c, "Iterables");
    }

    public static void assertIterableEqualsIgnoreOrder(Iterable i1, Iterable i2) {
        Map count2;
        Map count1 = TestClass.makeHistogram(i1);
        if (!count1.equals(count2 = TestClass.makeHistogram(i2))) {
            TestClass.assertTrue((String)("Iterators were not equal ignoring order.  Expected [" + GosuStringUtil.join(i1.iterator(), (String)",") + "] but found [" + GosuStringUtil.join(i2.iterator(), (String)",") + "]"), (boolean)false);
        }
    }

    public static void assertZero(int i) {
        TestClass.assertTrue((String)("Should be zero, but found " + i), (i == 0 ? 1 : 0) != 0);
    }

    public static void assertZero(long i) {
        TestClass.assertTrue((String)("Should be zero, but found " + i), (i == 0L ? 1 : 0) != 0);
    }

    public static void assertMatchRegex(String message, String pattern, String result) {
        TestClass.assertTrue((String)(message + ": " + pattern + " does not match " + result), (boolean)result.matches(pattern));
    }

    private static Map makeHistogram(Iterable o1) {
        HashMap hist = new HashMap();
        if (o1 != null) {
            for (Object o : o1) {
                Integer integer = (Integer)hist.get(o);
                if (integer == null) {
                    hist.put(o, 0);
                    continue;
                }
                integer = integer + 1;
                hist.put(o, integer);
            }
        }
        return hist;
    }

    private static void assertIterableEquals(Iterable i1, Iterable i2, String s) {
        boolean equals = true;
        if (i1 == i2) {
            return;
        }
        Iterator e1 = i1.iterator();
        Iterator e2 = i2.iterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (o1 == null) {
                if (o2 == null) continue;
                equals = false;
                break;
            }
            if (o1.equals(o2)) continue;
            equals = false;
            break;
        }
        if (equals) {
            equals = !e1.hasNext() && !e2.hasNext();
        }
        TestClass.assertTrue((String)(s + " were not equal.  Expected \n[" + GosuStringUtil.join(i1.iterator(), (String)",") + "] but found \n[" + GosuStringUtil.join(i2.iterator(), (String)",") + "]"), (boolean)equals);
    }

    private static void assertIterableEquals(Iterable i1, Iterable i2, Comparator c, String s) {
        boolean equals = true;
        if (i1 == i2) {
            return;
        }
        Iterator e1 = i1.iterator();
        Iterator e2 = i2.iterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (o1 == null) {
                if (o2 == null) continue;
                equals = false;
                break;
            }
            if (c.compare(o1, o2) == 0) continue;
            equals = false;
            break;
        }
        if (equals) {
            equals = !e1.hasNext() && !e2.hasNext();
        }
        TestClass.assertTrue((String)(s + " were not equal.  Expected \n[" + GosuStringUtil.join(i1.iterator(), (String)",") + "] but found \n[" + GosuStringUtil.join(i2.iterator(), (String)",") + "]"), (boolean)equals);
    }

    private static List makeList(Iterable o1) {
        ArrayList lst = new ArrayList();
        for (Object o : o1) {
            lst.add(o);
        }
        return lst;
    }

    public int getTotalNumTestMethods() {
        MethodList methods = this.getType().getTypeInfo().getMethods();
        int count = 0;
        for (IMethodInfo method : methods) {
            if (method.isStatic() || !method.getName().startsWith("test") || method.getParameters().length != 0) continue;
            ++count;
        }
        return count;
    }

    public List<TestMetadata> getMetadata() {
        return this._metadata;
    }

    protected void addMetadata(Collection<TestMetadata> metadata) {
        this._metadata.addAll(metadata);
        for (TestMetadata testMetadata : metadata) {
            if (testMetadata.shouldNotRunTest()) {
                this._doNotRun = true;
                continue;
            }
            if (!testMetadata.getName().equals(KnownBreak.class.getName())) continue;
            this._knownBreak = true;
        }
    }

    public Collection<TestMetadata> createMethodMetadata(String method) {
        if (this.getType() instanceof IJavaType) {
            try {
                Method testMethod = ((IJavaType)this.getType()).getBackingClass().getMethod(method, new Class[0]);
                return this.createMetadata(testMethod.getAnnotations());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Method not found: " + this.getType().getDisplayName() + "." + method);
            }
        }
        IMethodInfo testMethod = this.getType().getTypeInfo().getMethod((CharSequence)method, new IType[0]);
        if (testMethod == null) {
            throw new IllegalStateException("Method not found: " + this.getType().getDisplayName() + "." + method);
        }
        return this.createMetadata(testMethod.getAnnotations());
    }

    public Collection<TestMetadata> createClassMetadata() {
        if (this.getType() instanceof IJavaType) {
            return this.createMetadata(((IJavaType)this.getType()).getBackingClass().getAnnotations());
        }
        return this.createMetadata(this.getType().getTypeInfo().getAnnotations());
    }

    protected Collection<TestMetadata> createMetadata(List<IAnnotationInfo> annotationInfos) {
        HashMap<IType, TestMetadata> map = new HashMap<IType, TestMetadata>();
        for (IAnnotationInfo ai : annotationInfos) {
            if (!this.isMetaAnnotationInfo(ai)) continue;
            map.put(ai.getType(), new TestMetadata(ai));
        }
        if (map.containsKey(TypeSystem.get(KnownBreak.class))) {
            for (IAnnotationInfo ai : annotationInfos) {
                Predicate qualifierPredicate;
                if (!this.isKnownBreakQualifier(ai)) continue;
                try {
                    Object t = ai.getType().getTypeInfo().getAnnotation(TypeSystem.get(KnownBreakQualifier.class)).getFieldValue("value");
                    IType type = t instanceof Class ? TypeSystem.get((Class)((Class)t)) : (IType)t;
                    qualifierPredicate = (Predicate)type.getTypeInfo().getConstructor(new IType[0]).getConstructor().newInstance(new Object[0]);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (qualifierPredicate.evaluate((Object)ai)) continue;
                map.remove(TypeSystem.get(KnownBreak.class));
                break;
            }
        }
        return map.values();
    }

    private boolean isKnownBreakQualifier(IAnnotationInfo ai) {
        boolean isQualifier = false;
        for (IAnnotationInfo a : ai.getType().getTypeInfo().getAnnotations()) {
            if (!a.getName().equals(KnownBreakQualifier.class.getName())) continue;
            isQualifier = true;
            break;
        }
        return isQualifier;
    }

    protected boolean isMetaAnnotationInfo(IAnnotationInfo ai) {
        boolean isMetadata = false;
        for (IAnnotationInfo a : ai.getType().getTypeInfo().getAnnotations()) {
            if (!a.getName().equals(IncludeInTestResults.class.getName())) continue;
            isMetadata = true;
            break;
        }
        return isMetadata;
    }

    protected Collection<TestMetadata> createMetadata(Annotation[] annotations) {
        HashMap<Class<? extends Annotation>, TestMetadata> map = new HashMap<Class<? extends Annotation>, TestMetadata>();
        for (Annotation a : annotations) {
            if (!this.isMetaAnnotation(a)) continue;
            map.put(a.annotationType(), new TestMetadata(GosuShop.getAnnotationInfoFactory().createJavaAnnotation(a, (IFeatureInfo)this.getType().getTypeInfo())));
        }
        if (map.containsKey(KnownBreak.class)) {
            for (Annotation a : annotations) {
                Predicate<? super IAnnotationInfo> qualifierPredicate;
                if (!this.isKnownBreakQualifier(a)) continue;
                try {
                    qualifierPredicate = a.annotationType().getAnnotation(KnownBreakQualifier.class).value().newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (qualifierPredicate.evaluate((Object)GosuShop.getAnnotationInfoFactory().createJavaAnnotation(a, (IFeatureInfo)this.getType().getTypeInfo()))) continue;
                map.remove(KnownBreak.class);
                break;
            }
        }
        return map.values();
    }

    private boolean isKnownBreakQualifier(Annotation a) {
        return a.annotationType().getAnnotation(KnownBreakQualifier.class) != null;
    }

    protected boolean isMetaAnnotation(Annotation ai) {
        boolean isMetadata = false;
        for (Annotation a : ai.annotationType().getAnnotations()) {
            if (!(a instanceof IncludeInTestResults)) continue;
            isMetadata = true;
            break;
        }
        return isMetadata;
    }

    public void initMetadata(String method) {
        this.addMetadata(this.createClassMetadata());
        this.addMetadata(this.createMethodMetadata(method));
    }

    public static void assertCausesException(Runnable r, Class<? extends Throwable> c) {
        try {
            r.run();
        }
        catch (Throwable t) {
            if (c.isAssignableFrom(t.getClass())) {
                return;
            }
            TestClass.fail((String)("Expecting exception of type " + String.valueOf(c) + ", but got exception of type " + String.valueOf(t.getClass())));
        }
        TestClass.fail((String)("No exception was thrown when executing " + String.valueOf(r) + ".  Expected exception of type " + String.valueOf(c)));
    }

    public static TestClass createTestClass(IType testType) {
        IConstructorInfo noArgConstructor = testType.getTypeInfo().getConstructor(new IType[0]);
        if (noArgConstructor != null) {
            return (TestClass)noArgConstructor.getConstructor().newInstance(new Object[0]);
        }
        IConstructorInfo oneArgConstructor = testType.getTypeInfo().getConstructor(new IType[]{JavaTypes.STRING()});
        if (oneArgConstructor != null) {
            return (TestClass)oneArgConstructor.getConstructor().newInstance(new Object[]{"temp"});
        }
        throw new IllegalArgumentException("Type " + testType.getName() + " does not have either a no-arg constructor or a one-arg constructor that takes a String");
    }

    public static <T extends TestClass> Test _suite(Class<T> clazz) {
        return TestClassHelper.createTestSuite(clazz, TestSpec.extractTestMethods(clazz));
    }

    public static interface EqualityTester {
        public boolean equals(Object var1, Object var2);
    }
}

