/*
 * Decompiled with CFR 0.152.
 */
package gw.test;

import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.fs.IResource;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.test.TestClass;
import gw.test.TestSpec;
import gw.util.GosuClassUtil;
import gw.util.ILogger;
import gw.util.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

class TestClassFinder {
    private final List<Predicate<IFile>> _iFileFilters;
    private final List<Predicate<String>> _packageFilters;
    private final List<String> _withPackages;
    private final List<Predicate<IType>> _typeFilters;

    public TestClassFinder(List<Predicate<IFile>> iFileFilters, List<Predicate<String>> packageFilters, List<String> withPackages, List<Predicate<IType>> typeFilters) {
        this._iFileFilters = iFileFilters;
        this._packageFilters = packageFilters;
        this._withPackages = withPackages;
        this._typeFilters = typeFilters;
    }

    public TreeSet<TestSpec> findTests(List<IDirectory> gosuSourceRoots, List<IDirectory> javaClassRoots) {
        TreeSet<TestSpec> results = new TreeSet<TestSpec>();
        for (IDirectory dir : gosuSourceRoots) {
            for (IType type : this.findTestTypes(dir, TestClassFindType.GOSU)) {
                results.add(new TestSpec(type.getName(), new String[0]));
            }
        }
        for (IDirectory dir : javaClassRoots) {
            for (IType type : this.findTestTypes(dir, TestClassFindType.JAVA)) {
                results.add(new TestSpec(type.getName(), new String[0]));
            }
        }
        return results;
    }

    private List<IType> findTestTypes(IDirectory entry, TestClassFindType findType) {
        ArrayList<IType> types = new ArrayList<IType>();
        this.findTestTypesImpl(entry, entry, findType, types);
        return types;
    }

    private void findTestTypesImpl(IDirectory root, IDirectory entry, TestClassFindType findType, ArrayList<IType> types) {
        if (entry.exists()) {
            for (IFile iFile : entry.listFiles()) {
                this.possiblyAddTest(iFile, root, findType, types);
            }
            for (IDirectory subDir : entry.listDirs()) {
                this.findTestTypesImpl(root, subDir, findType, types);
            }
        }
    }

    private void possiblyAddTest(IFile entry, IDirectory root, TestClassFindType findType, ArrayList<IType> types) {
        String relativeFileName;
        String typeName;
        if (this.shouldConsiderFile(entry, findType) && this.shouldConsiderTypeName(typeName = (relativeFileName = root.relativePath((IResource)entry)).replaceFirst("\\..*$", "").replace("/", "."))) {
            try {
                IType type = TypeSystem.getByFullName((String)typeName);
                if (this.shouldConsiderType(type)) {
                    types.add(type);
                }
            }
            catch (Exception e) {
                ILogger logger = CommonServices.getEntityAccess().getLogger();
                logger.warn((Object)("Could not load type " + typeName));
            }
        }
    }

    private boolean shouldConsiderFile(IFile entry, TestClassFindType findType) {
        if (findType == TestClassFindType.JAVA) {
            if (!entry.getName().endsWith("Test.class")) {
                return false;
            }
        } else if (findType == TestClassFindType.GOSU) {
            if (!entry.getName().endsWith("Test.gs")) {
                return false;
            }
        } else {
            throw new IllegalArgumentException("Unexpected find type " + String.valueOf((Object)findType));
        }
        for (Predicate<IFile> fileFilter : this._iFileFilters) {
            if (fileFilter.evaluate((Object)entry)) continue;
            return false;
        }
        return true;
    }

    private boolean shouldConsiderTypeName(String typeName) {
        String pkg = GosuClassUtil.getPackage((String)typeName);
        return this.matchesPackageFilters(pkg) && this.matchesIncludedPackages(pkg);
    }

    private boolean matchesPackageFilters(String packageName) {
        for (Predicate<String> packageFilter : this._packageFilters) {
            if (packageFilter.evaluate((Object)packageName)) continue;
            return false;
        }
        return true;
    }

    private boolean matchesIncludedPackages(String packageName) {
        if (this._withPackages.isEmpty()) {
            return true;
        }
        for (String withPackage : this._withPackages) {
            if (!packageName.startsWith(withPackage)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldConsiderType(IType type) {
        if (type.isAbstract() || !TypeSystem.get(TestClass.class).isAssignableFrom(type)) {
            return false;
        }
        for (Predicate<IType> typeFilter : this._typeFilters) {
            if (typeFilter.evaluate((Object)type)) continue;
            return false;
        }
        return true;
    }

    private static enum TestClassFindType {
        JAVA,
        GOSU;

    }
}

