/*
 * Decompiled with CFR 0.152.
 */
package gw.test;

import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.java.JavaTypes;
import gw.test.TestClass;
import gw.test.TestExecutionManager;
import gw.testharness.IncludeInTestResults;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class TestClassWrapper
extends TestSuite {
    private IType _type;
    private TestExecutionManager _executionManager;

    public TestClassWrapper(TestExecutionManager executionManager, IType type, String ... methods) {
        this._executionManager = executionManager;
        this._type = type;
        for (String method : methods) {
            this.addTest((Test)this.makeTest(this._type, method));
        }
    }

    public void runTest(Test test, TestResult result) {
        if (this._executionManager.hasTimedOut()) {
            result.addFailure(test, new AssertionFailedError(String.format("tests timed out", new Object[0])));
        } else if (this._executionManager.hasTimeOut()) {
            long timeout = this._executionManager.getTimeoutForCurrentTest();
            this.runWithTimeout(test, result, timeout);
        } else {
            super.runTest(test, result);
        }
    }

    private void runWithTimeout(final Test test, final TestResult result, long timeout) {
        ExecutorService service = Executors.newSingleThreadExecutor();
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                test.run(result);
                return null;
            }
        };
        Future<Object> future = service.submit(callable);
        service.shutdown();
        try {
            boolean terminated = service.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            if (!terminated) {
                service.shutdownNow();
            }
            future.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            result.addFailure(test, new AssertionFailedError(String.format("test timed out after %d milliseconds", timeout)));
            result.endTest(test);
            this._executionManager.markTimedOut();
        }
        catch (Throwable e) {
            if (e instanceof AssertionFailedError) {
                result.addFailure(test, (AssertionFailedError)e);
            }
            result.addFailure(test, new AssertionFailedError(e.getMessage()));
        }
    }

    public String getName() {
        return this._type.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TestCase makeTest(IType type, String method) {
        try {
            TestClass test;
            if (type.isValid()) {
                ITypeInfo typeInfo = type.getTypeInfo();
                IConstructorInfo noArgCons = typeInfo.getConstructor(new IType[0]);
                if (noArgCons != null) {
                    test = (TestClass)noArgCons.getConstructor().newInstance(new Object[0]);
                } else {
                    IConstructorInfo oneArgCons = typeInfo.getConstructor(new IType[]{JavaTypes.STRING()});
                    if (oneArgCons == null) throw new IllegalStateException("Test type " + String.valueOf(type) + " does not have either a no-arg constructor or a one-arg constructor taking a String");
                    test = (TestClass)oneArgCons.getConstructor().newInstance(new Object[]{method});
                }
            } else {
                test = new InvalidTestClass(this._type);
            }
            test.setExecutionManager(this._executionManager);
            test.setName(method);
            test.setGosuTest(this._type instanceof IGosuClass);
            test.initMetadata(method);
            return test;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ExceptionTestClass(type, e.getMessage());
        }
    }

    private static boolean isMetaAnnotationInfo(IAnnotationInfo ai) {
        boolean isMetadata = false;
        for (IAnnotationInfo a : ai.getType().getTypeInfo().getAnnotations()) {
            if (!a.getName().equals(IncludeInTestResults.class.getName())) continue;
            isMetadata = true;
            break;
        }
        return isMetadata;
    }

    public IType getBackingType() {
        return this._type;
    }

    private static class ExceptionTestClass
    extends TestClass {
        private IType _type;
        private String _message;

        private ExceptionTestClass(IType type, String message) {
            super(false);
            this._type = type;
            this._message = message;
            this.initInternalData();
        }

        @Override
        public void run(TestResult result) {
            result.addError((Test)this, (Throwable)new RuntimeException("Could not construct test " + this._type.getName() + ". Reason : " + this._message));
        }

        @Override
        public IType getType() {
            return this._type;
        }

        @Override
        protected String getFullClassNameInternal() {
            return this._type.getName();
        }
    }

    private static class InvalidTestClass
    extends TestClass {
        private IType _type;

        private InvalidTestClass(IType type) {
            super(false);
            this._type = type;
            this.initInternalData();
        }

        @Override
        public void run(TestResult result) {
            result.addError((Test)this, this.getCompileError(this._type));
        }

        @Override
        public IType getType() {
            return this._type;
        }

        private Throwable getCompileError(IType type) {
            if (type instanceof IGosuClass) {
                type.isValid();
                return ((IGosuClass)type).getParseResultsException();
            }
            return new IllegalStateException("Test type " + String.valueOf(type) + " is not valid.");
        }

        @Override
        protected String getFullClassNameInternal() {
            return this._type.getName();
        }
    }
}

