/*
 * Decompiled with CFR 0.152.
 */
package gw.test;

import gw.internal.ext.org.objectweb.asm.tree.MethodNode;
import gw.lang.UnstableAPI;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaBackedType;
import gw.test.TestClassHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

@UnstableAPI
public class TestSpec
implements Comparable<TestSpec> {
    private String _testType;
    private String[] _methods;

    public TestSpec(String type, String ... methods) {
        this._testType = type;
        this._methods = methods;
    }

    @Override
    public int compareTo(TestSpec o) {
        return this._testType.compareTo(o._testType);
    }

    public boolean runAllMethods() {
        return this._methods == null || this._methods.length == 0;
    }

    public String[] getMethods() {
        if (this.runAllMethods()) {
            return TestSpec.extractTestMethods(this.getTestType());
        }
        return this._methods;
    }

    public IType getTestType() {
        return TypeSystem.getByFullName((String)this._testType);
    }

    public String getTestTypeName() {
        return this._testType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestSpec testSpec = (TestSpec)o;
        if (!Arrays.equals(this._methods, testSpec._methods)) {
            return false;
        }
        return !(this._testType != null ? !this._testType.equals(testSpec._testType) : testSpec._testType != null);
    }

    public int hashCode() {
        int result = this._testType != null ? this._testType.hashCode() : 0;
        result = 31 * result + (this._methods != null ? Arrays.hashCode(this._methods) : 0);
        return result;
    }

    public static String[] extractTestMethods(IType testType) {
        List<Object> methodNames = new ArrayList();
        if (testType instanceof IJavaBackedType) {
            methodNames = TestSpec.extractTestMethods(((IJavaBackedType)testType).getBackingClass());
        } else {
            MethodList methodInfos = testType.getTypeInfo().getMethods();
            for (IMethodInfo methodInfo : methodInfos) {
                if (!TestSpec.isTestMethod(methodInfo)) continue;
                methodNames.add(methodInfo.getDisplayName());
            }
        }
        return methodNames.toArray(new String[methodNames.size()]);
    }

    public static List<String> extractTestMethods(Class<? extends TestCase> testClass) {
        HashSet<String> methodNames = new HashSet<String>();
        for (Method methodInfo : testClass.getMethods()) {
            if (!TestSpec.isTestMethod(methodInfo)) continue;
            methodNames.add(methodInfo.getName());
        }
        return TestSpec.sortMethodsAccordingToSourceOrder(methodNames, testClass);
    }

    private static List<String> sortMethodsAccordingToSourceOrder(Set<String> testMethods, Class<? extends TestCase> clazz) {
        ArrayList<String> sortedMethods = new ArrayList<String>();
        for (MethodNode method : TestClassHelper.getMethodsSorted(clazz)) {
            if (method.parameters != null && method.parameters.size() != 0 || !testMethods.remove(method.name)) continue;
            sortedMethods.add(method.name);
        }
        if (testMethods.size() != 0) {
            throw new IllegalArgumentException("Cannot find " + String.valueOf(testMethods) + " in the byte code of " + clazz.getName());
        }
        return sortedMethods;
    }

    static boolean isTestMethod(Method method) {
        return Modifier.isPublic((int)method.getModifiers()) && method.getParameterTypes().length == 0 && !Modifier.isStatic((int)method.getModifiers()) && method.getName().startsWith("test");
    }

    private static boolean isTestMethod(IMethodInfo methodInfo) {
        return methodInfo.isPublic() && methodInfo.getParameters().length == 0 && !methodInfo.isStatic() && methodInfo.getName().startsWith("test");
    }
}

