/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.exemplar.executor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.gradle.exemplar.executor.CommandExecutionResult;
import org.gradle.exemplar.executor.ExecutionMetadata;
import org.gradle.exemplar.model.Command;

public abstract class CommandExecutor {
    private final File directory;

    public CommandExecutor() {
        this.directory = null;
    }

    protected CommandExecutor(File directory) {
        this.directory = directory;
    }

    protected abstract int run(String var1, List<String> var2, List<String> var3, OutputStream var4);

    public void run(ProcessBuilder processBuilder, OutputStream outputStream) {
        this.run(processBuilder, outputStream, null, null).waitForSuccess();
    }

    protected RunHandle run(ProcessBuilder processBuilder, final OutputStream outputStream, final @Nullable OutputStream errorStream, final @Nullable InputStream inputStream) {
        if (this.directory != null) {
            processBuilder.directory(this.directory);
        }
        final String command = processBuilder.command().get(0);
        try {
            if (errorStream == null) {
                processBuilder.redirectErrorStream(true);
            }
            final Process process = processBuilder.start();
            ExecutorService executor = Executors.newFixedThreadPool(3);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    byte[] buffer = new byte[4096];
                    while (!CommandExecutor.this.readStream(process.getInputStream(), outputStream, command, buffer)) {
                    }
                }
            });
            if (errorStream != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        byte[] buffer = new byte[4096];
                        while (!CommandExecutor.this.readStream(process.getErrorStream(), errorStream, command, buffer)) {
                        }
                    }
                });
            }
            if (inputStream != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        byte[] buffer = new byte[4096];
                        OutputStream output = process.getOutputStream();
                        try {
                            int read;
                            do {
                                read = inputStream.read(buffer);
                                output.write(buffer);
                            } while (read != -1);
                            output.flush();
                            output.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Could not write input", e);
                        }
                    }
                });
            }
            return new RunHandle(processBuilder, process, executor);
        }
        catch (IOException e) {
            throw new RuntimeException(this.commandErrorMessage(processBuilder), e);
        }
    }

    private boolean readStream(InputStream inputStream, OutputStream outputStream, String command, byte[] buffer) {
        int nread;
        try {
            nread = inputStream.read(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read input from child process for command '" + command + "'", e);
        }
        if (nread < 0) {
            return true;
        }
        try {
            outputStream.write(buffer, 0, nread);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write output from child process for command '" + command + "'", e);
        }
        return false;
    }

    private String commandErrorMessage(ProcessBuilder processBuilder) {
        return "Could not run command " + StringUtils.join(processBuilder.command(), (String)" ");
    }

    public CommandExecutionResult execute(Command command, ExecutionMetadata executionMetadata) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int exitCode = this.run(command.getExecutable(), command.getArgs(), command.getFlags(), outputStream);
        return new CommandExecutionResult(command, exitCode, outputStream.toString(), executionMetadata);
    }

    public class RunHandle {
        private final ProcessBuilder processBuilder;
        private final Process process;
        private final ExecutorService executor;

        RunHandle(ProcessBuilder processBuilder, Process process, ExecutorService executor) {
            this.processBuilder = processBuilder;
            this.process = process;
            this.executor = executor;
        }

        public void waitForSuccess() {
            int result;
            try {
                result = this.process.waitFor();
            }
            catch (Exception e) {
                throw new RuntimeException(CommandExecutor.this.commandErrorMessage(this.processBuilder), e);
            }
            finally {
                this.shutdownExecutor();
            }
            if (result != 0) {
                throw new RuntimeException(CommandExecutor.this.commandErrorMessage(this.processBuilder) + ". Exited with result " + result);
            }
        }

        private void shutdownExecutor() {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

