/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.exemplar.test.normalizer;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.gradle.exemplar.executor.ExecutionMetadata;
import org.gradle.exemplar.test.normalizer.OutputNormalizer;

public class StripTrailingOutputNormalizer
implements OutputNormalizer {
    @Override
    public String normalize(String commandOutput, ExecutionMetadata executionMetadata) {
        return Arrays.stream(commandOutput.split("\\r?\\n", -1)).map(StripTrailingOutputNormalizer::stripTrailing).collect(Collectors.joining("\n"));
    }

    private static String stripTrailing(String self) {
        int len;
        int st = 0;
        char[] val = self.toCharArray();
        for (len = self.length(); st < len && Character.isSpaceChar(val[len - 1]); --len) {
        }
        return len < self.length() ? self.substring(0, len) : self;
    }
}

